/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.channel.context.statement.FieldType;
import com.huawei.gauss.channel.context.statement.ParamsData;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.AbstractGaussLob;
import com.huawei.gauss.jdbc.GaussPrepareStatement;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussParameterMetaDataImpl;
import com.huawei.gauss.jdbc.inner.GaussPrepareStatementHelper;
import com.huawei.gauss.jdbc.inner.GaussPreparedSql;
import com.huawei.gauss.jdbc.inner.GaussResultSetImpl;
import com.huawei.gauss.jdbc.inner.GaussStatementImpl;
import com.huawei.gauss.util.ZenithJDBCInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class GaussPrepareStmtImpl
extends GaussStatementImpl
implements GaussPrepareStatement {
    static final int BOOL_TRUE_VALUE = 1;
    static final int BOOL_FALSE_VALUE = 0;
    final String orginalSql;
    final GaussPreparedSql parsedSql;
    final ParamsData paramsData;
    boolean addBatched;
    int generatedKeyType = 2;

    public GaussPrepareStmtImpl(GaussConnectionImpl connection, String sql) throws SQLException {
        super(connection);
        this.orginalSql = sql;
        this.parsedSql = new GaussPreparedSql(sql);
        this.paramsData = new ParamsData(this.parsedSql.toServerParameterNo, connection.isBigEndianess(), connection.getIOClient());
    }

    protected void validateIsBatchInProgress() throws SQLException {
        if (this.addBatched) {
            throw ExceptionUtil.processJDBCException("Use executeBatch as batch is already added.");
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean execute() throws SQLException {
        this.validateOpened();
        this.reset();
        this.validateIsBatchInProgress();
        if (!this.addBatched) {
            this.paramsData.addBatch();
        }
        boolean result = false;
        try {
            result = GaussPrepareStatementHelper.execute(this);
        }
        finally {
            this.paramsData.clear();
        }
        if (result && this.resultSet != null) {
            if (this.fieldDefs == null || this.fieldDefs.length == 0) {
                this.fieldDefs = this.resultSet.rowsData.getFieldDefs();
            } else {
                this.resultSet.rowsData.resetFieldDefs(this.fieldDefs);
            }
        }
        return result;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet executeQuery() throws SQLException {
        this.validateOpened();
        this.reset();
        this.validateIsBatchInProgress();
        if (!this.addBatched) {
            this.paramsData.addBatch();
        }
        try {
            this.currRowSize = 0;
            this.resultSet = (GaussResultSetImpl)GaussPrepareStatementHelper.executeQuery(this);
            if (this.resultSet != null && this.getLangType() != 4 && this.resultSet.rowsData != null) {
                if (this.fieldDefs == null) {
                    this.fieldDefs = this.resultSet.rowsData.getFieldDefs();
                } else {
                    this.resultSet.rowsData.resetFieldDefs(this.fieldDefs);
                }
            }
        }
        finally {
            this.paramsData.clear();
        }
        return this.resultSet;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int executeUpdate() throws SQLException {
        this.validateOpened();
        this.reset();
        this.validateIsBatchInProgress();
        if (!this.addBatched) {
            this.paramsData.addBatch();
        }
        try {
            this.updateCount = GaussPrepareStatementHelper.executeUpdate(this);
        }
        finally {
            this.paramsData.clear();
        }
        return this.updateCount;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void addBatch() throws SQLException {
        this.validateOpened();
        this.paramsData.addBatch();
        this.addBatched = true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int[] executeBatch() throws SQLException {
        this.validateOpened();
        this.reset();
        if (!this.addBatched) {
            return null;
        }
        try {
            int[] nArray = GaussPrepareStatementHelper.executeBatch(this);
            return nArray;
        }
        finally {
            this.addBatched = false;
            this.paramsData.clear();
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (sqlType == 1111) {
            this.setParameterValue(parameterIndex, FieldType.getGaussTypeFromJDBCType(0), null);
        } else if (sqlType == 16) {
            this.setParameterValue(parameterIndex, FieldType.getGaussTypeFromJDBCType(4), null);
        } else {
            this.setParameterValue(parameterIndex, FieldType.getGaussTypeFromJDBCType(sqlType), null);
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.INTEGER, x ? 1 : 0);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.INTEGER, x);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.INTEGER, x);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.INTEGER, x);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.BIGINT, x);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.REAL, x);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.REAL, x);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.NUMERIC, x);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setString(int parameterIndex, String x) throws SQLException {
        int length;
        boolean toClob = false;
        if (x != null && (length = x.length()) * 3 > 8000) {
            if (length > 8000) {
                toClob = true;
            } else if (x.getBytes(this.gaussConnection.getIOClient().getCharset()).length > 8000) {
                toClob = true;
            }
        }
        if (toClob) {
            Clob clob = this.gaussConnection.createClob();
            this.setClob(parameterIndex, clob);
            clob.setString(1L, x);
        } else {
            this.setParameterValue(parameterIndex, FieldType.STRING, x);
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        boolean toBlob = false;
        if (x != null && x.length > 8000) {
            toBlob = true;
        }
        if (toBlob) {
            Blob blob = this.gaussConnection.createBlob();
            this.setBlob(parameterIndex, blob);
            blob.setBytes(1L, x);
        } else {
            this.setParameterValue(parameterIndex, FieldType.BINARY, x);
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.DATE, x);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.TIME, x);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.TIMESTAMP, x);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void clearBatch() throws SQLException {
        this.paramsData.clear();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void clearParameters() throws SQLException {
        this.paramsData.clear();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof BigInteger) {
            this.setBigDecimal(parameterIndex, new BigDecimal((BigInteger)x));
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x);
        } else if (x instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)x);
        } else {
            Class<?> clazz = x.getClass();
            throw ExceptionUtil.notSupportedFeature("Do not support type [" + clazz.getName() + "].");
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setStmt2Lob((AbstractGaussLob)((Object)x));
        this.setParameterValue(parameterIndex, FieldType.BLOB, x);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setStmt2Lob((AbstractGaussLob)((Object)x));
        this.setParameterValue(parameterIndex, FieldType.CLOB, x);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSetMetaData getMetaData() throws SQLException {
        this.validateOpened();
        if (this.getResultSet() != null) {
            return this.getResultSet().getMetaData();
        }
        return null;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, Integer.MAX_VALUE);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream, Integer.MAX_VALUE);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw ExceptionUtil.illegalJDBCArgumentException("Set clob with reader failed, the args length must be 0 to Integer.MAX_VALUE.");
        }
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw ExceptionUtil.illegalJDBCArgumentException("Set blob with reader failed, the args length must be 0 to Integer.MAX_VALUE.");
        }
        this.setBinaryStream(parameterIndex, inputStream, (int)length);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (int)length);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, 1);
            return;
        }
        char[] data = new char[8000];
        try {
            String tmp;
            int firstReadLength = reader.read(data);
            if (firstReadLength == -1 || length <= 0) {
                this.setString(parameterIndex, "");
                return;
            }
            int needLen = length < firstReadLength ? length : firstReadLength;
            boolean toClob = false;
            if (needLen == 8000) {
                toClob = true;
            }
            if (!toClob && (tmp = new String(data, 0, needLen)).getBytes(this.gaussConnection.getIOClient().getCharset()).length < 8000) {
                this.setString(parameterIndex, tmp);
                return;
            }
            Writer writer = null;
            Clob clob = this.gaussConnection.createClob();
            this.setClob(parameterIndex, clob);
            writer = clob.setCharacterStream(1L);
            writer.write(data, 0, needLen);
            int readLen = 0;
            for (int restLen = length - needLen; restLen > 0 && (readLen = reader.read(data)) != -1; restLen -= readLen) {
                needLen = readLen > restLen ? restLen : readLen;
                writer.write(data, 0, needLen);
            }
            writer.flush();
        }
        catch (IOException e) {
            throw ExceptionUtil.processJDBCException("Set character stream parameter failed.", "42S22", 504, e);
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, Integer.MAX_VALUE);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, Integer.MAX_VALUE);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, -2);
            return;
        }
        byte[] data = new byte[8000];
        try {
            int needLen;
            int firstReadLen = inputStream.read(data);
            if (firstReadLen == -1 || length <= 0) {
                this.setNull(parameterIndex, -2);
                return;
            }
            int n = needLen = length > firstReadLen ? firstReadLen : length;
            if (needLen < 8000) {
                byte[] needData = new byte[needLen];
                System.arraycopy(data, 0, needData, 0, needLen);
                this.setBytes(parameterIndex, needData);
                return;
            }
            OutputStream blobStream = null;
            Blob blob = this.gaussConnection.createBlob();
            this.setBlob(parameterIndex, blob);
            blobStream = blob.setBinaryStream(1L);
            blobStream.write(data);
            int readLen = 0;
            for (int totalLen = firstReadLen; (readLen = inputStream.read(data)) != -1 && length > totalLen; totalLen += readLen) {
                needLen = length - totalLen > readLen ? readLen : length - totalLen;
                blobStream.write(data, 0, needLen);
            }
            blobStream.flush();
        }
        catch (IOException e) {
            throw ExceptionUtil.processJDBCException("Set binary stream parameter failed.", "42S22", 504, e);
        }
    }

    protected void setParameterValue(int parameterIndex, FieldType type, Object value) throws SQLException {
        this.validateOpened();
        try {
            if (parameterIndex < 1 || parameterIndex > this.parsedSql.toServerParameterNo) {
                throw ExceptionUtil.illegalJDBCArgumentExceptionWithErrCode("Parameter index is invalid, index value must between 1 to " + this.parsedSql.toServerParameterNo + ".", 504);
            }
            this.paramsData.setParamValue(parameterIndex, type, value);
        }
        catch (RuntimeException exception) {
            throw ExceptionUtil.illegalJDBCArgumentException("Bind sql parameter failed, type = [" + type.getName() + "].", exception);
        }
    }

    protected void setParameterCalendar(int parameterIndex, Calendar cal) throws SQLException {
        this.validateOpened();
        try {
            if (parameterIndex < 1 || parameterIndex > this.parsedSql.toServerParameterNo) {
                throw ExceptionUtil.illegalJDBCArgumentExceptionWithErrCode("Parameter index is invalid, index value must between 1 to " + this.parsedSql.toServerParameterNo + ".", 504);
            }
            this.paramsData.setParamCalendar(parameterIndex, cal);
        }
        catch (RuntimeException exception) {
            throw ExceptionUtil.illegalJDBCArgumentException("Bind sql parameter with Calendar failed.", exception);
        }
    }

    @Override
    public boolean isPrepareStatement() {
        return true;
    }

    @Override
    public ParamsData getParamsData() {
        return this.paramsData;
    }

    public int getGeneratedKeyType() {
        return this.generatedKeyType;
    }

    public void setGeneratedKeyType(int generatedKeyType) {
        this.generatedKeyType = generatedKeyType;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.DATE, x);
        this.setParameterCalendar(parameterIndex, cal);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.TIME, x);
        this.setParameterCalendar(parameterIndex, cal);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.TIMESTAMP, x);
        this.setParameterCalendar(parameterIndex, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setNull(int,int,String).");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setURL(int,URL).");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.validateOpened();
        return new GaussParameterMetaDataImpl(this, null);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setRowId(int,RowId).");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setNString(int,String).");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setNCharacterStream(int,Reader,long).");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setNClob(int,NClob).");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setNClob(int,Reader,long).");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setSQLXML(int,SQLXML).");
    }

    private void setNumObject(int index, Object param, int targetType, int scale) throws SQLException {
        Number paramNum;
        if (param instanceof Boolean) {
            paramNum = (Boolean)param != false ? Integer.valueOf(1) : Integer.valueOf(0);
        } else if (param instanceof String) {
            switch (targetType) {
                case -6: 
                case 4: 
                case 5: {
                    paramNum = Integer.valueOf((String)param);
                    break;
                }
                case 6: 
                case 8: {
                    paramNum = Double.valueOf((String)param);
                    break;
                }
                case 7: {
                    paramNum = Float.valueOf((String)param);
                    break;
                }
                case -5: {
                    paramNum = Long.valueOf((String)param);
                    break;
                }
                default: {
                    paramNum = new BigDecimal((String)param);
                    break;
                }
            }
        } else {
            paramNum = (Number)param;
        }
        switch (targetType) {
            case -6: 
            case 4: 
            case 5: {
                this.setInt(index, paramNum.intValue());
                break;
            }
            case -5: {
                this.setLong(index, paramNum.longValue());
                break;
            }
            case 7: {
                this.setFloat(index, paramNum.floatValue());
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(index, paramNum.doubleValue());
                break;
            }
            case 2: 
            case 3: {
                if (paramNum instanceof BigDecimal) {
                    BigDecimal scaledBigDecimal = null;
                    try {
                        scaledBigDecimal = ((BigDecimal)paramNum).setScale(scale);
                    }
                    catch (ArithmeticException ex) {
                        try {
                            scaledBigDecimal = ((BigDecimal)paramNum).setScale(scale, 4);
                        }
                        catch (ArithmeticException arEx) {
                            throw ExceptionUtil.illegalJDBCArgumentException("Can't set scale of '" + scale + "' for DECIMAL argument '" + paramNum + "'");
                        }
                    }
                    this.setBigDecimal(index, scaledBigDecimal);
                    break;
                }
                if (paramNum instanceof BigInteger) {
                    this.setBigDecimal(index, new BigDecimal((BigInteger)paramNum, scale));
                    break;
                }
                this.setBigDecimal(index, new BigDecimal(paramNum.doubleValue()));
                break;
            }
        }
    }

    private char getSuccessor(char ch, int n) {
        return (char)(ch == 's' && n < 2 ? 115 : (ch == 'm' ? 115 : (ch == 'm' && n < 2 ? 109 : (ch == 'H' ? 109 : (ch == 'H' && n < 2 ? 72 : (ch == 'd' ? 72 : (ch == 'd' && n < 2 ? 100 : (ch == 'M' ? 100 : (ch == 'M' && n < 3 ? 77 : (ch == 'M' && n == 2 ? 89 : (ch == 'y' ? 77 : (ch == 'y' && n < 4 ? 121 : (ch == 'y' && n == 2 ? 88 : 87)))))))))))));
    }

    private String getDateTimePattern(String dataTime, boolean isToTime) throws Exception {
        int i;
        int zb;
        char ch;
        int i2;
        int dtLen;
        int n = dtLen = dataTime != null ? dataTime.length() : 0;
        if (dtLen >= 8 && dtLen <= 10) {
            int dashNum = 0;
            boolean isDate = true;
            for (i2 = 0; i2 < dtLen; ++i2) {
                ch = dataTime.charAt(i2);
                if (!Character.isDigit(ch) && ch != '-') {
                    isDate = false;
                    break;
                }
                if (ch != '-') continue;
                ++dashNum;
            }
            if (isDate && dashNum == 2) {
                return "yyyy-MM-dd";
            }
        }
        boolean isColons = true;
        int colonCount = 0;
        for (i2 = 0; i2 < dtLen; ++i2) {
            ch = dataTime.charAt(i2);
            if (!Character.isDigit(ch) && ch != ':') {
                isColons = false;
                break;
            }
            if (ch != ':') continue;
            ++colonCount;
        }
        if (isColons && colonCount == 2) {
            return "HH:mm:ss";
        }
        ArrayList<Object[]> vecNeedRemovelist = new ArrayList<Object[]>();
        Object[] nvec = new Object[]{Character.valueOf('y'), new StringBuffer(), 0};
        ArrayList<Object[]> vecList = new ArrayList<Object[]>();
        vecList.add(nvec);
        if (isToTime) {
            nvec = new Object[]{Character.valueOf('h'), new StringBuffer(), 0};
            vecList.add(nvec);
        }
        StringReader reader = new StringReader(dataTime + " ");
        while ((zb = reader.read()) != -1) {
            char separatorChar = (char)zb;
            int maxvecs = vecList.size();
            for (int count = 0; count < maxvecs; ++count) {
                Object[] vect = (Object[])vecList.get(count);
                int n2 = (Integer)vect[2];
                char ch2 = this.getSuccessor(((Character)vect[0]).charValue(), n2);
                if (!Character.isLetterOrDigit(separatorChar)) {
                    if (ch2 == ((Character)vect[0]).charValue() && ch2 != 'S') {
                        vecNeedRemovelist.add(vect);
                        continue;
                    }
                    ((StringBuffer)vect[1]).append(separatorChar);
                    if (ch2 != 'X' && ch2 != 89) continue;
                    vect[2] = 4;
                    continue;
                }
                if (ch2 == 'X') {
                    ch2 = 'y';
                    nvec = new Object[3];
                    nvec[1] = new StringBuffer(((StringBuffer)vect[1]).toString()).append('M');
                    nvec[0] = Character.valueOf('M');
                    nvec[2] = 1;
                    vecList.add(nvec);
                } else if (ch2 == 'Y') {
                    ch2 = 'M';
                    nvec = new Object[3];
                    nvec[1] = new StringBuffer(((StringBuffer)vect[1]).toString()).append('d');
                    nvec[0] = Character.valueOf('d');
                    nvec[2] = 1;
                    vecList.add(nvec);
                }
                ((StringBuffer)vect[1]).append(ch2);
                if (ch2 == ((Character)vect[0]).charValue()) {
                    vect[2] = n2 + 1;
                    continue;
                }
                vect[0] = Character.valueOf(ch2);
                vect[2] = 1;
            }
            int size = vecNeedRemovelist.size();
            for (int i3 = 0; i3 < size; ++i3) {
                Object[] v = (Object[])vecNeedRemovelist.get(i3);
                vecList.remove(v);
            }
            vecNeedRemovelist.clear();
        }
        int listSize = vecList.size();
        for (i = 0; i < listSize; ++i) {
            boolean containsEnd;
            int n3;
            Object[] v = (Object[])vecList.get(i);
            char c = ((Character)v[0]).charValue();
            boolean bk = this.getSuccessor(c, n3 = ((Integer)v[2]).intValue()) != c;
            boolean atEnd = (c == 's' || c == 'm' || c == 'h' && isToTime) && bk;
            boolean finishesAtDate = bk && c == 'd' && !isToTime;
            boolean bl = containsEnd = ((StringBuffer)v[1]).toString().indexOf(87) != -1;
            if ((atEnd || finishesAtDate) && !containsEnd) continue;
            vecNeedRemovelist.add(v);
        }
        listSize = vecNeedRemovelist.size();
        for (i = 0; i < listSize; ++i) {
            vecList.remove(vecNeedRemovelist.get(i));
        }
        vecNeedRemovelist.clear();
        Object[] v = (Object[])vecList.get(0);
        StringBuffer formatString = (StringBuffer)v[1];
        formatString.setLength(formatString.length() - 1);
        return formatString.toString();
    }

    private void toTimestampOrDate(int index, Object param, int targetType) throws SQLException {
        try {
            java.util.Date paramDate;
            if (param instanceof String) {
                ParsePosition parsePos = new ParsePosition(0);
                SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)param, false), Locale.US);
                paramDate = ((DateFormat)sdf).parse((String)param, parsePos);
            } else {
                paramDate = (java.util.Date)param;
            }
            switch (targetType) {
                case 91: {
                    if (paramDate instanceof Date) {
                        this.setDate(index, (Date)paramDate);
                        break;
                    }
                    this.setDate(index, new Date(paramDate.getTime()));
                    break;
                }
                case 93: {
                    if (paramDate instanceof Timestamp) {
                        this.setTimestamp(index, (Timestamp)paramDate);
                        break;
                    }
                    this.setTimestamp(index, new Timestamp(paramDate.getTime()));
                    break;
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.illegalJDBCArgumentException("No conversion from " + param.getClass().getName() + " to Types.Date or Types.TIMESTAMP possible.", e);
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (x == null) {
            if (targetSqlType == 1111) {
                this.setNull(parameterIndex, 0);
            } else {
                this.setNull(parameterIndex, targetSqlType);
            }
            return;
        }
        try {
            switch (targetSqlType) {
                case -7: 
                case 16: {
                    if (x instanceof Boolean) {
                        this.setBoolean(parameterIndex, (Boolean)x);
                        break;
                    }
                    if (x instanceof String) {
                        this.setBoolean(parameterIndex, "true".equalsIgnoreCase((String)x) || !"0".equalsIgnoreCase((String)x));
                        break;
                    }
                    if (x instanceof Number) {
                        int intValue = ((Number)x).intValue();
                        this.setBoolean(parameterIndex, intValue != 0);
                        break;
                    }
                    throw ExceptionUtil.illegalJDBCArgumentException("No conversion from " + x.getClass().getName() + " to Types.BOOLEAN possible.");
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.setNumObject(parameterIndex, x, targetSqlType, scaleOrLength);
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.setString(parameterIndex, x.toString());
                    break;
                }
                case 2005: {
                    if (x instanceof Clob) {
                        this.setClob(parameterIndex, (Clob)x);
                        break;
                    }
                    if (x instanceof Reader) {
                        this.setCharacterStream(parameterIndex, (Reader)x);
                        break;
                    }
                    this.setString(parameterIndex, x.toString());
                    break;
                }
                case -16: 
                case -3: 
                case -2: 
                case 2004: {
                    if (x instanceof byte[]) {
                        this.setBytes(parameterIndex, (byte[])x);
                        break;
                    }
                    if (x instanceof Blob) {
                        this.setBlob(parameterIndex, (Blob)x);
                        break;
                    }
                    if (x instanceof InputStream) {
                        this.setBinaryStream(parameterIndex, (InputStream)x);
                        break;
                    }
                    this.setBytes(parameterIndex, x.toString().getBytes(this.gaussConnection.getIOClient().getCharset()));
                    break;
                }
                case 91: 
                case 93: {
                    this.toTimestampOrDate(parameterIndex, x, targetSqlType);
                    break;
                }
                case 92: {
                    if (x instanceof String) {
                        SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)x, true), Locale.US);
                        this.setTime(parameterIndex, new Time(sdf.parse((String)x).getTime()));
                        break;
                    }
                    if (x instanceof Timestamp) {
                        Timestamp xT = (Timestamp)x;
                        this.setTime(parameterIndex, new Time(xT.getTime()));
                        break;
                    }
                    this.setTime(parameterIndex, (Time)x);
                    break;
                }
                case 1111: {
                    this.setObject(parameterIndex, x);
                    break;
                }
                default: {
                    Class<?> clazz = x.getClass();
                    throw ExceptionUtil.notSupportedFeature("Do not support type [" + clazz.getName() + "],targetSqlType=" + targetSqlType);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.illegalJDBCArgumentException("set object failed", e);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setAsciiStream(int,InputStream,long).");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setAsciiStream(int,InputStream).");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setNCharacterStream(int,Reader).");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setNClob(int,Reader).");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setAsciiStream(int,InputStream,int).");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setUnicodeStream(int,InputStream,int).");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (!(x instanceof BigDecimal)) {
            this.setObject(parameterIndex, x, targetSqlType, 0);
        } else {
            this.setObject(parameterIndex, x, targetSqlType, ((BigDecimal)x).scale());
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setArray(int,Array).");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("not support feature setRef(int,Ref).");
    }

    protected void setStmt2Lob(AbstractGaussLob lob) {
        if (lob != null) {
            lob.resetParameter();
            lob.setStatement(this);
        }
    }

    public void saveLobData() throws SQLException {
    }

    @Override
    public void setPrepareStatementId(int prepareStmtId) {
        this.statementId = prepareStmtId;
    }

    @Override
    public int getPrepareStatementId() {
        return this.statementId;
    }

    @Override
    public void setFixedCHAR(int parameterIndex, String value) throws SQLException {
        this.setParameterValue(parameterIndex, FieldType.CHAR, value);
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.gaussConnection.closeStatement(this);
        try {
            if (this.statementId != -1) {
                GaussPrepareStatementHelper.closePrepareStatement(this);
            }
        }
        finally {
            this.gaussConnection = null;
        }
    }
}

