/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.channel.context.statement.AbstractExecuteContext;
import com.huawei.gauss.channel.context.statement.CloseStmtContext;
import com.huawei.gauss.channel.context.statement.ExecuteBatchContext;
import com.huawei.gauss.channel.context.statement.ExecuteContext;
import com.huawei.gauss.channel.context.statement.ExecuteQueryContext;
import com.huawei.gauss.channel.context.statement.ExecuteUpdateContext;
import com.huawei.gauss.channel.context.statement.FetchMoreRowsContext;
import com.huawei.gauss.channel.context.statement.RowsData;
import com.huawei.gauss.cluster.check.CheckConnectionPool;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.handler.inner.IOClient;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.IGaussDriver;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussDriver;
import com.huawei.gauss.jdbc.inner.GaussResultSetImpl;
import com.huawei.gauss.jdbc.inner.GaussStatementImpl;
import java.nio.ByteOrder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class GaussStatementHelper {
    private GaussStatementHelper() {
    }

    static boolean execute(GaussStatementImpl gaussStatement, String sql) throws SQLException {
        return GaussStatementHelper.execute(gaussStatement, sql, 2);
    }

    protected static boolean execute(GaussStatementImpl gaussStatement, String sql, int autoGeneratedKeys) throws SQLException {
        String escapeSQL = sql.trim();
        if (escapeSQL.startsWith("{") && escapeSQL.endsWith("}")) {
            escapeSQL = escapeSQL.substring(1, escapeSQL.length() - 1);
        }
        ExecuteContext context = new ExecuteContext(gaussStatement.gaussDriver, gaussStatement.gaussConnection, gaussStatement);
        context.setSql(escapeSQL);
        context.setAutoGeneratedKeys(autoGeneratedKeys);
        gaussStatement.execute(context);
        GaussStatementHelper.getGeneratedKeyRows(gaussStatement, context);
        boolean hasResult = (Boolean)context.getResult();
        if (hasResult) {
            GaussResultSetImpl resultSetImpl = new GaussResultSetImpl(gaussStatement, escapeSQL);
            gaussStatement.gaussDriver.channelHandlerFactory.createResultSetCHandlers(resultSetImpl.channelHandlers, gaussStatement.gaussConnection);
            resultSetImpl.rowsData = context.getRowsData();
            gaussStatement.resultSet = resultSetImpl;
            gaussStatement.fieldDefs = resultSetImpl.rowsData.getFieldDefs();
            gaussStatement.returnResults.add(resultSetImpl);
        }
        gaussStatement.fetchAllReturnResults();
        return gaussStatement.returnResults.size() > 0;
    }

    static boolean execute(GaussStatementImpl gaussStatement, String sql, int[] columnIndexes) throws SQLException {
        String escapeSQL = sql.trim();
        if (escapeSQL.startsWith("{") && escapeSQL.endsWith("}")) {
            escapeSQL = escapeSQL.substring(1, escapeSQL.length() - 1);
        }
        ExecuteContext context = new ExecuteContext(gaussStatement.gaussDriver, gaussStatement.gaussConnection, gaussStatement);
        context.setSql(escapeSQL);
        context.setColumnIndexes(columnIndexes);
        gaussStatement.execute(context);
        GaussStatementHelper.getGeneratedKeyRows(gaussStatement, context);
        boolean hasResult = (Boolean)context.getResult();
        if (hasResult) {
            GaussResultSetImpl resultSetImpl = new GaussResultSetImpl(gaussStatement, escapeSQL);
            gaussStatement.gaussDriver.channelHandlerFactory.createResultSetCHandlers(resultSetImpl.channelHandlers, gaussStatement.gaussConnection);
            resultSetImpl.rowsData = context.getRowsData();
            gaussStatement.resultSet = resultSetImpl;
            gaussStatement.fieldDefs = resultSetImpl.rowsData.getFieldDefs();
            gaussStatement.returnResults.add(resultSetImpl);
        }
        gaussStatement.fetchAllReturnResults();
        return gaussStatement.returnResults.size() > 0;
    }

    static boolean execute(GaussStatementImpl gaussStatement, String sql, String[] columnNames) throws SQLException {
        String escapeSQL = sql.trim();
        if (escapeSQL.startsWith("{") && escapeSQL.endsWith("}")) {
            escapeSQL = escapeSQL.substring(1, escapeSQL.length() - 1);
        }
        ExecuteContext context = new ExecuteContext(gaussStatement.gaussDriver, gaussStatement.gaussConnection, gaussStatement);
        context.setSql(escapeSQL);
        context.setColumnNames(columnNames);
        gaussStatement.execute(context);
        GaussStatementHelper.getGeneratedKeyRows(gaussStatement, context);
        boolean hasResult = (Boolean)context.getResult();
        if (hasResult) {
            GaussResultSetImpl resultSetImpl = new GaussResultSetImpl(gaussStatement, escapeSQL);
            gaussStatement.gaussDriver.channelHandlerFactory.createResultSetCHandlers(resultSetImpl.channelHandlers, gaussStatement.gaussConnection);
            resultSetImpl.rowsData = context.getRowsData();
            gaussStatement.resultSet = resultSetImpl;
            gaussStatement.fieldDefs = resultSetImpl.rowsData.getFieldDefs();
            gaussStatement.returnResults.add(resultSetImpl);
        }
        gaussStatement.fetchAllReturnResults();
        return gaussStatement.returnResults.size() > 0;
    }

    static int executeUpdate(GaussStatementImpl gaussStatement, String sql) throws SQLException {
        ExecuteUpdateContext context = new ExecuteUpdateContext(gaussStatement.gaussDriver, gaussStatement.gaussConnection, gaussStatement);
        context.setSql(sql);
        gaussStatement.execute(context);
        GaussStatementHelper.getGeneratedKeyRows(gaussStatement, context);
        return (Integer)context.getResult();
    }

    static int executeUpdate(GaussStatementImpl gaussStatement, String sql, int autoGeneratedKeys) throws SQLException {
        ExecuteUpdateContext context = new ExecuteUpdateContext(gaussStatement.gaussDriver, gaussStatement.gaussConnection, gaussStatement);
        context.setSql(sql);
        context.setAutoGeneratedKeys(autoGeneratedKeys);
        gaussStatement.execute(context);
        GaussStatementHelper.getGeneratedKeyRows(gaussStatement, context);
        return (Integer)context.getResult();
    }

    static int executeUpdate(GaussStatementImpl gaussStatement, String sql, int[] columnIndexes) throws SQLException {
        ExecuteUpdateContext context = new ExecuteUpdateContext(gaussStatement.gaussDriver, gaussStatement.gaussConnection, gaussStatement);
        context.setSql(sql);
        context.setColumnIndexes(columnIndexes);
        gaussStatement.execute(context);
        GaussStatementHelper.getGeneratedKeyRows(gaussStatement, context);
        return (Integer)context.getResult();
    }

    static int executeUpdate(GaussStatementImpl gaussStatement, String sql, String[] columnNames) throws SQLException {
        ExecuteUpdateContext context = new ExecuteUpdateContext(gaussStatement.gaussDriver, gaussStatement.gaussConnection, gaussStatement);
        context.setSql(sql);
        context.setColumnNames(columnNames);
        gaussStatement.execute(context);
        GaussStatementHelper.getGeneratedKeyRows(gaussStatement, context);
        return (Integer)context.getResult();
    }

    static int[] batchExecute(GaussStatementImpl gaussStatement) throws SQLException {
        ExecuteBatchContext context = new ExecuteBatchContext(gaussStatement.gaussDriver, gaussStatement.gaussConnection, gaussStatement);
        gaussStatement.execute(context);
        GaussStatementHelper.getGeneratedKeyRows(gaussStatement, context);
        return (int[])context.getResult();
    }

    static ResultSet executeQuery(GaussStatementImpl gaussStatement, String sql) throws SQLException {
        String escapeSQL = sql.trim();
        if (escapeSQL.startsWith("{") && escapeSQL.endsWith("}")) {
            escapeSQL = escapeSQL.substring(1, escapeSQL.length() - 1);
        }
        GaussConnectionImpl gaussConnection = gaussStatement.gaussConnection;
        GaussDriver gaussDriver = gaussStatement.gaussDriver;
        GaussResultSetImpl resultSetImpl = new GaussResultSetImpl(gaussStatement, escapeSQL);
        gaussDriver.channelHandlerFactory.createResultSetCHandlers(resultSetImpl.channelHandlers, gaussConnection);
        ExecuteQueryContext context = new ExecuteQueryContext((IGaussDriver)gaussDriver, (GaussConnection)gaussConnection, resultSetImpl);
        context.setSql(escapeSQL);
        gaussStatement.execute(context);
        GaussStatementHelper.getGeneratedKeyRows(gaussStatement, context);
        GaussResultSetImpl resultSet = (GaussResultSetImpl)context.getResult();
        if (gaussStatement.getLangType() == 4) {
            gaussStatement.fetchAllReturnResults();
            if (gaussStatement.returnResults.size() == 0) {
                return resultSet;
            }
            return gaussStatement.returnResults.get(0);
        }
        if (gaussStatement.getLangType() == 1 && gaussStatement.getSqlType() == 1 || gaussStatement.getLangType() == 5) {
            gaussStatement.fieldDefs = resultSet.rowsData.getFieldDefs();
            gaussStatement.returnResults.add(resultSet);
            return resultSet;
        }
        return resultSet;
    }

    public static void getGeneratedKeyRows(GaussStatementImpl gaussStatement, AbstractExecuteContext<?> executeCtx) throws SQLException {
        if (executeCtx.getAutoGeneratedKeys() == 1) {
            RowsData rowsData = executeCtx.getGeneratedKeyRowsData();
            if (rowsData == null) {
                throw ExceptionUtil.illegalJDBCArgumentException("RETURN_GENERATED_KEYS ResultSet is null");
            }
            GaussResultSetImpl rs = gaussStatement.getGeneratedKeyRows();
            if (rs != null) {
                RowsData rowsData1 = rs.getRowsData();
                ArrayList<RowsData.RowData> allRowsData = new ArrayList<RowsData.RowData>();
                while (rowsData1.next()) {
                    allRowsData.add(rowsData1.getCurrentRowData());
                }
                while (rowsData.next()) {
                    allRowsData.add(rowsData.getCurrentRowData());
                }
                RowsData.RowData[] allDatas = new RowsData.RowData[allRowsData.size()];
                allDatas = allRowsData.toArray(allDatas);
                RowsData newRowsData = new RowsData(rowsData.getFieldDefs(), allDatas, 0, gaussStatement.gaussConnection.isBigEndianess() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN, gaussStatement.gaussConnection);
                rs.setRowsData(newRowsData);
            } else {
                GaussResultSetImpl generatedKey = new GaussResultSetImpl(gaussStatement, null);
                GaussDriver gaussDriver = gaussStatement.gaussDriver;
                gaussDriver.channelHandlerFactory.createResultSetCHandlers(generatedKey.channelHandlers, gaussStatement.gaussConnection);
                generatedKey.setRowsData(rowsData);
                gaussStatement.setGeneratedKeyRows(generatedKey);
            }
        } else {
            gaussStatement.setGeneratedKeyRows(null);
        }
    }

    static RowsData fetchMoreRows(GaussStatementImpl gaussStatement, RowsData rowsData) throws SQLException {
        FetchMoreRowsContext moreRowsContext = new FetchMoreRowsContext(gaussStatement.gaussDriver, gaussStatement.gaussConnection, gaussStatement, rowsData);
        gaussStatement.execute(moreRowsContext);
        return (RowsData)moreRowsContext.getResult();
    }

    static void closeStatement(GaussStatementImpl gaussStatement) throws SQLException {
        CloseStmtContext closeStmtContext = new CloseStmtContext(gaussStatement.gaussDriver, gaussStatement.gaussConnection, gaussStatement);
        gaussStatement.execute(closeStmtContext);
    }

    static void cancel(GaussStatementImpl gaussStatement) throws SQLException {
        String gaussNode = gaussStatement.gaussConnection.ioClient.getZenithUrl();
        IOClient cancelClient = gaussStatement.gaussConnection.ioClient;
        CheckConnectionPool.cancel(gaussNode, cancelClient.getSessionId(), cancelClient.currentSerialNumber(), cancelClient.getSessionSeqNo(), cancelClient.getLocalUsr());
    }
}

