/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.cluster.check.GaussNodeHealthDetectorTimer;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.GaussInfo;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussDriver;
import com.huawei.gauss.jdbc.inner.GaussInfoImpl;
import com.huawei.gauss.jdbc.inner.GaussSubDriverAbstract;
import com.huawei.gauss.jdbc.inner.UrlType;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class GaussSubDriver4Direct
extends GaussSubDriverAbstract {
    public static final String NODE_DETECTOR_NAME = "gauss.jdbc.nodeHealthDetector";

    public GaussSubDriver4Direct(GaussDriver gaussDriver, String url, Properties properties) {
        super(gaussDriver, url, properties);
    }

    private GaussInfo getGaussNodeInfo() throws SQLException {
        return new GaussInfoImpl(this.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GaussConnectionImpl getConnection(Properties props, UrlType urlType) throws SQLException {
        GaussConnectionImpl connection = null;
        try {
            GaussInfo gaussNodeInfo = this.getGaussNodeInfo();
            connection = gaussNodeInfo.createConnection(this, props);
            Map map = HEALTH_DETECTOR_TIMERS;
            synchronized (map) {
                if (!HEALTH_DETECTOR_TIMERS.containsKey(NODE_DETECTOR_NAME)) {
                    GaussNodeHealthDetectorTimer tmp = new GaussNodeHealthDetectorTimer(gaussNodeInfo.getIpAndPort());
                    HEALTH_DETECTOR_TIMERS.put(NODE_DETECTOR_NAME, tmp);
                    tmp.start();
                }
            }
            return connection;
        }
        catch (Error | RuntimeException e) {
            this.closeQuietly(connection);
            throw ExceptionUtil.processJDBCException("Get connection failed.", "08006", 503, e);
        }
    }
}

