/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussDriver;
import com.huawei.gauss.jdbc.inner.UrlType;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GaussSubDriverAbstract {
    public static final String AT_SEPARATOR = "@";
    public static final String PORT_SEPARATOR = ":";
    public static final int HEALTH_DETECTOR_TIMER_COUNT = 2;
    protected static final Map<String, Thread> HEALTH_DETECTOR_TIMERS = new ConcurrentHashMap<String, Thread>(2);
    protected final GaussDriver gaussDriver;
    protected final String url;
    protected final Properties properties;
    protected List<String> excludedUrls;

    public GaussSubDriverAbstract(GaussDriver gaussDriver, String url, Properties properties) {
        this.gaussDriver = gaussDriver;
        this.url = url;
        this.properties = properties;
    }

    public SocketAddress getSocketAddress(String ip, String port) {
        return new InetSocketAddress(ip, Integer.parseInt(port));
    }

    public GaussConnectionImpl constructConnection(SocketAddress gaussAddress, Properties props) throws SQLException {
        GaussConnectionImpl connection = new GaussConnectionImpl(this.gaussDriver, this.properties);
        this.gaussDriver.channelHandlerFactory.createConnectionCHandlers(connection.channelHandlers);
        try {
            connection.doConnect(gaussAddress, props);
        }
        catch (SQLException e) {
            try {
                connection.close();
            }
            catch (Exception ignore) {
                ExceptionUtil.handleUnThrowException("Exception occur when close connection", e);
            }
            throw e;
        }
        return connection;
    }

    protected abstract GaussConnectionImpl getConnection(Properties var1, UrlType var2) throws SQLException;

    protected void closeQuietly(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            ExceptionUtil.handleUnThrowException("Exception occur when close connection Quietly", e);
        }
    }
}

