/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.util.TimeUtil;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class TimeStampLTZ {
    private final GaussConnection conn;
    private final long tsValue;
    private Calendar cal;

    public TimeStampLTZ(GaussConnection conn, long tsValue, Calendar c) {
        this.conn = conn;
        this.tsValue = tsValue;
        this.cal = c;
    }

    public Timestamp getTimeStamp() throws JDBCException {
        int dbTimeZone = this.conn.getIOClient().getServerDBTimezone();
        int sessionTZ = this.conn.getIOClient().getClientSessionTZ();
        long localValue = 0L;
        Calendar c = null;
        if (this.cal == null || this.cal.getTimeZone().getRawOffset() == this.conn.getIOClient().getDefaultJVMTimeZone().getRawOffset()) {
            localValue = this.tsValue + (long)(sessionTZ - dbTimeZone) * 1000L;
            c = Calendar.getInstance(TimeZone.getTimeZone("GMT" + this.inttoStr(sessionTZ)));
        } else {
            localValue = this.tsValue - (long)(dbTimeZone * 1000);
            c = this.cal;
        }
        return TimeUtil.decodeDate(localValue, c);
    }

    public String getStringValue() throws JDBCException {
        int dbTimeZone = this.conn.getIOClient().getServerDBTimezone();
        long localValue = this.tsValue - (long)(dbTimeZone * 1000);
        Timestamp ts = TimeUtil.decodeDate(localValue, null);
        return ts.toString();
    }

    public String inttoStr(int offset) {
        int calOffset = offset;
        StringBuffer resBuf = new StringBuffer(6);
        if (offset < 0) {
            calOffset = Math.abs(offset);
            resBuf.append("-");
        } else {
            resBuf.append("+");
        }
        int hour = calOffset / 3600000;
        int min = (calOffset -= hour * 3600 * 1000) / 60000;
        String minRes = min < 10 ? "0" + min : Integer.toString(min);
        String hourRes = hour < 10 ? "0" + hour : Integer.toString(hour);
        resBuf.append(hourRes);
        resBuf.append(":");
        resBuf.append(minRes);
        return resBuf.toString();
    }
}

