/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.util.TimeUtil;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class TimeStampTZ {
    private long tmpTsValue;
    private short offset;
    private final GaussConnection conn;
    private Calendar cal;

    public TimeStampTZ(long tmpTsValue, short offset, GaussConnection ioConn, Calendar c) {
        this.tmpTsValue = tmpTsValue;
        this.offset = offset;
        this.conn = ioConn;
        this.cal = c;
    }

    public String shorttoStr(short offset) {
        int tmpOffset = offset;
        StringBuffer resultBuf = new StringBuffer(6);
        if (offset < 0) {
            tmpOffset = Math.abs(offset);
            resultBuf.append("-");
        } else {
            resultBuf.append("+");
        }
        int hour = tmpOffset / 60;
        int min = tmpOffset % 60;
        String hourNumber = hour < 10 ? "0" + hour : Integer.toString(hour);
        String minNumber = min < 10 ? "0" + min : Integer.toString(min);
        resultBuf.append(hourNumber);
        resultBuf.append(":");
        resultBuf.append(minNumber);
        return resultBuf.toString();
    }

    public String toString() {
        Calendar c = Calendar.getInstance();
        Timestamp ts = TimeUtil.decodeDate(this.tmpTsValue, c);
        return ts.toString() + " " + this.shorttoStr(this.offset);
    }

    public Timestamp getTimestamp() {
        long finalValue;
        Calendar c;
        if (this.cal == null || this.cal.getTimeZone().getRawOffset() == this.conn.getIOClient().getDefaultJVMTimeZone().getRawOffset()) {
            c = Calendar.getInstance(TimeZone.getTimeZone("GMT" + this.shorttoStr(this.offset)));
            finalValue = this.tmpTsValue;
        } else {
            c = this.cal;
            finalValue = this.tmpTsValue - (long)(this.offset * 60 * 1000) * 1000L;
        }
        return TimeUtil.decodeDate(finalValue, c);
    }
}

