/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner.message.gmdb;

import com.huawei.gauss.channel.DefaultCHandlerContext;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussInfo;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractMessage;
import com.huawei.gauss.jdbc.inner.message.gmdb.DynamicByteBuffer;
import java.nio.ByteBuffer;
import java.sql.SQLException;

public abstract class AbstractCommonResponse
extends AbstractMessage {
    protected String errorMsg = "";
    protected int errCode = 0;

    public AbstractCommonResponse(GaussConnection gaussConnection, DefaultCHandlerContext<?> context) {
        super(gaussConnection, context);
    }

    public void decodeBody(ByteBuffer buffer, GaussInfo gaussInfo) throws SQLException {
        if (buffer.remaining() <= 0) {
            return;
        }
        if (this.isError()) {
            this.errCode = buffer.getInt();
            short errLine = buffer.getShort();
            buffer.getShort();
            short errColumn = buffer.getShort();
            buffer.getShort();
            byte[] errorMsgBytes = new byte[buffer.remaining()];
            buffer.get(errorMsgBytes);
            int errLen = -1;
            while (++errLen < errorMsgBytes.length && errorMsgBytes[errLen] != 0) {
            }
            this.errorMsg = new String(errorMsgBytes, 0, errLen, gaussInfo.getCharset());
            StringBuilder sb = new StringBuilder();
            sb.append("errLine = ").append(errLine);
            sb.append(", errColumn = ").append(errColumn);
            sb.append(", errMsg=").append(this.errorMsg);
            this.errorMsg = sb.toString();
        } else {
            this.decodeGmdbBodyMsg(buffer, gaussInfo);
        }
    }

    abstract void decodeGmdbBodyMsg(ByteBuffer var1, GaussInfo var2) throws SQLException;

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public int getErrCode() {
        return this.errCode;
    }

    @Override
    protected void fixAndOptionHeadValue() {
    }

    @Override
    protected void encodeBody(DynamicByteBuffer buffer) {
    }
}

