/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner.message.gmdb;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.util.ByteBufferUtil;
import com.huawei.gauss.util.BytesUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DynamicByteBuffer {
    private static final int BYTE_LEN = 1;
    private final ByteOrder byteOrder;
    private final int segmentSize;
    private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private ByteBuffer currentBuffer = null;
    private Integer dataLen = null;
    private int bufferPosition;

    public DynamicByteBuffer(ByteOrder byteOrder, int segmentSize) {
        this.byteOrder = byteOrder;
        this.segmentSize = segmentSize;
        this.addNewBuffer();
    }

    public int flip() {
        if (null != this.dataLen) {
            throw new IllegalStateException("DynamicByteBuffer not support duplicate call flip");
        }
        int len = 0;
        for (ByteBuffer buffer : this.buffers) {
            buffer.flip();
            len += buffer.limit();
        }
        this.dataLen = len;
        return len;
    }

    public int position() {
        int position = 0;
        for (ByteBuffer buffer : this.buffers) {
            position += buffer.position();
        }
        return position;
    }

    public void put(byte value) throws SQLException {
        if (this.currentBuffer.remaining() < 1) {
            this.addNewBuffer();
        }
        ++this.bufferPosition;
        this.currentBuffer.put(value);
    }

    public void put(byte[] value) throws SQLException {
        int len;
        for (int writtenLen = 0; writtenLen < value.length; writtenLen += len) {
            int leftLen = value.length - writtenLen;
            len = this.currentBuffer.remaining();
            if (len <= 0) {
                this.addNewBuffer();
                len = this.currentBuffer.remaining();
            }
            len = len < leftLen ? len : leftLen;
            this.currentBuffer.put(value, writtenLen, len);
        }
        this.bufferPosition += value.length;
    }

    public void put(byte[] src, int offset, int length) throws SQLException {
        int len;
        for (int writtenLen = 0; writtenLen < length; writtenLen += len) {
            int leftLen = length - writtenLen;
            len = this.currentBuffer.remaining();
            if (len <= 0) {
                this.addNewBuffer();
                len = this.currentBuffer.remaining();
            }
            len = len < leftLen ? len : leftLen;
            this.currentBuffer.put(src, offset + writtenLen, len);
        }
        this.bufferPosition += length;
    }

    public void putInt(int value) throws SQLException {
        byte[] ba = BytesUtil.getBytes(value, this.byteOrder.equals(ByteOrder.BIG_ENDIAN));
        this.put(ba);
    }

    public void putInt(int index, int value) {
        int tempIndex = index;
        int innerIndex = index;
        for (ByteBuffer buffer : this.buffers) {
            byte[] ba;
            if (buffer.limit() <= innerIndex) {
                innerIndex -= buffer.limit();
                continue;
            }
            if (innerIndex + 4 <= buffer.limit()) {
                buffer.putInt(innerIndex, value);
                break;
            }
            for (byte b : ba = BytesUtil.getBytes(value, this.byteOrder.equals(ByteOrder.BIG_ENDIAN))) {
                this.put(tempIndex++, b);
            }
        }
    }

    public void putShort(int index, short value) {
        int tempIndex = index;
        int innerIndex = index;
        for (ByteBuffer buffer : this.buffers) {
            byte[] ba;
            if (buffer.limit() <= innerIndex) {
                innerIndex -= buffer.limit();
                continue;
            }
            if (innerIndex + 2 <= buffer.limit()) {
                buffer.putShort(innerIndex, value);
                break;
            }
            for (byte b : ba = BytesUtil.getBytes(value, this.byteOrder.equals(ByteOrder.BIG_ENDIAN))) {
                this.put(tempIndex++, b);
            }
        }
    }

    public void put(int index, byte value) {
        int innerIndex = index;
        for (ByteBuffer buffer : this.buffers) {
            if (buffer.limit() <= innerIndex) {
                innerIndex -= buffer.limit();
                continue;
            }
            buffer.put(innerIndex, value);
            break;
        }
    }

    public void putShort(short value) throws SQLException {
        byte[] ba = BytesUtil.getBytes(value, this.byteOrder.equals(ByteOrder.BIG_ENDIAN));
        this.put(ba);
    }

    public void clear() {
        for (ByteBuffer buffer : this.buffers) {
            try {
                buffer.clear();
                ByteBufferUtil.releaseDirectByteBuffer(buffer);
                buffer = null;
            }
            catch (Throwable e) {
                ExceptionUtil.handleUnThrowException("Exception occur when clear buffer", e);
            }
        }
        this.bufferPosition = 0;
        this.buffers.clear();
    }

    public ByteBuffer[] getAllBuffers() {
        return this.buffers.toArray(new ByteBuffer[this.buffers.size()]);
    }

    public void getAllBytesFromBuffers(byte[] message) {
        int len = 0;
        for (ByteBuffer buffer : this.buffers) {
            byte[] temp = new byte[buffer.limit()];
            int position = buffer.position();
            buffer.get(temp);
            System.arraycopy(temp, 0, message, len, buffer.limit());
            len += buffer.limit();
            buffer.position(position);
        }
    }

    public int getDataLen() {
        if (null == this.dataLen) {
            throw new IllegalStateException("Call flip before getMsgLen");
        }
        return this.dataLen;
    }

    public int capacity() {
        return this.bufferPosition;
    }

    private void addNewBuffer() {
        this.currentBuffer = ByteBufferUtil.getDirectByteBuffer(this.segmentSize);
        this.currentBuffer.order(this.byteOrder);
        this.buffers.add(this.currentBuffer);
    }
}

