/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner.message.gmdb;

import com.huawei.gauss.channel.DefaultCHandlerContext;
import com.huawei.gauss.channel.context.statement.AbstractExecuteContext;
import com.huawei.gauss.channel.context.statement.FetchCursorRowsContext;
import com.huawei.gauss.channel.context.statement.RowsData;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussInfo;
import com.huawei.gauss.jdbc.inner.message.gmdb.ExecuteResponse;
import java.nio.ByteBuffer;
import java.sql.SQLException;

public class FetchCursorRowsResponse
extends ExecuteResponse {
    public FetchCursorRowsResponse(GaussConnection gaussConnection, DefaultCHandlerContext<?> context) {
        super(gaussConnection, context);
    }

    @Override
    void decodeGmdbBodyMsg(ByteBuffer buffer, GaussInfo gaussInfo) throws SQLException {
        boolean haveResultSet;
        FetchCursorRowsContext tmpCtx = (FetchCursorRowsContext)this.context;
        if (tmpCtx.getCursorResultSetImpl().isFirstPackage()) {
            this.decodeStatementIdAndType(buffer);
            this.decodeParamAndField(buffer);
        }
        if (tmpCtx.getCursorResultSetImpl().isFirstPackage() && tmpCtx.getCursorResultSetImpl().getFetchMode() == 1) {
            buffer.getInt();
        }
        buffer.getInt();
        RowsData.FieldDef[] fieldDefs = this.context.getStatement().getFieldDefs();
        int columnCount = this.context.getStatement().getFieldDefs().length;
        short rowCount = buffer.getShort();
        byte hasMoreRow = buffer.get();
        buffer.get();
        boolean bl = haveResultSet = rowCount > 0;
        if (this.context.getStatement().getSqlType() == 1 || this.context.getStatement().getLangType() == 4) {
            this.context.getStatement().setUpdateCount(-1);
        }
        RowsData.FieldDef[] finalfFieldDefs = null;
        if (tmpCtx.getCursorResultSetImpl().isFirstPackage() && tmpCtx.getCursorResultSetImpl().getFetchMode() == 1) {
            int finalColumnDefsCount = buffer.getShort();
            buffer.getShort();
            if (haveResultSet) {
                finalfFieldDefs = new RowsData.FieldDef[finalColumnDefsCount];
                for (int i = 0; i < finalColumnDefsCount; ++i) {
                    finalfFieldDefs[i] = new RowsData.FieldDef(buffer, true, this.gaussConnection.getIOClient().getCharset());
                }
            }
        }
        if (columnCount > 0) {
            RowsData.RowData[] rows = RowsData.NULL_ROWS_DATA;
            if (haveResultSet) {
                rows = this.parseToDataRows(rowCount, buffer);
            }
            RowsData rowsData = new RowsData(fieldDefs, rows, hasMoreRow, this.gaussConnection.getIOClient().getByteOrder(), this.gaussConnection);
            rowsData.setFinalDefs(finalfFieldDefs);
            ((AbstractExecuteContext)this.context).setRowsData(rowsData);
        }
    }

    @Override
    public int getMessageType() {
        return 6;
    }

    @Override
    public String getMessageTypeName() {
        return "FetchCusorRowsResponse";
    }
}

