/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner.message.gmdb;

import com.huawei.gauss.channel.DefaultCHandlerContext;
import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussInfo;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractCommonResponse;
import com.huawei.gauss.util.EncryptUtil;
import java.nio.ByteBuffer;
import java.sql.SQLException;

public class HandshakeResponse
extends AbstractCommonResponse {
    private byte[] clientKey;
    private byte[] scrambleKey;
    private int iteration;
    private int msgType;

    public HandshakeResponse(byte[] clientKey, GaussConnection gaussConnection, DefaultCHandlerContext<?> context) {
        super(gaussConnection, context);
        this.clientKey = clientKey;
        this.msgType = 19;
    }

    @Override
    public int getMessageType() {
        return this.msgType;
    }

    @Override
    void decodeGmdbBodyMsg(ByteBuffer buffer, GaussInfo gaussInfo) throws SQLException {
        this.msgType = this.fixHeader.cmdType;
        if (this.ioClient.getServerVersion() >= 9 && this.msgType == 19) {
            return;
        }
        this.ioClient.setServerCapabilities(buffer.getInt());
        int serverVersion = buffer.getInt();
        this.ioClient.setServerVersion(serverVersion);
        this.scrambleKey = this.decodeBytes4Align(buffer);
        int n = this.iteration = buffer.hasRemaining() ? buffer.getInt() : 10000;
        if (!EncryptUtil.verifyChallenge(this.scrambleKey, this.clientKey)) {
            throw new JDBCException("Verify client challenge key failed");
        }
        int callVersion = serverVersion > 11 ? 11 : serverVersion;
        this.ioClient.setCallVersion(callVersion);
    }

    public byte[] getScrambleKey() {
        return (byte[])this.scrambleKey.clone();
    }

    public int getIteration() {
        return this.iteration;
    }

    @Override
    public String getMessageTypeName() {
        return "HandshakeResponse";
    }
}

