/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner.message.gmdb;

import com.huawei.gauss.channel.DefaultCHandlerContext;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.handler.inner.IOClient;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractCommonRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.DynamicByteBuffer;
import com.huawei.gauss.util.BytesUtil;
import com.huawei.gauss.util.EncryptUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.Date;
import java.util.TimeZone;

public class LoginRequest
extends AbstractCommonRequest {
    private static final short GS_CLIENT_KIND = 2;
    private final String userName;
    private final String passWord;
    private final String osHost;
    private final String osUser;
    private final String osProg;
    private final byte[] scrambleKey;
    private byte[] saltedPwd;
    private final int iteration;

    public LoginRequest(String userName, String passWord, byte[] scrambleKey, int iteration, GaussConnection gaussConnection, DefaultCHandlerContext<?> context) {
        super(gaussConnection, context);
        IOClient ioClient = gaussConnection.getIOClient();
        this.osHost = ((SocketChannel)ioClient.getChannel()).socket().getLocalAddress().toString();
        this.osUser = "os_User";
        this.osProg = "gsql-jdbc";
        this.userName = userName;
        this.passWord = passWord;
        this.scrambleKey = scrambleKey;
        this.iteration = iteration;
    }

    public static int getDefaultTimeZoneOffSet() {
        TimeZone tz = TimeZone.getDefault();
        int offset = tz.getRawOffset();
        if (tz.inDaylightTime(new Date())) {
            offset += tz.getDSTSavings();
        }
        return offset / 60000;
    }

    @Override
    public void encodeBody(DynamicByteBuffer buffer) throws SQLException {
        this.encodeString4Align(buffer, this.userName);
        this.encodeString4Align(buffer, this.encryptScramSHA256(this.passWord, this.scrambleKey, this.iteration));
        this.encodeString4Align(buffer, this.osHost);
        this.encodeString4Align(buffer, this.osUser);
        String prog = "[" + this.getProcessID() + "]" + this.osProg;
        this.encodeString4Align(buffer, prog);
        buffer.putShort((short)0);
        buffer.putShort((short)0);
        buffer.putShort((short)LoginRequest.getDefaultTimeZoneOffSet());
        buffer.putShort((short)0);
        if (this.ioClient.getCallVersion() >= 6) {
            buffer.putShort((short)2);
            buffer.putShort((short)0);
        }
    }

    public byte[] getEncryptPasswd() {
        return (byte[])this.saltedPwd.clone();
    }

    public byte[] getScramKey() {
        return (byte[])this.scrambleKey.clone();
    }

    private String encryptScramSHA256(String password, byte[] scrambleKey, int iteration) throws SQLException {
        byte[] signKey = new byte[64];
        byte[] saltKey = new byte[16];
        if (scrambleKey.length != signKey.length + saltKey.length) {
            throw new SQLException("Invalid scramble data");
        }
        System.arraycopy(scrambleKey, 0, signKey, 0, signKey.length);
        System.arraycopy(scrambleKey, signKey.length, saltKey, 0, saltKey.length);
        this.saltedPwd = EncryptUtil.encryptPBKDF2(password, saltKey, iteration);
        byte[] clientKey = EncryptUtil.encryptHmacSHA256(this.saltedPwd, "Zenith_Client_Key".getBytes(this.ioClient.getCharset()));
        byte[] storedKey = EncryptUtil.generateSHA256(clientKey);
        byte[] signature = EncryptUtil.encryptHmacSHA256(storedKey, signKey);
        byte[] scramData = new byte[signKey.length + signature.length];
        System.arraycopy(signKey, 0, scramData, 0, signKey.length);
        for (int i = 0; i < signature.length; ++i) {
            scramData[i + signKey.length] = (byte)((clientKey[i] ^ signature[i]) & 0xFF);
        }
        return BytesUtil.toString(EncryptUtil.encodeBase64(scramData), this.ioClient.getCharset());
    }

    @Override
    public int getMessageType() {
        return 1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LoginRequest [userName=");
        builder.append(this.userName);
        builder.append(", passWord=");
        builder.append(this.passWord);
        builder.append(", osHost=");
        builder.append(this.osHost);
        builder.append(", osUser=");
        builder.append(this.osUser);
        builder.append(", osProg=");
        builder.append(this.osProg);
        this.appendToString(builder);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String getMessageTypeName() {
        return "LoginRequest";
    }

    private long getProcessID() {
        long processId = 0L;
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            processId = Long.parseLong(runtimeMXBean.getName().split("@")[0]);
        }
        catch (Exception e) {
            ExceptionUtil.handleUnThrowException("get processId failed.", e);
        }
        return processId;
    }
}

