/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.om;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.inner.GaussDriver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertyLoader {
    private PropertyLoader() {
    }

    public static void loadSystemProperties(Properties properties, String propertyFileName) throws IOException {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(propertyFileName);
        PropertyLoader.priLoadProperties(properties, inputStream);
    }

    public static void loadResourceProperties(Properties properties, String resourceFilePath) throws IOException {
        InputStream inputStream = GaussDriver.class.getClassLoader().getResourceAsStream(resourceFilePath);
        PropertyLoader.priLoadProperties(properties, inputStream);
    }

    private static void priLoadProperties(Properties properties, InputStream inputStream) throws IOException {
        if (null == inputStream) {
            return;
        }
        try {
            properties.load(inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ignore) {
                ExceptionUtil.handleUnThrowException("Exception occur when close inputStream", ignore);
            }
        }
    }
}

