/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.util;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptUtil {
    public static final String CLIENT_KEY_NAME = "Zenith_Client_Key";
    public static final String SERVER_KEY_NAME = "Zenith_Server_Key";
    public static final int PBKDF2_ITERATIONS = 10000;
    public static final int PBKDF2_SALT_SIZE = 16;
    public static final int CHALLENGE_KEY_SIZE = 32;
    public static final int HMAC256_KEY_SIZE = 32;
    private static final int a = 32;
    private static final String b = "PBKDF2WithHmacSHA256";
    private static final String c = "HmacSHA256";
    private static final String d = "SHA-256";

    private EncryptUtil() {
    }

    public static byte[] encryptHmacSHA256(byte[] key, byte[] data) throws SQLException {
        try {
            SecretKeySpec keyspec = new SecretKeySpec(key, c);
            Mac mac = Mac.getInstance(c);
            mac.init(keyspec);
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw EncryptUtil.a(e);
        }
        catch (InvalidKeyException e) {
            throw EncryptUtil.a(e);
        }
    }

    public static synchronized byte[] encryptPBKDF2(String password, byte[] salt, int interation) throws SQLException {
        try {
            PBEKeySpec keyspec = new PBEKeySpec(password.toCharArray(), salt, interation, 256);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(b);
            return skf.generateSecret(keyspec).getEncoded();
        }
        catch (IllegalArgumentException e) {
            throw EncryptUtil.a(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw EncryptUtil.a(e);
        }
        catch (InvalidKeySpecException e) {
            throw EncryptUtil.a(e);
        }
    }

    public static byte[] generateSHA256(byte[] data) throws SQLException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(d);
            messageDigest.update(data);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw EncryptUtil.a(e);
        }
    }

    public static byte[] generateChallenge() {
        byte[] bytes = new byte[32];
        new SecureRandom().nextBytes(bytes);
        return bytes;
    }

    public static boolean verifyChallenge(byte[] scrambleKey, byte[] clientKey) {
        if (scrambleKey == null || clientKey == null || scrambleKey.length < clientKey.length) {
            return false;
        }
        byte[] recvChallenge = new byte[32];
        System.arraycopy(scrambleKey, 0, recvChallenge, 0, 32);
        return Arrays.equals(clientKey, recvChallenge);
    }

    private static int a(int len) {
        if (len == 0) {
            return 0;
        }
        int innerLen = len;
        switch (innerLen % 3) {
            case 1: {
                innerLen += 2;
                break;
            }
            case 2: {
                ++innerLen;
                break;
            }
        }
        return innerLen / 3 * 4;
    }

    private static int a(byte[] src) {
        if (src == null || src.length == 0) {
            return 0;
        }
        int len = src.length;
        int decLen = len / 4 * 3;
        if (len > 2) {
            if (src[len - 1] == 61) {
                --decLen;
            }
            if (src[len - 2] == 61) {
                --decLen;
            }
        }
        return decLen;
    }

    private static byte a(byte n) {
        byte chr = 0;
        byte innerN = (byte)(n & 0x3F);
        chr = innerN < 26 ? (byte)(innerN + 65) : (innerN < 52 ? (byte)(innerN - 26 + 97) : (innerN < 62 ? (byte)(innerN - 52 + 48) : (innerN == 62 ? (byte)43 : (byte)47)));
        return chr;
    }

    private static byte b(byte ch) {
        byte ret = 0;
        ret = ch >= 65 && ch <= 90 ? (byte)(ch - 65) : (ch >= 97 && ch <= 122 ? (byte)(ch - 97 + 26) : (ch >= 48 && ch <= 57 ? (byte)(ch - 48 + 52) : (43 == ch ? (byte)62 : (47 == ch ? (byte)63 : (byte)64))));
        return ret;
    }

    public static byte[] encodeBase64(byte[] data) {
        int encLen = EncryptUtil.a(data.length);
        byte[] dest = new byte[encLen];
        int i = 0;
        int j = 0;
        byte chr = 0;
        block5: for (int n = 0; n < data.length; ++n) {
            switch (n % 3) {
                case 0: {
                    dest[j++] = EncryptUtil.a((byte)((data[i] & 0xFF) >> 2));
                    chr = (byte)((data[i++] & 0xFF) << 4 & 0x3F);
                    continue block5;
                }
                case 1: {
                    dest[j++] = EncryptUtil.a((byte)(chr | (data[i] & 0xFF) >> 4));
                    chr = (byte)((data[i++] & 0xFF) << 2 & 0x3F);
                    continue block5;
                }
                case 2: {
                    dest[j++] = EncryptUtil.a((byte)(chr | (data[i] & 0xFF) >> 6));
                    dest[j++] = EncryptUtil.a(data[i++]);
                    continue block5;
                }
            }
        }
        if (data.length % 3 != 0) {
            dest[j++] = EncryptUtil.a(chr);
            if (1 == data.length % 3) {
                dest[j++] = 61;
            }
            dest[j++] = 61;
        }
        return dest;
    }

    public static byte[] decodeBase64(byte[] data) {
        int i = 0;
        int j = 0;
        int decLen = EncryptUtil.a(data);
        int tmpStr = 0;
        int chr = 0;
        byte[] dest = new byte[decLen];
        if (decLen == 0) {
            return dest;
        }
        block6: for (int n = 0; n < data.length && data[i] != 61; ++n) {
            while ((tmpStr = data[i] > 0 ? (int)EncryptUtil.b(data[i++]) : 65) == 64) {
            }
            if (tmpStr == 65) break;
            switch (n % 4) {
                case 0: {
                    chr = (byte)((tmpStr & 0xFF) << 2);
                    continue block6;
                }
                case 1: {
                    dest[j++] = (byte)(chr | (tmpStr & 0xFF) >> 4);
                    chr = (byte)(tmpStr << 4);
                    continue block6;
                }
                case 2: {
                    dest[j++] = (byte)(chr | (tmpStr & 0xFF) >> 2);
                    chr = (byte)(tmpStr << 6);
                    continue block6;
                }
                case 3: {
                    dest[j++] = (byte)(chr | tmpStr);
                    continue block6;
                }
            }
        }
        return dest;
    }

    private static SQLException a(Exception e) {
        return new SQLException("encrypt failed.", e);
    }
}

