/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.util;

import java.io.UnsupportedEncodingException;
import java.util.Map;

public abstract class FormatTransfer {
    private static final int BYTE_MASK_INT = 255;
    private static final long BYTE_MASK_LONG = 255L;

    public static byte[] toLE(long n) {
        byte[] res = new byte[]{(byte)(n & 0xFFL), (byte)(n >> 8 & 0xFFL), (byte)(n >> 16 & 0xFFL), (byte)(n >> 24 & 0xFFL), (byte)(n >> 32 & 0xFFL), (byte)(n >> 40 & 0xFFL), (byte)(n >> 48 & 0xFFL), (byte)(n >> 56 & 0xFFL)};
        return res;
    }

    public static byte[] toBE(long n) {
        byte[] res = new byte[8];
        res[7] = (byte)(n & 0xFFL);
        res[6] = (byte)(n >> 8 & 0xFFL);
        res[5] = (byte)(n >> 16 & 0xFFL);
        res[4] = (byte)(n >> 24 & 0xFFL);
        res[3] = (byte)(n >> 32 & 0xFFL);
        res[2] = (byte)(n >> 40 & 0xFFL);
        res[1] = (byte)(n >> 48 & 0xFFL);
        res[0] = (byte)(n >> 56 & 0xFFL);
        return res;
    }

    public static byte[] toLE(int n) {
        byte[] res = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return res;
    }

    public static byte[] toBE(int n) {
        byte[] res = new byte[4];
        res[3] = (byte)(n & 0xFF);
        res[2] = (byte)(n >> 8 & 0xFF);
        res[1] = (byte)(n >> 16 & 0xFF);
        res[0] = (byte)(n >> 24 & 0xFF);
        return res;
    }

    public static byte[] toLE(short n) {
        byte[] res = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return res;
    }

    public static byte[] toBE(short n) {
        byte[] res = new byte[2];
        res[1] = (byte)(n & 0xFF);
        res[0] = (byte)(n >> 8 & 0xFF);
        return res;
    }

    public static byte[] toLE(double d) {
        return FormatTransfer.toLE(Double.doubleToRawLongBits(d));
    }

    public static byte[] toBE(double d) {
        return FormatTransfer.toBE(Double.doubleToRawLongBits(d));
    }

    public static byte[] toLE(float f) {
        return FormatTransfer.toLE(Float.floatToRawIntBits(f));
    }

    public static byte[] toBE(float f) {
        return FormatTransfer.toBE(Float.floatToRawIntBits(f));
    }

    public static String bytesToString(byte[] b) {
        StringBuffer res = new StringBuffer("");
        int len = b.length;
        for (int i = 0; i < len; ++i) {
            res.append((char)(b[i] & 0xFF));
        }
        return res.toString();
    }

    public static byte[] stringToBytes(String s) throws UnsupportedEncodingException {
        return s.getBytes("UTF-8");
    }

    public static byte[] stringToBytes(String s, int length) throws UnsupportedEncodingException {
        String res = s;
        if (s.length() < length) {
            StringBuilder sb = new StringBuilder(s);
            for (int i = 0; i < length - s.length(); ++i) {
                sb.append(' ');
            }
            res = sb.toString();
        }
        return res.getBytes("UTF-8");
    }

    public static long beBytesToLong(byte[] b) {
        return (long)b[7] & 0xFFL | ((long)b[6] & 0xFFL) << 8 | ((long)b[5] & 0xFFL) << 16 | ((long)b[4] & 0xFFL) << 24 | (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) | ((long)b[1] & 0xFFL) << 48 | ((long)b[0] & 0xFFL) << 56;
    }

    public static long beBytesToLong(byte[] b, int offset) {
        return (long)b[offset + 7] & 0xFFL | ((long)b[offset + 6] & 0xFFL) << 8 | ((long)b[offset + 5] & 0xFFL) << 16 | ((long)b[offset + 4] & 0xFFL) << 24 | (((long)b[offset + 3] & 0xFFL) << 32) + (((long)b[offset + 2] & 0xFFL) << 40) | ((long)b[offset + 1] & 0xFFL) << 48 | ((long)b[offset + 0] & 0xFFL) << 56;
    }

    public static long beBytesToUnsignedInt(byte[] b, int offset) {
        return (long)b[offset + 3] & 0xFFL | ((long)b[offset + 2] & 0xFFL) << 8 | ((long)b[offset + 1] & 0xFFL) << 16 | ((long)b[offset + 0] & 0xFFL) << 24;
    }

    public static int beBytesToUnsignedShort(byte[] b, int offset) {
        return b[offset + 1] & 0xFF | (b[offset + 0] & 0xFF) << 8;
    }

    public static long leBytesToLong(byte[] b) {
        return (long)b[0] & 0xFFL | ((long)b[1] & 0xFFL) << 8 | ((long)b[2] & 0xFFL) << 16 | ((long)b[3] & 0xFFL) << 24 | ((long)b[4] & 0xFFL) << 32 | ((long)b[5] & 0xFFL) << 40 | ((long)b[6] & 0xFFL) << 48 | ((long)b[7] & 0xFFL) << 56;
    }

    public static long leBytesToLong(byte[] b, int offset) {
        return (long)b[offset + 0] & 0xFFL | ((long)b[offset + 1] & 0xFFL) << 8 | ((long)b[offset + 2] & 0xFFL) << 16 | ((long)b[offset + 3] & 0xFFL) << 24 | ((long)b[offset + 4] & 0xFFL) << 32 | ((long)b[offset + 5] & 0xFFL) << 40 | ((long)b[offset + 6] & 0xFFL) << 48 | ((long)b[offset + 7] & 0xFFL) << 56;
    }

    public static long leBytesToUnsignedInt(byte[] b, int offset) {
        return (long)b[offset + 0] & 0xFFL | ((long)b[offset + 1] & 0xFFL) << 8 | ((long)b[offset + 2] & 0xFFL) << 16 | ((long)b[offset + 3] & 0xFFL) << 24;
    }

    public static int leBytesToUnsignedShort(byte[] b, int offset) {
        return b[offset + 0] & 0xFF | (b[offset + 1] & 0xFF) << 8;
    }

    public static int beBytesToInt(byte[] b) {
        return b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | b[0] << 24;
    }

    public static int beBytesToInt(byte[] b, int offset) {
        return b[offset + 3] & 0xFF | (b[offset + 2] & 0xFF) << 8 | (b[offset + 1] & 0xFF) << 16 | b[offset + 0] << 24;
    }

    public static int leBytesToInt(byte[] b) {
        return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16 | b[3] << 24;
    }

    public static int leBytesToInt(byte[] b, int offset) {
        return b[offset + 0] & 0xFF | (b[offset + 1] & 0xFF) << 8 | (b[offset + 2] & 0xFF) << 16 | b[offset + 3] << 24;
    }

    public static short beBytesToShort(byte[] b) {
        return (short)(b[1] & 0xFF | (b[0] & 0xFF) << 8);
    }

    public static short beBytesToShort(byte[] b, int offset) {
        return (short)(b[offset + 1] & 0xFF | (b[offset] & 0xFF) << 8);
    }

    public static short leBytesToShort(byte[] b) {
        return (short)(b[0] & 0xFF | (b[1] & 0xFF) << 8);
    }

    public static short leBytesToShort(byte[] b, int offset) {
        return (short)(b[offset] & 0xFF | (b[offset + 1] & 0xFF) << 8);
    }

    public static float beBytesToFloat(byte[] b) {
        int i = 0;
        i = (((b[0] & 0xFF) << 8 | b[1] & 0xFF) << 8 | b[2] & 0xFF) << 8 | b[3] & 0xFF;
        return Float.intBitsToFloat(i);
    }

    public static float leBytesToFloat(byte[] b) {
        int i = 0;
        i = (((b[3] & 0xFF) << 8 | b[2] & 0xFF) << 8 | b[1] & 0xFF) << 8 | b[0] & 0xFF;
        return Float.intBitsToFloat(i);
    }

    public static double beBytesToDouble(byte[] b) {
        return Double.longBitsToDouble(FormatTransfer.beBytesToLong(b));
    }

    public static double leBytesToDouble(byte[] b) {
        return Double.longBitsToDouble(FormatTransfer.leBytesToLong(b));
    }

    public static int reverseInt(int input) {
        int res = FormatTransfer.beBytesToInt(FormatTransfer.toLE(input));
        return res;
    }

    public static short reverseShort(short input) {
        short res = FormatTransfer.beBytesToShort(FormatTransfer.toLE(input));
        return res;
    }

    public static float reverseFloat(float input) {
        float res = FormatTransfer.beBytesToFloat(FormatTransfer.toLE(input));
        return res;
    }

    public static <K, V> String map2String(Map<K, V> map) {
        StringBuilder sb = new StringBuilder("");
        String lineSep = System.lineSeparator();
        boolean isFirst = true;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!isFirst) {
                sb.append(lineSep);
            }
            isFirst = false;
            sb.append(entry.getKey()).append("->\t").append(entry.getValue());
        }
        return sb.toString();
    }
}

