/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.xa;

import com.huawei.gauss.datasource.GSPooledConnection;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.exception.SQLErrorCode;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.inner.GaussConnectionHelper;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.xa.GSXAException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class GSXAConnection
extends GSPooledConnection
implements XAConnection,
XAResource {
    private static final short a = 0;
    private static final short b = 1;
    private static final short c = 16;
    private static final short d = 32;
    private static final short e = 4;
    private static final int f = 1504;
    private final GaussConnectionImpl g;
    private boolean h = true;
    private int i;

    public GSXAConnection(GaussConnectionImpl conn) throws SQLException {
        super(conn, true, true);
        this.g = conn;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = super.getConnection();
        a connhandler = new a(conn);
        return (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class, GaussConnection.class}, (InvocationHandler)connhandler);
    }

    @Override
    public XAResource getXAResource() {
        return this;
    }

    @Override
    public void start(Xid xidObj, int trxFlag) throws XAException {
        int flag = 0;
        if (trxFlag != 0 && trxFlag != 0x8000000 && trxFlag != 0x200000) {
            throw new GSXAException("Invalid transaction flag = " + trxFlag, -5);
        }
        this.c(xidObj);
        com.huawei.gauss.xa.a gsXidImpl = new com.huawei.gauss.xa.a();
        gsXidImpl.a(xidObj);
        if (trxFlag == 0) {
            flag = 1;
            try {
                this.h = this.g.getAutoCommit();
                this.g.setAutoCommit(false);
                GaussConnectionHelper.xaStart(this.g, gsXidImpl, this.i, flag);
            }
            catch (SQLException e) {
                throw new GSXAException("XA Start failed.", e, -3);
            }
        }
        if (trxFlag == 0x8000000 || trxFlag == 0x200000) {
            flag = 16;
            try {
                this.h = this.g.getAutoCommit();
                this.g.setAutoCommit(false);
                GaussConnectionHelper.xaStart(this.g, gsXidImpl, this.i, flag);
            }
            catch (SQLException e) {
                throw new GSXAException("XA Start failed", e, -3);
            }
        }
    }

    @Override
    public void end(Xid xidObj, int trxFlag) throws XAException {
        int flag = 0;
        if (trxFlag != 0x2000000 && trxFlag != 0x20000000 && trxFlag != 0x4000000) {
            throw new GSXAException("Invalid transaction flag =" + trxFlag, -5);
        }
        this.c(xidObj);
        if (trxFlag == 0x2000000) {
            flag = 4;
        }
        try {
            GaussConnectionHelper.xaEnd(this.g, flag);
        }
        catch (SQLException e) {
            throw new GSXAException("XA end failed.", e, -3);
        }
        finally {
            try {
                this.g.setAutoCommit(this.h);
            }
            catch (Exception e2) {
                ExceptionUtil.handleUnThrowException("Set autocommit failed after end xa.", e2);
            }
        }
    }

    @Override
    public int prepare(Xid xidObj) throws XAException {
        this.c(xidObj);
        try {
            com.huawei.gauss.xa.a gsXidImpl = new com.huawei.gauss.xa.a();
            gsXidImpl.a(xidObj);
            int res = GaussConnectionHelper.xaPrepare(this.g, gsXidImpl);
            if (res == 1504) {
                res = 3;
            }
            return res;
        }
        catch (SQLException ex) {
            throw new GSXAException("Preparing transaction failed, prepare xid=" + xidObj, ex, -7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int trxFlag) throws XAException {
        if (trxFlag != 0x1000000 && trxFlag != 0x800000 && trxFlag != 0 && trxFlag != 0x1800000) {
            throw new GSXAException("Invalid transaction Flag =" + trxFlag, -5);
        }
        if ((trxFlag & 0x1000000) == 0) {
            return new Xid[0];
        }
        ResultSet res = null;
        String usr = this.g.getZenithInfo().getUser().toUpperCase();
        PreparedStatement pstmt = this.g.prepareStatement("select FORMAT_ID,GLOBAL_TRAN_ID,BRANCH_ID from SYS.ADM_2PC_PENDING where OWNER=(select USER_ID from DB_USERS where USERNAME=?)");
        try {
            pstmt.setString(1, usr);
            res = pstmt.executeQuery();
            ArrayList<com.huawei.gauss.xa.a> xidList = new ArrayList<com.huawei.gauss.xa.a>();
            while (res.next()) {
                long formatId = res.getLong(1);
                String globalTrxId = res.getString(2);
                String branchId = res.getString(3);
                if (globalTrxId == null || branchId == null) continue;
                com.huawei.gauss.xa.a gsXidImpl = new com.huawei.gauss.xa.a();
                gsXidImpl.a(formatId, globalTrxId, branchId);
                xidList.add(gsXidImpl);
            }
            Xid[] xidArray = xidList.toArray(new Xid[xidList.size()]);
            this.a(res);
            this.a(pstmt);
            return xidArray;
        }
        catch (Throwable throwable) {
            try {
                this.a(res);
                this.a(pstmt);
                throw throwable;
            }
            catch (Exception e) {
                throw new GSXAException("Failed to recover XA.", e, -3);
            }
        }
    }

    @Override
    public void rollback(Xid xidObj) throws XAException {
        this.c(xidObj);
        try {
            com.huawei.gauss.xa.a gsXidImpl = new com.huawei.gauss.xa.a();
            gsXidImpl.a(xidObj);
            GaussConnectionHelper.xaRollback(this.g, gsXidImpl);
        }
        catch (SQLException exception) {
            int errCode = -3;
            if (SQLErrorCode.SQLState.isConnError(exception.getSQLState())) {
                errCode = -7;
            }
            throw new GSXAException("Rolling back prepared transaction failed, rollback xid=" + xidObj, exception, errCode);
        }
    }

    @Override
    public void commit(Xid xidObj, boolean onePhaseCommit) throws XAException {
        this.c(xidObj);
        com.huawei.gauss.xa.a gsXidImpl = new com.huawei.gauss.xa.a();
        gsXidImpl.a(xidObj);
        if (onePhaseCommit) {
            this.a(gsXidImpl);
        } else {
            this.b(gsXidImpl);
        }
    }

    private void a(Xid xid) throws XAException {
        try {
            GaussConnectionHelper.xaCommit(this.g, xid, 32L);
        }
        catch (SQLException ex) {
            throw new GSXAException("One phase transaction commit failed, commit xid=" + xid, ex, -7);
        }
    }

    private void b(Xid xid) throws XAException {
        try {
            GaussConnectionHelper.xaCommit(this.g, xid, 0L);
        }
        catch (SQLException exception) {
            int errCode = -3;
            if (SQLErrorCode.SQLState.isConnError(exception.getSQLState())) {
                errCode = -7;
            }
            throw new GSXAException("Committing two phase transaction failed, commit xid=" + xid, exception, errCode);
        }
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource == this;
    }

    @Override
    public void forget(Xid xidObj) throws XAException {
        this.c(xidObj);
        try {
            com.huawei.gauss.xa.a gsXidImpl = new com.huawei.gauss.xa.a();
            gsXidImpl.a(xidObj);
            GaussConnectionHelper.xaRollback(this.g, gsXidImpl);
        }
        catch (SQLException exception) {
            int errCode = -3;
            if (SQLErrorCode.SQLState.isConnError(exception.getSQLState())) {
                errCode = -7;
            }
            throw new GSXAException("Forget transaction failed, rollback xid=" + xidObj, exception, errCode);
        }
    }

    @Override
    public int getTransactionTimeout() {
        return this.i;
    }

    @Override
    public boolean setTransactionTimeout(int timeoutSeconds) throws XAException {
        if (timeoutSeconds < 0) {
            throw new GSXAException("Trx timeoutSeconds must be greater than 0.", -5);
        }
        this.i = timeoutSeconds;
        return true;
    }

    private void c(Xid xidObj) throws GSXAException {
        if (xidObj == null) {
            throw new GSXAException("Transaction xid can not be null, prameter is invalid", -5);
        }
        if (xidObj.getFormatId() < 0) {
            throw new GSXAException("Transaction xid is invalid, formatId must large than zero, formatId=" + xidObj.getFormatId(), -5);
        }
        if (xidObj.getGlobalTransactionId() == null || xidObj.getBranchQualifier() == null) {
            throw new GSXAException("Transaction globalTransactionId or branchQualifier can not be null, prameter is invalid", -5);
        }
        if (xidObj.getGlobalTransactionId().length > 64 || xidObj.getBranchQualifier().length > 64) {
            throw new GSXAException("Transaction xid is invalid, GlobalTransactionId or BranchQualifier len is invalid.", -5);
        }
    }

    private void a(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException exception) {
            ExceptionUtil.handleUnThrowException("Exception occur when close statement", exception);
        }
    }

    private void a(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException exception) {
            ExceptionUtil.handleUnThrowException("Exception occur when close result set", exception);
        }
    }

    private class a
    implements InvocationHandler {
        private final Connection b;

        a(Connection conn) {
            this.b = conn;
        }

        @Override
        public Object invoke(Object proxyObj, Method methodArg, Object[] objArgs) throws Throwable {
            try {
                InvocationHandler handler;
                Object objArg;
                if (methodArg.getName().equals("equals") && Proxy.isProxyClass((objArg = objArgs[0]).getClass()) && (handler = Proxy.getInvocationHandler(objArg)) instanceof a) {
                    objArgs = new Object[]{((a)handler).b};
                }
                return methodArg.invoke((Object)this.b, objArgs);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

