/*
 * Decompiled with CFR 0.152.
 */
package nsp.support.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import nsp.support.common.HttpConnectionAdaptor;
import nsp.support.common.NSPError;
import nsp.support.common.NSPException;
import nsp.support.common.NSPResponse;
import nsp.support.common.Utils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public abstract class AbsNSPClient {
    protected static final String ACCESS_TOKEN = "access_token";
    protected static final String GRANT_TYPE = "grant_type";
    protected static final String CLIENT_ID = "client_id";
    protected static final String CLIENT_SECRET = "client_secret";
    protected static final String NSP_SVC = "nsp_svc";
    protected static final String NSP_TS = "nsp_ts";
    protected static final String NSP_STATUS = "NSP_STATUS";
    protected static final String NSP_PARAMS = "nsp_params";
    protected static final String NSP_FMT = "nsp_fmt";
    protected static final String NSP_CTX = "nsp_ctx";
    protected static final String NSP_SG = "nsp_sg";
    protected static String hostApi = "api.vmall.com";
    protected static String hostAuth = "login.vmall.com";
    protected static final String CONNECT_TIMEOUT = "connectTimeout";
    protected static final String READ_TIMEOUT = "readTimeout";
    private static ThreadLocal<Map<String, Integer>> times = new ThreadLocal();
    protected String apiUrl = "https://api.vmall.com/rest.php";
    protected String tokenUrl = "https://login.vmall.com/oauth2/token";
    protected HttpConnectionAdaptor connectionAdaptor = new HttpConnectionAdaptor();
    protected HttpContext context = new BasicHttpContext();

    public boolean initHttpConnections(int connectionsPerRoute, int maxConnections) {
        return this.connectionAdaptor.initHttpConnections(connectionsPerRoute, maxConnections);
    }

    public void initKeyStoreStream(InputStream keyStoreStream, String password) throws NSPException {
        this.connectionAdaptor.initKeyStoreStream(keyStoreStream, password);
    }

    protected String getPostData(Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return "";
        }
        StringBuffer data = new StringBuffer();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            try {
                data.append(URLEncoder.encode(k, "UTF-8")).append('=').append(URLEncoder.encode(v, "UTF-8")).append('&');
            }
            catch (UnsupportedEncodingException e) {
                e.getCause();
            }
        }
        return data.toString();
    }

    protected NSPResponse request(String httpurl, String data, Map<String, String> headers, String host) throws NSPException {
        int connectTimeout = 0;
        int readTimeout = 0;
        Map<String, Integer> timesMap = this.getTimeout();
        if (null != timesMap) {
            connectTimeout = timesMap.get(CONNECT_TIMEOUT);
            readTimeout = timesMap.get(READ_TIMEOUT);
        }
        return this.request(httpurl, data, headers, host, connectTimeout, readTimeout);
    }

    private NSPResponse request(String httpurl, String data, Map<String, String> headers, String host, int connectTimeout, int readTimeout) throws NSPException {
        CloseableHttpClient httpClient = null;
        if (null != httpurl && httpurl.toLowerCase().startsWith("https") && null == this.connectionAdaptor.getTrustStore()) {
            throw new NSPException(1, "Must load keystore with \"initKeyStoreStream\" method");
        }
        if (null == data) {
            throw new NSPException(1, "Content of request is empty.");
        }
        try {
            httpClient = this.connectionAdaptor.getHttpClient();
        }
        catch (Exception e) {
            throw new NSPException(2, "Service unavailable.", e);
        }
        if (null == httpClient) {
            throw new NSPException(2, "Service unavailable.");
        }
        HttpPost httpPost = HttpConnectionAdaptor.getHttpPost(httpurl, connectTimeout, readTimeout, false);
        if (null == httpPost) {
            throw new NSPException(2, "Service unavailable.");
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (host != null) {
            httpPost.setHeader("Host", host);
        }
        CloseableHttpResponse httpResponse = null;
        NSPResponse response = new NSPResponse();
        try {
            Header status;
            httpPost.setEntity((HttpEntity)new StringEntity(data, "UTF-8"));
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.addHeader("Accept-Encoding", "gzip");
            httpResponse = httpClient.execute((HttpUriRequest)httpPost, this.context);
            Header[] rspHeaders = httpResponse.getAllHeaders();
            if (null != rspHeaders) {
                for (Header header : rspHeaders) {
                    response.putHeader(header.getName(), header.getValue());
                }
            }
            if (null != (status = httpResponse.getFirstHeader(NSP_STATUS))) {
                response.setCode(Integer.parseInt(status.getValue()));
            }
            response.setStatus(httpResponse.getStatusLine().getStatusCode());
            if (response.getStatus() == 200 || response.getStatus() == 302) {
                response.setContent(EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity()));
            }
        }
        catch (Exception ioe) {
            throw new NSPException(2, "Service unavailable.", ioe);
        }
        finally {
            try {
                if (null != httpResponse) {
                    httpResponse.close();
                }
            }
            catch (Exception e) {
                e.getCause();
            }
            try {
                if (null != httpPost && !httpPost.isAborted()) {
                    httpPost.abort();
                }
            }
            catch (Exception e2) {
                e2.getCause();
            }
        }
        if (response.getCode() > 0) {
            NSPError err = null;
            try {
                err = (NSPError)JSON.parseObject((byte[])response.getContent(), NSPError.class, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                e.getCause();
            }
            if (err == null || err.getError() == null || err.getError().trim().length() == 0) {
                String errInfo = Utils.newString(response.getContent());
                throw new NSPException(response.getCode(), errInfo);
            }
            throw new NSPException(response.getCode(), err.getError());
        }
        return response;
    }

    public <T> T call(String service, Map<String, Object> params, Type returnType) throws NSPException {
        NSPResponse response = this.callService(service, params, null);
        Object result = null;
        if (null == response.getContent()) {
            throw new NSPException(response.getStatus(), "Request failed.");
        }
        try {
            result = JSON.parseObject((byte[])response.getContent(), (Type)returnType, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            throw new NSPException(response.getStatus(), "Parse failed.", e);
        }
        return (T)result;
    }

    public <T> T call(String service, Map<String, Object> params, Type returnType, Map<String, Object> attributes) throws NSPException {
        NSPResponse response = this.callService(service, params, attributes);
        Object result = null;
        if (null == response.getContent()) {
            throw new NSPException(response.getStatus(), "Request failed.");
        }
        try {
            result = JSON.parseObject((byte[])response.getContent(), (Type)returnType, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            throw new NSPException(response.getStatus(), "Parse failed.", e);
        }
        return (T)result;
    }

    public <T> T call(String service, Object[] params, Type returnType, Map<String, Object> attributes, Object observe) throws NSPException {
        NSPResponse response = this.callJSONRPCService(service, params, attributes);
        Object result = null;
        if (null == response.getContent()) {
            throw new NSPException(response.getStatus(), "Request failed.");
        }
        try {
            result = JSON.parseObject((byte[])response.getContent(), (Type)returnType, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            throw new NSPException(response.getStatus(), "Parse failed.", e);
        }
        return (T)result;
    }

    protected abstract NSPResponse callService(String var1, Map<String, Object> var2, Map<String, Object> var3) throws NSPException;

    protected abstract NSPResponse callJSONRPCService(String var1, Object[] var2, Map<String, Object> var3) throws NSPException;

    public void setApiUrl(String url) {
        this.apiUrl = url;
        hostApi = Utils.getHost(url);
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        hostAuth = Utils.getHost(tokenUrl);
    }

    public void setTimeout(final int connectTimeout, final int readTimeout) {
        Map<String, Integer> obj = times.get();
        if (null == obj) {
            times.set((Map<String, Integer>)new HashMap<String, Integer>(){
                {
                    this.put(AbsNSPClient.CONNECT_TIMEOUT, connectTimeout);
                    this.put(AbsNSPClient.READ_TIMEOUT, readTimeout);
                }
            });
            return;
        }
        Map<String, Integer> timesMap = obj;
        timesMap.put(CONNECT_TIMEOUT, connectTimeout);
        timesMap.put(READ_TIMEOUT, readTimeout);
    }

    public Map<String, Integer> getTimeout() {
        Map<String, Integer> obj = times.get();
        if (null != obj) {
            return obj;
        }
        return null;
    }
}

