/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import me.chanjar.weixin.common.util.http.WxCustomParamUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;

public class WxAuthUtil {
    public static String paasId;
    public static String paasToken;
    public static boolean jsonHeader;

    public static String toSHA256(String str) {
        String encodeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodeStr = WxAuthUtil.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodeStr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    public static void setGetHeader(HttpGet httpGet) {
        if (StringUtils.isNotBlank((CharSequence)paasId) && StringUtils.isNotBlank((CharSequence)paasToken)) {
            long now = new Date().getTime();
            String timestamp = Long.toString((long)Math.floor(now / 1000L));
            String nonce = Long.toHexString(now) + "-" + Long.toHexString((long)Math.floor(Math.random() * 1.6777215E7));
            String signature = WxAuthUtil.toSHA256(timestamp + paasToken + nonce + timestamp);
            httpGet.setHeader("x-tif-paasid", paasId);
            httpGet.setHeader("x-tif-timestamp", timestamp);
            httpGet.setHeader("x-tif-signature", signature);
            httpGet.setHeader("x-tif-nonce", nonce);
            httpGet.setHeader("Content-Type", "application/json");
            httpGet.setHeader("Cache-Control", "no-cache");
        } else if (httpGet.getURI().toString().indexOf("https://qyapi.weixin.qq.com") == -1 && jsonHeader) {
            httpGet.setHeader("Content-Type", "application/json");
        }
    }

    public static void setPostHeader(HttpPost httpPost) {
        if (StringUtils.isNotBlank((CharSequence)paasId) && StringUtils.isNotBlank((CharSequence)paasToken)) {
            long now = new Date().getTime();
            String timestamp = Long.toString((long)Math.floor(now / 1000L));
            String nonce = Long.toHexString(now) + "-" + Long.toHexString((long)Math.floor(Math.random() * 1.6777215E7));
            String signature = WxAuthUtil.toSHA256(timestamp + paasToken + nonce + timestamp);
            httpPost.setHeader("x-tif-paasid", paasId);
            httpPost.setHeader("x-tif-timestamp", timestamp);
            httpPost.setHeader("x-tif-signature", signature);
            httpPost.setHeader("x-tif-nonce", nonce);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Cache-Control", "no-cache");
        } else if (httpPost.getURI().toString().indexOf("https://qyapi.weixin.qq.com") == -1 && jsonHeader) {
            httpPost.setHeader("Content-Type", "application/json");
        } else if ("1".equals(WxCustomParamUtil.FRNYJTType) && !httpPost.getURI().toString().contains("/cgi/open/external/todo")) {
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        }
    }
}

