/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.apache;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.WxAuthUtil;
import me.chanjar.weixin.common.util.http.WxCustomParamUtil;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import me.chanjar.weixin.common.util.json.GsonHelper;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class ApacheHttpClientSimpleGetRequestExecutor
extends SimpleGetRequestExecutor<CloseableHttpClient, HttpHost> {
    public ApacheHttpClientSimpleGetRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    /*
     * Loose catch block
     */
    @Override
    public String execute(String uri, String queryParam) throws WxErrorException, IOException {
        if (queryParam != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? queryParam : '&' + queryParam);
        }
        HttpGet httpGet = new HttpGet(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpGet.setConfig(config);
        }
        WxAuthUtil.setGetHeader(httpGet);
        if ("1".equals(WxCustomParamUtil.casType) && uri.contains("user-info")) {
            httpGet.setHeader("clientId", WxCustomParamUtil.clientId);
            httpGet.setHeader("clientSecret", WxCustomParamUtil.clientSecret);
        }
        try {
            try (CloseableHttpResponse response = ((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((HttpUriRequest)httpGet);){
                WxError error;
                JsonElement je;
                JsonElement dataJe;
                String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                if (!uri.contains("https://api.weixin.qq.com") && GsonHelper.isNotNull(dataJe = (je = new JsonParser().parse(responseContent)).getAsJsonObject().get("data"))) {
                    responseContent = dataJe.getAsJsonObject().toString();
                }
                if ((error = WxError.fromJson(responseContent)).getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                String string = responseContent;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpGet.releaseConnection();
        }
    }
}

