/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.apache;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.WxAuthUtil;
import me.chanjar.weixin.common.util.http.WxCustomParamUtil;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import me.chanjar.weixin.common.util.json.GsonHelper;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheSimplePostRequestExecutor
extends SimplePostRequestExecutor<CloseableHttpClient, HttpHost> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public ApacheSimplePostRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    /*
     * Loose catch block
     */
    @Override
    public String execute(String uri, String postEntity) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (postEntity != null) {
            StringEntity entity = new StringEntity(postEntity, Consts.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
        }
        WxAuthUtil.setPostHeader(httpPost);
        try {
            if ("1".equals(WxCustomParamUtil.FRNYJTType) && uri.contains("/cgi/open/external/todo")) {
                int i = uri.lastIndexOf("=");
                String subToken = uri.substring(i + 1);
                httpPost.setHeader("Authorization", subToken);
                httpPost.setHeader("Content-Type", "application/json");
                CloseableHttpResponse frResponse = ((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((HttpUriRequest)httpPost);
                String responseContent2 = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)frResponse);
                this.log.info("\u4f01\u4e1a\u5fae\u4fe1\u4f5b\u71c3\u5f85\u529e\u63a8\u9001\u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)responseContent2);
                return responseContent2;
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        try {
            String string;
            try (CloseableHttpResponse response = ((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((HttpUriRequest)httpPost);){
                WxError error;
                JsonElement je;
                JsonElement dataJe;
                String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                if (responseContent.isEmpty()) {
                    throw new WxErrorException(WxError.builder().errorCode(9999).errorMsg("\u65e0\u54cd\u5e94\u5185\u5bb9").build());
                }
                if (responseContent.startsWith("<xml>")) {
                    String responseContent2 = responseContent;
                    return responseContent2;
                }
                if (!uri.contains("https://api.weixin.qq.com") && GsonHelper.isNotNull(dataJe = (je = new JsonParser().parse(responseContent)).getAsJsonObject().get("data"))) {
                    responseContent = dataJe.getAsJsonObject().toString();
                }
                if ((error = WxError.fromJson(responseContent)).getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                string = responseContent;
            }
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }
}

