/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.apache;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.NoHttpResponseException;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DefaultApacheHttpClientBuilder
implements ApacheHttpClientBuilder {
    protected final Logger log = LoggerFactory.getLogger(DefaultApacheHttpClientBuilder.class);
    private final AtomicBoolean prepared = new AtomicBoolean(false);
    private int connectionRequestTimeout = 3000;
    private int connectionTimeout = 5000;
    private int soTimeout = 5000;
    private int idleConnTimeout = 60000;
    private int checkWaitTime = 60000;
    private int maxConnPerHost = 10;
    private int maxTotalConn = 50;
    private String userAgent;
    private HttpRequestRetryHandler httpRequestRetryHandler = new HttpRequestRetryHandler(){

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (executionCount > 3) {
                DefaultApacheHttpClientBuilder.this.log.warn("Maximum tries reached for client http pool");
                return false;
            }
            if (exception instanceof ConnectTimeoutException || exception instanceof HttpHostConnectException || exception instanceof SocketTimeoutException || exception instanceof SocketException || exception instanceof SSLHandshakeException || exception instanceof NoHttpResponseException || exception instanceof UnknownHostException) {
                DefaultApacheHttpClientBuilder.this.log.warn(exception + " on " + executionCount + " call");
                return true;
            }
            return false;
        }
    };
    private SSLConnectionSocketFactory sslConnectionSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
    private PlainConnectionSocketFactory plainConnectionSocketFactory = PlainConnectionSocketFactory.getSocketFactory();
    private String httpProxyHost;
    private int httpProxyPort;
    private String httpProxyUsername;
    private String httpProxyPassword;
    private IdleConnectionMonitorThread idleConnectionMonitorThread;
    private CloseableHttpClient closeableHttpClient;

    private DefaultApacheHttpClientBuilder() {
    }

    public static DefaultApacheHttpClientBuilder get() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
        return this;
    }

    @Override
    public ApacheHttpClientBuilder httpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
        return this;
    }

    @Override
    public ApacheHttpClientBuilder sslConnectionSocketFactory(SSLConnectionSocketFactory sslConnectionSocketFactory) {
        this.sslConnectionSocketFactory = sslConnectionSocketFactory;
        return this;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setIdleConnTimeout(int idleConnTimeout) {
        this.idleConnTimeout = idleConnTimeout;
    }

    public void setCheckWaitTime(int checkWaitTime) {
        this.checkWaitTime = checkWaitTime;
    }

    public void setMaxConnPerHost(int maxConnPerHost) {
        this.maxConnPerHost = maxConnPerHost;
    }

    public void setMaxTotalConn(int maxTotalConn) {
        this.maxTotalConn = maxTotalConn;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public IdleConnectionMonitorThread getIdleConnectionMonitorThread() {
        return this.idleConnectionMonitorThread;
    }

    private synchronized void prepare() {
        if (this.prepared.get()) {
            return;
        }
        this.sslConnectionSocketFactory = this.buildSSLConnectionSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)this.plainConnectionSocketFactory).register("https", (Object)this.sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(this.maxTotalConn);
        connectionManager.setDefaultMaxPerRoute(this.maxConnPerHost);
        connectionManager.setDefaultSocketConfig(SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout(this.soTimeout).build());
        this.idleConnectionMonitorThread = new IdleConnectionMonitorThread((HttpClientConnectionManager)connectionManager, this.idleConnTimeout, this.checkWaitTime);
        this.idleConnectionMonitorThread.setDaemon(true);
        this.idleConnectionMonitorThread.start();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionManagerShared(true).setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslConnectionSocketFactory).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(this.soTimeout).setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout).build()).setRetryHandler(this.httpRequestRetryHandler);
        if (StringUtils.isNotBlank((CharSequence)this.httpProxyHost) && StringUtils.isNotBlank((CharSequence)this.httpProxyUsername)) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(new AuthScope(this.httpProxyHost, this.httpProxyPort), (Credentials)new UsernamePasswordCredentials(this.httpProxyUsername, this.httpProxyPassword));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            httpClientBuilder.setProxy(new HttpHost(this.httpProxyHost, this.httpProxyPort));
        }
        if (StringUtils.isNotBlank((CharSequence)this.userAgent)) {
            httpClientBuilder.setUserAgent(this.userAgent);
        }
        this.closeableHttpClient = httpClientBuilder.build();
        this.prepared.set(true);
    }

    private SSLConnectionSocketFactory buildSSLConnectionSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            DefaultX509TrustManager tm = new DefaultX509TrustManager();
            sslContext.init(null, new TrustManager[]{tm}, null);
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return sslsf;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public CloseableHttpClient build() {
        if (!this.prepared.get()) {
            this.prepare();
        }
        return this.closeableHttpClient;
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private final int idleConnTimeout;
        private final int checkWaitTime;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr, int idleConnTimeout, int checkWaitTime) {
            super("IdleConnectionMonitorThread");
            this.connMgr = connMgr;
            this.idleConnTimeout = idleConnTimeout;
            this.checkWaitTime = checkWaitTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(this.checkWaitTime);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections((long)this.idleConnTimeout, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trigger() {
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }

    private static class SingletonHolder {
        private static final DefaultApacheHttpClientBuilder INSTANCE = new DefaultApacheHttpClientBuilder();

        private SingletonHolder() {
        }
    }

    public class DefaultX509TrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

