/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.util.json.GsonHelper;

public class WxErrorAdapter
implements JsonDeserializer<WxError> {
    public WxError deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        WxError.WxErrorBuilder errorBuilder = WxError.builder();
        JsonObject wxErrorJsonObject = json.getAsJsonObject();
        if (wxErrorJsonObject.get("errcode") != null && !wxErrorJsonObject.get("errcode").isJsonNull()) {
            errorBuilder.errorCode(GsonHelper.getAsPrimitiveInt(wxErrorJsonObject.get("errcode")));
        }
        if (wxErrorJsonObject.get("errmsg") != null && !wxErrorJsonObject.get("errmsg").isJsonNull()) {
            errorBuilder.errorMsgEn(GsonHelper.getAsString(wxErrorJsonObject.get("errmsg")));
        }
        if (GsonHelper.isNotNull(wxErrorJsonObject.get("code")) && GsonHelper.isNotNull(wxErrorJsonObject.get("msg")) && GsonHelper.isNotNull(wxErrorJsonObject.get("data"))) {
            JsonObject data = wxErrorJsonObject.get("data").getAsJsonObject();
            if (data.get("errcode") != null && !data.get("errcode").isJsonNull()) {
                errorBuilder.errorCode(GsonHelper.getAsPrimitiveInt(data.get("errcode")));
            }
            if (data.get("errmsg") != null && !data.get("errmsg").isJsonNull()) {
                errorBuilder.errorMsgEn(GsonHelper.getAsString(data.get("errmsg")));
            }
        }
        errorBuilder.json(json.toString());
        return errorBuilder.build();
    }
}

