/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import me.chanjar.weixin.common.annotation.Required;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class WxPayDownloadFundFlowRequest
extends BaseWxPayRequest {
    private static final String[] ACCOUNT_TYPES = new String[]{"Basic", "Operation", "Fees"};
    private static final String SIGN_TYPE_HMAC_SHA256 = "HMAC-SHA256";
    private static final String TAR_TYPE_GZIP = "GZIP";
    @Required
    @XStreamAlias(value="bill_date")
    private String billDate;
    @Required
    @XStreamAlias(value="account_type")
    private String accountType;
    @XStreamAlias(value="tar_type")
    private String tarType;

    @Override
    protected void checkConstraints() throws WxPayException {
        if (StringUtils.isNotBlank((CharSequence)this.getTarType()) && !TAR_TYPE_GZIP.equals(this.getTarType())) {
            throw new WxPayException("tar_type\u503c\u5982\u679c\u5b58\u5728\uff0c\u53ea\u80fd\u4e3aGZIP");
        }
        if (!ArrayUtils.contains((Object[])ACCOUNT_TYPES, (Object)this.getAccountType())) {
            throw new WxPayException(String.format("account_type\u5fc5\u987b\u4e3a%s\u5176\u4e2d\u4e4b\u4e00,\u5b9e\u9645\u503c\uff1a%s", Arrays.toString(ACCOUNT_TYPES), this.getAccountType()));
        }
        this.setSignType(SIGN_TYPE_HMAC_SHA256);
    }

    public static WxPayDownloadFundFlowRequestBuilder newBuilder() {
        return new WxPayDownloadFundFlowRequestBuilder();
    }

    public String getBillDate() {
        return this.billDate;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public String getTarType() {
        return this.tarType;
    }

    public void setBillDate(String billDate) {
        this.billDate = billDate;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public void setTarType(String tarType) {
        this.tarType = tarType;
    }

    @Override
    public String toString() {
        return "WxPayDownloadFundFlowRequest(billDate=" + this.getBillDate() + ", accountType=" + this.getAccountType() + ", tarType=" + this.getTarType() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayDownloadFundFlowRequest)) {
            return false;
        }
        WxPayDownloadFundFlowRequest other = (WxPayDownloadFundFlowRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$billDate = this.getBillDate();
        String other$billDate = other.getBillDate();
        if (this$billDate == null ? other$billDate != null : !this$billDate.equals(other$billDate)) {
            return false;
        }
        String this$accountType = this.getAccountType();
        String other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
            return false;
        }
        String this$tarType = this.getTarType();
        String other$tarType = other.getTarType();
        return !(this$tarType == null ? other$tarType != null : !this$tarType.equals(other$tarType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxPayDownloadFundFlowRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $billDate = this.getBillDate();
        result = result * 59 + ($billDate == null ? 43 : $billDate.hashCode());
        String $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
        String $tarType = this.getTarType();
        result = result * 59 + ($tarType == null ? 43 : $tarType.hashCode());
        return result;
    }

    public WxPayDownloadFundFlowRequest() {
    }

    @ConstructorProperties(value={"billDate", "accountType", "tarType"})
    public WxPayDownloadFundFlowRequest(String billDate, String accountType, String tarType) {
        this.billDate = billDate;
        this.accountType = accountType;
        this.tarType = tarType;
    }

    public static class WxPayDownloadFundFlowRequestBuilder {
        private String billDate;
        private String accountType;
        private String tarType;

        WxPayDownloadFundFlowRequestBuilder() {
        }

        public WxPayDownloadFundFlowRequestBuilder billDate(String billDate) {
            this.billDate = billDate;
            return this;
        }

        public WxPayDownloadFundFlowRequestBuilder accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        public WxPayDownloadFundFlowRequestBuilder tarType(String tarType) {
            this.tarType = tarType;
            return this;
        }

        public WxPayDownloadFundFlowRequest build() {
            return new WxPayDownloadFundFlowRequest(this.billDate, this.accountType, this.tarType);
        }

        public String toString() {
            return "WxPayDownloadFundFlowRequest.WxPayDownloadFundFlowRequestBuilder(billDate=" + this.billDate + ", accountType=" + this.accountType + ", tarType=" + this.tarType + ")";
        }
    }
}

