/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.config;

import com.github.binarywang.wxpay.exception.WxPayException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ssl.SSLContexts;

public class WxPayConfig {
    private int httpConnectionTimeout = 5000;
    private int httpTimeout = 10000;
    private String appId;
    private String subAppId;
    private String mchId;
    private String mchKey;
    private String subMchId;
    private String notifyUrl;
    private String tradeType;
    private String signType;
    private SSLContext sslContext;
    private String keyPath;
    private byte[] keyContent;
    private String keyPassword;
    private boolean useSandboxEnv = false;
    private boolean ifSaveApiData = false;
    private String httpProxyHost;
    private Integer httpProxyPort;
    private String httpProxyUsername;
    private String httpProxyPassword;

    public SSLContext initSSLContext() throws WxPayException {
        InputStream inputStream;
        if (StringUtils.isBlank((CharSequence)this.getMchId())) {
            throw new WxPayException("\u8bf7\u786e\u4fdd\u5546\u6237\u53f7mchId\u5df2\u8bbe\u7f6e");
        }
        if (this.keyContent != null) {
            inputStream = new ByteArrayInputStream(this.keyContent);
        } else {
            if (StringUtils.isBlank((CharSequence)this.getKeyPath())) {
                throw new WxPayException("\u8bf7\u786e\u4fdd\u8bc1\u4e66\u6587\u4ef6\u5730\u5740keyPath\u5df2\u914d\u7f6e");
            }
            String prefix = "classpath:";
            String fileHasProblemMsg = "\u8bc1\u4e66\u6587\u4ef6\u3010" + this.getKeyPath() + "\u3011\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5b9e\uff01";
            String fileNotFoundMsg = "\u8bc1\u4e66\u6587\u4ef6\u3010" + this.getKeyPath() + "\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01";
            if (this.getKeyPath().startsWith("classpath:")) {
                String path = StringUtils.removeFirst((String)this.getKeyPath(), (String)"classpath:");
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                if ((inputStream = WxPayConfig.class.getResourceAsStream(path)) == null) {
                    throw new WxPayException(fileNotFoundMsg);
                }
            } else {
                try {
                    File file = new File(this.getKeyPath());
                    if (!file.exists()) {
                        throw new WxPayException(fileNotFoundMsg);
                    }
                    inputStream = new FileInputStream(file);
                }
                catch (IOException e) {
                    throw new WxPayException(fileHasProblemMsg, e);
                }
            }
        }
        try {
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            String keyPassword = this.getKeyPassword();
            if (keyPassword == null || keyPassword.trim() == "") {
                keyPassword = this.getMchId();
            }
            char[] partnerId2charArray = keyPassword.toCharArray();
            keystore.load(inputStream, partnerId2charArray);
            SSLContext sSLContext = this.sslContext = SSLContexts.custom().loadKeyMaterial(keystore, partnerId2charArray).build();
            return sSLContext;
        }
        catch (Exception e) {
            throw new WxPayException("\u8bc1\u4e66\u6587\u4ef6\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5b9e\uff01", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    public int getHttpTimeout() {
        return this.httpTimeout;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getSubAppId() {
        return this.subAppId;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getMchKey() {
        return this.mchKey;
    }

    public String getSubMchId() {
        return this.subMchId;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public String getSignType() {
        return this.signType;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public byte[] getKeyContent() {
        return this.keyContent;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public boolean isUseSandboxEnv() {
        return this.useSandboxEnv;
    }

    public boolean isIfSaveApiData() {
        return this.ifSaveApiData;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpConnectionTimeout(int httpConnectionTimeout) {
        this.httpConnectionTimeout = httpConnectionTimeout;
    }

    public void setHttpTimeout(int httpTimeout) {
        this.httpTimeout = httpTimeout;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setSubAppId(String subAppId) {
        this.subAppId = subAppId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setMchKey(String mchKey) {
        this.mchKey = mchKey;
    }

    public void setSubMchId(String subMchId) {
        this.subMchId = subMchId;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    public void setKeyContent(byte[] keyContent) {
        this.keyContent = keyContent;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setUseSandboxEnv(boolean useSandboxEnv) {
        this.useSandboxEnv = useSandboxEnv;
    }

    public void setIfSaveApiData(boolean ifSaveApiData) {
        this.ifSaveApiData = ifSaveApiData;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayConfig)) {
            return false;
        }
        WxPayConfig other = (WxPayConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHttpConnectionTimeout() != other.getHttpConnectionTimeout()) {
            return false;
        }
        if (this.getHttpTimeout() != other.getHttpTimeout()) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$subAppId = this.getSubAppId();
        String other$subAppId = other.getSubAppId();
        if (this$subAppId == null ? other$subAppId != null : !this$subAppId.equals(other$subAppId)) {
            return false;
        }
        String this$mchId = this.getMchId();
        String other$mchId = other.getMchId();
        if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
            return false;
        }
        String this$mchKey = this.getMchKey();
        String other$mchKey = other.getMchKey();
        if (this$mchKey == null ? other$mchKey != null : !this$mchKey.equals(other$mchKey)) {
            return false;
        }
        String this$subMchId = this.getSubMchId();
        String other$subMchId = other.getSubMchId();
        if (this$subMchId == null ? other$subMchId != null : !this$subMchId.equals(other$subMchId)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$tradeType = this.getTradeType();
        String other$tradeType = other.getTradeType();
        if (this$tradeType == null ? other$tradeType != null : !this$tradeType.equals(other$tradeType)) {
            return false;
        }
        String this$signType = this.getSignType();
        String other$signType = other.getSignType();
        if (this$signType == null ? other$signType != null : !this$signType.equals(other$signType)) {
            return false;
        }
        SSLContext this$sslContext = this.getSslContext();
        SSLContext other$sslContext = other.getSslContext();
        if (this$sslContext == null ? other$sslContext != null : !this$sslContext.equals(other$sslContext)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyContent(), other.getKeyContent())) {
            return false;
        }
        String this$keyPassword = this.getKeyPassword();
        String other$keyPassword = other.getKeyPassword();
        if (this$keyPassword == null ? other$keyPassword != null : !this$keyPassword.equals(other$keyPassword)) {
            return false;
        }
        if (this.isUseSandboxEnv() != other.isUseSandboxEnv()) {
            return false;
        }
        if (this.isIfSaveApiData() != other.isIfSaveApiData()) {
            return false;
        }
        String this$httpProxyHost = this.getHttpProxyHost();
        String other$httpProxyHost = other.getHttpProxyHost();
        if (this$httpProxyHost == null ? other$httpProxyHost != null : !this$httpProxyHost.equals(other$httpProxyHost)) {
            return false;
        }
        Integer this$httpProxyPort = this.getHttpProxyPort();
        Integer other$httpProxyPort = other.getHttpProxyPort();
        if (this$httpProxyPort == null ? other$httpProxyPort != null : !((Object)this$httpProxyPort).equals(other$httpProxyPort)) {
            return false;
        }
        String this$httpProxyUsername = this.getHttpProxyUsername();
        String other$httpProxyUsername = other.getHttpProxyUsername();
        if (this$httpProxyUsername == null ? other$httpProxyUsername != null : !this$httpProxyUsername.equals(other$httpProxyUsername)) {
            return false;
        }
        String this$httpProxyPassword = this.getHttpProxyPassword();
        String other$httpProxyPassword = other.getHttpProxyPassword();
        return !(this$httpProxyPassword == null ? other$httpProxyPassword != null : !this$httpProxyPassword.equals(other$httpProxyPassword));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxPayConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHttpConnectionTimeout();
        result = result * 59 + this.getHttpTimeout();
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $subAppId = this.getSubAppId();
        result = result * 59 + ($subAppId == null ? 43 : $subAppId.hashCode());
        String $mchId = this.getMchId();
        result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
        String $mchKey = this.getMchKey();
        result = result * 59 + ($mchKey == null ? 43 : $mchKey.hashCode());
        String $subMchId = this.getSubMchId();
        result = result * 59 + ($subMchId == null ? 43 : $subMchId.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $tradeType = this.getTradeType();
        result = result * 59 + ($tradeType == null ? 43 : $tradeType.hashCode());
        String $signType = this.getSignType();
        result = result * 59 + ($signType == null ? 43 : $signType.hashCode());
        SSLContext $sslContext = this.getSslContext();
        result = result * 59 + ($sslContext == null ? 43 : $sslContext.hashCode());
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyContent());
        String $keyPassword = this.getKeyPassword();
        result = result * 59 + ($keyPassword == null ? 43 : $keyPassword.hashCode());
        result = result * 59 + (this.isUseSandboxEnv() ? 79 : 97);
        result = result * 59 + (this.isIfSaveApiData() ? 79 : 97);
        String $httpProxyHost = this.getHttpProxyHost();
        result = result * 59 + ($httpProxyHost == null ? 43 : $httpProxyHost.hashCode());
        Integer $httpProxyPort = this.getHttpProxyPort();
        result = result * 59 + ($httpProxyPort == null ? 43 : ((Object)$httpProxyPort).hashCode());
        String $httpProxyUsername = this.getHttpProxyUsername();
        result = result * 59 + ($httpProxyUsername == null ? 43 : $httpProxyUsername.hashCode());
        String $httpProxyPassword = this.getHttpProxyPassword();
        result = result * 59 + ($httpProxyPassword == null ? 43 : $httpProxyPassword.hashCode());
        return result;
    }

    public String toString() {
        return "WxPayConfig(httpConnectionTimeout=" + this.getHttpConnectionTimeout() + ", httpTimeout=" + this.getHttpTimeout() + ", appId=" + this.getAppId() + ", subAppId=" + this.getSubAppId() + ", mchId=" + this.getMchId() + ", mchKey=" + this.getMchKey() + ", subMchId=" + this.getSubMchId() + ", notifyUrl=" + this.getNotifyUrl() + ", tradeType=" + this.getTradeType() + ", signType=" + this.getSignType() + ", sslContext=" + this.getSslContext() + ", keyPath=" + this.getKeyPath() + ", keyContent=" + Arrays.toString(this.getKeyContent()) + ", keyPassword=" + this.getKeyPassword() + ", useSandboxEnv=" + this.isUseSandboxEnv() + ", ifSaveApiData=" + this.isIfSaveApiData() + ", httpProxyHost=" + this.getHttpProxyHost() + ", httpProxyPort=" + this.getHttpProxyPort() + ", httpProxyUsername=" + this.getHttpProxyUsername() + ", httpProxyPassword=" + this.getHttpProxyPassword() + ")";
    }
}

