/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.core.utils;

import com.aliyun.core.execption.AliyunException;
import com.aliyun.core.utils.MapTypeAdapter;
import com.aliyun.core.utils.XmlUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentException;

public class ParseUtil {
    public static Object parseJSON(String json) {
        Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<Map<String, Object>>(){}.getType(), (Object)new MapTypeAdapter()).create();
        JsonElement jsonElement = (JsonElement)gson.fromJson(json, JsonElement.class);
        return jsonElement.isJsonArray() ? gson.fromJson(json, List.class) : gson.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readAsBytes(InputStream stream) {
        try {
            if (null == stream) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            while (true) {
                int read;
                if ((read = stream.read(buff)) == -1) {
                    byte[] byArray = os.toByteArray();
                    return byArray;
                }
                os.write(buff, 0, read);
                continue;
                break;
            }
        }
        catch (Exception e) {
            throw new AliyunException(e.getMessage(), e);
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new AliyunException(e.getMessage(), e);
                }
            }
        }
    }

    public static String readAsString(InputStream stream) {
        try {
            return new String(ParseUtil.readAsBytes(stream), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AliyunException(e.getMessage(), e);
        }
    }

    public static Object readAsJSON(String str) {
        try {
            return ParseUtil.parseJSON(str);
        }
        catch (Exception exception) {
            throw new AliyunException("Error: convert to JSON, response is:\n" + str);
        }
    }

    public static String toJSONString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return new Gson().toJson(object);
    }

    public static Map<String, Object> parseXml(String str) throws DocumentException {
        return XmlUtil.deserializeXml(str);
    }

    public static Map<String, Object> readAsXML(String str) {
        try {
            return ParseUtil.parseXml(str);
        }
        catch (Exception exception) {
            throw new AliyunException("Error: XML convert to MAP, response is:\n" + str);
        }
    }

    public static String toXmlString(Map<String, Object> xmlMap, String rootName) {
        return XmlUtil.serializeXml(xmlMap, rootName);
    }
}

