/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.core.utils;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class UnixTime {
    private final OffsetDateTime dateTime;

    public UnixTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public UnixTime(long unixSeconds) {
        this.dateTime = OffsetDateTime.ofInstant(Instant.ofEpochSecond(unixSeconds), ZoneOffset.UTC);
    }

    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public String toString() {
        return String.valueOf(this.dateTime.toEpochSecond());
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnixTime)) {
            return false;
        }
        UnixTime rhs = (UnixTime)obj;
        return this.dateTime.equals(rhs.getDateTime());
    }
}

