/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.COSEncryptionClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSStaticCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.CryptoStorageMode;
import com.qcloud.cos.internal.crypto.KMSEncryptionMaterials;
import com.qcloud.cos.internal.crypto.KMSEncryptionMaterialsProvider;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.Download;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.Upload;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class KMSEncryptionClientDemo {
    static String cmk = "kms-xxxxxxx";
    static String bucketName = "mybucket-1251668577";
    static String key = "testKMS/len1m.txt";
    static File localFile = new File("len1m.txt");
    static File bigLocalFile = new File("len10m.txt");
    static COSClient cosClient = KMSEncryptionClientDemo.createCosClient();

    static COSClient createCosClient() {
        return KMSEncryptionClientDemo.createCosClient("ap-guangzhou");
    }

    static COSClient createCosClient(String region) {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy");
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        KMSEncryptionMaterials encryptionMaterials = new KMSEncryptionMaterials(cmk);
        CryptoConfiguration cryptoConf = new CryptoConfiguration(CryptoMode.AesCtrEncryption).withStorageMode(CryptoStorageMode.ObjectMetadata);
        COSEncryptionClient cosEncryptionClient = new COSEncryptionClient(new COSStaticCredentialsProvider(cred), new KMSEncryptionMaterialsProvider(encryptionMaterials), clientConfig, cryptoConf);
        return cosEncryptionClient;
    }

    static void getObjectDemo() {
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        File downloadFile = new File("downlen1m.txt");
        ObjectMetadata objectMetadata = cosClient.getObject(getObjectRequest, downloadFile);
        System.out.println(objectMetadata.getRequestId());
    }

    static void putObjectDemo() {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
        System.out.println(putObjectResult.getRequestId());
    }

    static void deleteObjectDemo() {
        cosClient.deleteObject(bucketName, key);
    }

    static void transferManagerDemo() {
        ExecutorService threadPool = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cosClient, threadPool);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMultipartUploadThreshold(0x100000L);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, bigLocalFile);
        try {
            Upload upload = transferManager.upload(putObjectRequest);
            UploadResult uploadResult = upload.waitForUploadResult();
            System.out.println(uploadResult.getRequestId());
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        try {
            Download download = transferManager.download(getObjectRequest, new File("downLen10m.txt"));
            download.waitForCompletion();
            System.out.println(download.getObjectMetadata().getRequestId());
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
    }

    public static void main(String[] args) throws Exception {
        KMSEncryptionClientDemo.putObjectDemo();
        KMSEncryptionClientDemo.getObjectDemo();
        KMSEncryptionClientDemo.transferManagerDemo();
        cosClient.shutdown();
    }
}

