/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model.ciModel.xml;

import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.ciModel.common.MediaInputObject;
import com.qcloud.cos.model.ciModel.job.FileCompressConfig;
import com.qcloud.cos.model.ciModel.job.FileHashCodeConfig;
import com.qcloud.cos.model.ciModel.job.FileProcessOperation;
import com.qcloud.cos.model.ciModel.job.FileProcessRequest;
import com.qcloud.cos.model.ciModel.job.FileUnCompressConfig;
import com.qcloud.cos.model.ciModel.xml.CIMediaXmlFactory;
import java.util.List;

public class CIFileProcessXmlFactory {
    public static byte[] convertToXmlByteArray(FileProcessRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        xml.start("Tag").value(request.getTag().toString()).end();
        CIFileProcessXmlFactory.addInput(xml, request.getInput());
        CIFileProcessXmlFactory.addOperation(xml, request.getOperation());
        CIMediaXmlFactory.addIfNotNull(xml, "QueueId", request.getQueueId());
        CIMediaXmlFactory.addIfNotNull(xml, "CallBack", request.getCallBack());
        CIMediaXmlFactory.addIfNotNull(xml, "CallBackFormat", request.getCallBackFormat());
        CIMediaXmlFactory.addIfNotNull(xml, "CallBackType", request.getCallBackType());
        CIMediaXmlFactory.addIfNotNull(xml, "CallBackMqConfig", request.getCallBackMqConfig());
        xml.end();
        return xml.getBytes();
    }

    private static void addInput(XmlWriter xml, MediaInputObject input) {
        if (CIMediaXmlFactory.objIsNotValid(input).booleanValue()) {
            xml.start("Input");
            xml.start("Object").value(input.getObject()).end();
            xml.end();
        }
    }

    private static void addOperation(XmlWriter xml, FileProcessOperation operation) {
        if (CIMediaXmlFactory.objIsNotValid(operation).booleanValue()) {
            FileHashCodeConfig fileHashCodeConfig;
            xml.start("Operation");
            CIMediaXmlFactory.addIfNotNull(xml, "UserData", operation.getUserData());
            FileCompressConfig fileCompressConfig = operation.getFileCompressConfig();
            if (CIMediaXmlFactory.objIsNotValid(fileCompressConfig).booleanValue()) {
                xml.start("FileCompressConfig");
                CIMediaXmlFactory.addIfNotNull(xml, "Flatten", fileCompressConfig.getFlatten());
                CIMediaXmlFactory.addIfNotNull(xml, "Format", fileCompressConfig.getFormat());
                CIMediaXmlFactory.addIfNotNull(xml, "UrlList", fileCompressConfig.getUrlList());
                CIMediaXmlFactory.addIfNotNull(xml, "Prefix", fileCompressConfig.getPrefix());
                List<String> list = fileCompressConfig.getKey();
                if (!list.isEmpty()) {
                    for (String s : list) {
                        xml.start("Key").value(s).end();
                    }
                }
                xml.end();
            } else if (CIMediaXmlFactory.objIsNotValid(operation.getFileUnCompressConfig()).booleanValue()) {
                FileUnCompressConfig fileUnCompressConfig = operation.getFileUnCompressConfig();
                if (CIMediaXmlFactory.objIsNotValid(fileUnCompressConfig).booleanValue()) {
                    xml.start("FileUncompressConfig");
                    CIMediaXmlFactory.addIfNotNull(xml, "Prefix", fileUnCompressConfig.getPrefix());
                    CIMediaXmlFactory.addIfNotNull(xml, "PrefixReplaced", fileUnCompressConfig.getPrefixReplaced());
                    xml.end();
                }
            } else if (CIMediaXmlFactory.objIsNotValid(operation.getFileHashCodeConfig()).booleanValue() && CIMediaXmlFactory.objIsNotValid(fileHashCodeConfig = operation.getFileHashCodeConfig()).booleanValue()) {
                xml.start("FileHashCodeConfig");
                CIMediaXmlFactory.addIfNotNull(xml, "Type", fileHashCodeConfig.getType());
                CIMediaXmlFactory.addIfNotNull(xml, "AddToHeader", fileHashCodeConfig.getAddToHeader());
                xml.end();
            }
            CIMediaXmlFactory.addOutput(xml, operation.getOutput());
            xml.end();
        }
    }
}

