/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.transfer.DownloadPart;
import com.qcloud.cos.transfer.PersistableResumeDownload;
import com.qcloud.cos.utils.CRC64;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeDownloadCallable
implements Callable<DownloadPart> {
    private static final Logger log = LoggerFactory.getLogger(RangeDownloadCallable.class);
    private final COS cos;
    private final GetObjectRequest request;
    private final File destFile;
    private FileChannel destFileChannel;
    private PersistableResumeDownload downloadRecord;

    public RangeDownloadCallable(COS cos, GetObjectRequest request, File destFile, FileChannel destFileChannel, PersistableResumeDownload downloadRecord) {
        this.cos = cos;
        this.request = request;
        this.destFile = destFile;
        this.destFileChannel = destFileChannel;
        this.downloadRecord = downloadRecord;
    }

    @Override
    public DownloadPart call() throws Exception {
        int bytesRead;
        COSObject object = this.cos.getObject(this.request);
        COSObjectInputStream input = object.getObjectContent();
        ObjectMetadata meta = object.getObjectMetadata();
        long[] range = this.request.getRange();
        long start = range[0];
        long end = range[1];
        long position = start;
        ByteBuffer tmpBuf = ByteBuffer.allocateDirect(0x100000);
        byte[] buffer = new byte[10240];
        CRC64 crc64 = new CRC64();
        while ((bytesRead = ((InputStream)input).read(buffer)) > -1) {
            start += (long)bytesRead;
            crc64.update(buffer, bytesRead);
            if (tmpBuf.remaining() < bytesRead) {
                tmpBuf.flip();
                position += (long)this.destFileChannel.write(tmpBuf, position);
                tmpBuf.clear();
            }
            tmpBuf.put(buffer, 0, bytesRead);
        }
        tmpBuf.flip();
        this.destFileChannel.write(tmpBuf, position);
        if (start != end + 1L) {
            this.destFileChannel.close();
            this.destFile.delete();
            String msg = String.format("get object want %d bytes, but got %d bytes, reqeust_id: %s", end + 1L, start, meta.getRequestId());
            throw new CosClientException(msg);
        }
        String block = String.format("%d-%d", range[0], range[1]);
        this.downloadRecord.putDownloadedBlocks(block);
        this.downloadRecord.dump();
        return new DownloadPart(range[0], range[1], crc64.getValue());
    }
}

