/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.emobile.module.msgaudit.controller;

import com.weaver.emobile.api.controller.AbstractController;
import com.weaver.emobile.api.vaildator.group.AddGroup;
import com.weaver.emobile.common.util.R;
import com.weaver.emobile.common.util.RSAKeyGenerator;
import com.weaver.emobile.core.exception.EMException;
import com.weaver.emobile.core.util.ValidatorUtils;
import com.weaver.emobile.module.msgaudit.entity.CpMsgAuditKeyEntity;
import com.weaver.emobile.module.msgaudit.service.CpMsgAuditKeyService;
import com.weaver.emobile.module.msgaudit.vo.CpMsgAuditKeyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/emp/admin/cp/msgaudit/key"})
@Api(tags={"/emp/admin/cp/msgaudit/key"}, description="\u6d88\u606f\u4f1a\u8bdd\u5b58\u6863\u5bc6\u94a5\u63a5\u53e3api")
public class CpMsgAuditKeyController
extends AbstractController {
    @Autowired
    private CpMsgAuditKeyService keyService;

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u6d88\u606f\u4f1a\u8bdd\u5b58\u6863\u5bc6\u94a5\u4fdd\u5b58\u63a5\u53e3", notes="\u6d88\u606f\u4f1a\u8bdd\u5b58\u6863\u5bc6\u94a5\u4fdd\u5b58\u63a5\u53e3")
    public R save(@RequestBody CpMsgAuditKeyVo keyVo) throws Exception {
        if (StringUtils.isBlank((String)keyVo.getId())) {
            ValidatorUtils.validateEntity((Object)keyVo, (Class[])new Class[]{AddGroup.class});
        }
        CpMsgAuditKeyEntity key = keyVo.toEntity();
        if (StringUtils.isBlank((String)keyVo.getId())) {
            CpMsgAuditKeyEntity exists = this.keyService.queryByCorpIdAndVersion(keyVo.getCp_corp_id(), keyVo.getVersion());
            if (exists != null) {
                throw new EMException("\u8bb0\u5f55\u5df2\u5b58\u5728[version=" + keyVo.getVersion() + "]\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e");
            }
            RSAKeyGenerator generator = new RSAKeyGenerator();
            key.setPrivateKey(generator.getPrivateKeyString());
            key.setPublicKey(generator.getPublicKeyString());
            this.keyService.save(key);
            return R.ok((String)"created");
        }
        this.keyService.update(key);
        return R.ok((String)"updated");
    }

    @GetMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u6d88\u606f\u4f1a\u8bdd\u5b58\u6863\u5bc6\u94a5\u5220\u9664\u63a5\u53e3", notes="\u6d88\u606f\u4f1a\u8bdd\u5b58\u6863\u5bc6\u94a5\u5220\u9664\u63a5\u53e3")
    @ApiImplicitParam(name="id", required=true, value="id", dataType="string", paramType="path")
    public R delete(@PathVariable String id) throws Exception {
        this.keyService.delete(id);
        return R.ok((String)"deleted");
    }

    @GetMapping(value={"/query"})
    @ApiOperation(value="\u6d88\u606f\u4f1a\u8bdd\u5b58\u6863\u5bc6\u94a5\u67e5\u8be2\u63a5\u53e3", notes="\u6d88\u606f\u4f1a\u8bdd\u5b58\u6863\u5bc6\u94a5\u67e5\u8be2\u63a5\u53e3")
    @ApiImplicitParam(name="cp_corp_id", required=true, value="cp_corp_id", dataType="string", paramType="query")
    public R query(@RequestParam(value="cp_corp_id") String cp_corp_id) throws Exception {
        List<CpMsgAuditKeyEntity> list = this.keyService.queryByCorpId(cp_corp_id);
        return R.ok().put("list", list);
    }

    @GetMapping(value={"/query/{id}"})
    @ApiOperation(value="\u6d88\u606f\u4f1a\u8bdd\u5b58\u6863\u5bc6\u94a5\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3", notes="\u6d88\u606f\u4f1a\u8bdd\u5b58\u6863\u5bc6\u94a5\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3")
    @ApiImplicitParam(name="id", required=true, value="id", dataType="string", paramType="path")
    public R queryById(@PathVariable String id) throws Exception {
        CpMsgAuditKeyEntity key = (CpMsgAuditKeyEntity)this.keyService.queryObject(id);
        return R.ok().put("key", (Object)key);
    }
}

