/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.automatic.reply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.automatic.reply.AutomaticReplyUtil;
import com.weaver.chatgpt.util.ChatGptUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class AutomaticReplyMsgSendThread
extends Thread {
    private static final Logger Log = LoggerFactory.getLogger(AutomaticReplyMsgSendThread.class);
    private Message msg;

    public AutomaticReplyMsgSendThread(Message msg) {
        this.msg = msg;
    }

    @Override
    public void run() {
        Log.info("AutomaticReplyMsgSendThread,start,msg:{}", (Object)this.msg);
        JID fromJID = this.msg.getFrom();
        String fromUserName = this.msg.getFrom().getNode();
        JID toJID = this.msg.getTo();
        String toUserName = this.msg.getTo().getNode();
        String content = this.msg.getBody();
        JSONObject jsonObject = JSON.parseObject((String)content);
        String msgcontent = null;
        if (jsonObject != null && jsonObject.containsKey((Object)"objectName")) {
            String objectName = jsonObject.getString("objectName");
            if (!"RC:TxtMsg".equals(objectName)) {
                Log.info("AutomaticReplyMsgSendThread,start,msg,\u6d88\u606f\u4e0d\u662f\u6587\u672c:{}", (Object)this.msg);
                return;
            }
            msgcontent = jsonObject.getString("content");
        }
        if (msgcontent == null || msgcontent.isEmpty()) {
            Log.info("AutomaticReplyMsgSendThread,start,msg,msgcontent\u4e3a\u7a7a:{}", (Object)this.msg);
            return;
        }
        String toDomain = toJID.getDomain();
        boolean isGroupMsg = false;
        String groupId = null;
        if (toDomain.startsWith("group.")) {
            isGroupMsg = true;
            groupId = this.msg.getTo().getNode();
        }
        if (!isGroupMsg) {
            AutomaticReplyUtil.goAutomaticReply(msgcontent, fromUserName, toUserName);
        }
    }

    private Message buildGroupMessage(String fromNode, String senderId, String content, String receiverids) {
        Message msg = new Message();
        msg.setType(Message.Type.chat);
        String msgid = StringUtils.randomString((int)14);
        msg.setID(msgid);
        String objectName = "RC:TxtMsg";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("msg_id", msgid);
        extra.put("receiverids", receiverids);
        extra.put("msg_at_userid", this.getRealIdByNode(fromNode));
        extra.put("senderid", senderId);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("extra", extra);
        bodyMap.put("objectName", objectName);
        String username = null;
        try {
            username = UserManager.getInstance().getUser(fromNode).getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String _Atcotent = "@" + this.getAtContent(username, "zh") + " " + content;
        bodyMap.put("content", _Atcotent);
        msg.setBody(JSONObject.toJSONString(bodyMap));
        return msg;
    }

    private static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    private String getAtContent(String s, String lang) {
        if (lang == null || lang.isEmpty() || AutomaticReplyMsgSendThread.isInteger(lang)) {
            lang = "zh";
        }
        String langName = null;
        try {
            JSONObject json = JSON.parseObject((String)s);
            if (json != null) {
                Iterator iterator;
                if (json.containsKey((Object)lang)) {
                    langName = json.getString(lang);
                }
                if ((langName == null || langName.isEmpty()) && json.containsKey((Object)"en")) {
                    langName = json.getString("en");
                }
                if ((langName == null || langName.isEmpty()) && json.containsKey((Object)"zh")) {
                    langName = json.getString("zh");
                }
                if ((langName == null || langName.isEmpty()) && (iterator = json.keySet().iterator()).hasNext()) {
                    String key = (String)iterator.next();
                    langName = json.getString(key);
                }
            }
        }
        catch (Exception e) {
            langName = s;
        }
        return langName;
    }

    private String msgAtUtil(JSONObject json) {
        try {
            String extra;
            JSONObject extraJ;
            String msg_at_userid = null;
            if (json != null && json.containsKey((Object)"extra") && (extraJ = JSONObject.parseObject((String)(extra = json.getString("extra")))) != null && extraJ.containsKey((Object)"msg_at_userid")) {
                msg_at_userid = extraJ.getString("msg_at_userid");
            }
            if (msg_at_userid == null || msg_at_userid.isEmpty()) {
                return "0";
            }
            if ("msg_at_all".equals(msg_at_userid)) {
                return "0";
            }
            String[] msgAtStr = msg_at_userid.split(",");
            for (int i = 0; i < msgAtStr.length; ++i) {
                String s = msgAtStr[i];
                if (s == null || !ChatGptUtil.gptUserIds.contains(s)) continue;
                return s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "0";
    }

    private Message buildSignMessage(String fromNode, String toNode, String content, String receiverids) {
        Message msg = new Message();
        msg.setType(Message.Type.chat);
        String msgid = StringUtils.randomString((int)14);
        msg.setID(msgid);
        String objectName = "RC:TxtMsg";
        receiverids = this.getRealIdByNode(fromNode) + "," + this.getRealIdByNode(toNode);
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("msg_id", msgid);
        extra.put("receiverids", receiverids);
        extra.put("senderid", this.getRealIdByNode(toNode));
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("extra", extra);
        bodyMap.put("objectName", objectName);
        bodyMap.put("content", content);
        msg.setBody(JSONObject.toJSONString(bodyMap));
        return msg;
    }

    private String getRealIdByNode(String node) {
        if (node.startsWith("push|")) {
            return "-1";
        }
        int i = node.indexOf("|");
        if (i > 0) {
            return node.substring(0, i);
        }
        if (i == 0) {
            return "-1";
        }
        return node;
    }
}

