/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.chatgpt.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weaver.chatgpt.util.ChatGptMsgSendThread;
import com.weaver.chatgpt.util.HttpProxyForPush;
import com.weaver.util.ServerInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Message;

public class ChatGptUtil {
    private static final Logger Log = LoggerFactory.getLogger(ChatGptUtil.class);
    public static List<String> gptUserNames = new ArrayList<String>();
    public static List<String> gptUserIds = new ArrayList<String>();
    private static final X509TrustManager x = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };
    private static final TrustManager[] trustAllCerts = new TrustManager[]{x};
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static void main(String[] args) {
        String content = "\u4eca\u5929\u661f\u671f\u51e0";
        System.out.println(ChatGptUtil.getChatGptStr(content));
    }

    public static void sendChatGpt(Message msg) {
        String toNode = msg.getTo().getNode();
        String toDomain = msg.getTo().getDomain();
        if (toDomain.startsWith("group.") || gptUserNames.contains(toNode.toLowerCase())) {
            ChatGptMsgSendThread cgmst = new ChatGptMsgSendThread(msg);
            cgmst.start();
        }
    }

    public static void gptUserIdsInit() {
        try {
            String userIds = JiveGlobals.getProperty((String)"chatgptuserIds");
            if (userIds != null) {
                if (userIds.contains(",")) {
                    String[] strArr = userIds.split(",");
                    for (int i = 0; i < strArr.length; ++i) {
                        gptUserNames.add((strArr[i] + "|" + ServerInfo.SYSTEM_UDID).toLowerCase());
                        gptUserIds.add(strArr[i]);
                    }
                } else {
                    gptUserNames.add((userIds + "|" + ServerInfo.SYSTEM_UDID).toLowerCase());
                    gptUserIds.add(userIds);
                }
            }
            Log.info("gptUserNames:{} ,gptUserIds:{}", gptUserNames, gptUserIds);
        }
        catch (Exception e) {
            Log.error("gptUserIdsInit error :{} ", (Object)e.getMessage());
        }
    }

    public static String getEncoding(String str) {
        String encode = "GB2312";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s = encode;
                return s;
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        encode = "ISO-8859-1";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s1 = encode;
                return s1;
            }
        }
        catch (Exception s1) {
            // empty catch block
        }
        encode = "UTF-8";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s2 = encode;
                return s2;
            }
        }
        catch (Exception s2) {
            // empty catch block
        }
        encode = "GBK";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s3 = encode;
                return s3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getChatGptStr(String content) {
        String text = "\u670d\u52a1\u5f02\u5e38";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("model", "text-davinci-003");
        param.put("prompt", content);
        param.put("max_tokens", 2048);
        param.put("temperature", 0);
        param.put("top_p", 1);
        param.put("frequency_penalty", 0);
        param.put("presence_penalty", 0.6);
        ArrayList<String> stop = new ArrayList<String>();
        stop.add("Human");
        stop.add("AI");
        param.put("stop", stop);
        String result = null;
        try {
            result = ChatGptUtil.httpPost(JSON.toJSONString(param));
        }
        catch (IOException e) {
            Log.error("\u8bfb\u53d6\u56de\u590d\u503c\u8d85\u65f6\uff1a{} ", (Throwable)e);
        }
        if (result != null) {
            JSONObject s = JSON.parseObject((String)result);
            System.err.println(s);
            if (s != null && s.containsKey((Object)"choices")) {
                JSONObject jsonObject;
                JSONArray choices = (JSONArray)s.get((Object)"choices");
                for (int i = 0; !(i >= choices.size() || (jsonObject = (JSONObject)choices.get(i)) != null && jsonObject.containsKey((Object)"text") && (text = jsonObject.getString("text")) != null && text.length() > 0); ++i) {
                }
            }
        }
        Log.info("getChatGptStr,content :{} ,text:{}", (Object)content, (Object)text);
        return text;
    }

    private static String getUnicodeStr(String text) {
        try {
            byte[] by = text.getBytes("UTF-8");
            return new String(by);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String httpPost(String data) throws IOException {
        String string;
        OutputStream outPut = null;
        HttpURLConnection urlConnection = null;
        InputStream in = null;
        try {
            URL url = new URL("https://api.openai.com/v1/completions");
            HttpProxyForPush httpProxy = HttpProxyForPush.getInstance();
            boolean isUserProxy = httpProxy.isUserProxy();
            if (isUserProxy) {
                InetSocketAddress addr = new InetSocketAddress(httpProxy.getProxyHost(), httpProxy.getProxyPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                urlConnection = (HttpsURLConnection)url.openConnection(proxy);
                boolean isNeedAuth = httpProxy.isPropxyNeedAuth();
                if (isNeedAuth) {
                    String encoded = new String(Base64.encodeBase64((byte[])(httpProxy.getProxyUsername() + ":" + httpProxy.getProxyPassword()).getBytes()));
                    urlConnection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
                }
            } else {
                urlConnection = (HttpsURLConnection)url.openConnection();
            }
            urlConnection.setRequestProperty("Authorization", "Bearer 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");
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            ChatGptUtil.trustAllHosts((HttpsURLConnection)urlConnection);
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(DO_NOT_VERIFY);
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setConnectTimeout(30000);
            urlConnection.setReadTimeout(30000);
            urlConnection.connect();
            outPut = urlConnection.getOutputStream();
            outPut.write(data.getBytes("UTF-8"));
            outPut.flush();
            in = urlConnection.getResponseCode() < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            List lines = IOUtils.readLines((InputStream)in, (String)"UTF-8");
            StringBuffer strBuf = new StringBuffer();
            for (String line : lines) {
                strBuf.append(line);
            }
            string = strBuf.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outPut);
            IOUtils.closeQuietly(in);
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outPut);
        IOUtils.closeQuietly((InputStream)in);
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
        return string;
    }

    private static SSLSocketFactory trustAllHosts(HttpsURLConnection connection) {
        SSLSocketFactory oldFactory = connection.getSSLSocketFactory();
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory newFactory = sc.getSocketFactory();
            connection.setSSLSocketFactory(newFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return oldFactory;
    }

    private static String getMD5String(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

