/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.chatgpt.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyForPush {
    private static final Logger Log = LoggerFactory.getLogger(HttpProxyForPush.class);
    private static HttpProxyForPush instance = null;
    private boolean userProxy = false;
    private String proxyHost;
    private int proxyPort = 0;
    private boolean propxyNeedAuth = false;
    private String proxyUsername;
    private String proxyPassword;

    private HttpProxyForPush() {
        this.loadHttpProxyProperties();
    }

    private void loadHttpProxyProperties() {
        String filePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "httpProxy.properties";
        File file = new File(filePath);
        if (!file.exists()) {
            Log.warn("loadHttpProxyProperties .file :{} is not exist .", (Object)filePath);
            return;
        }
        FileInputStream is = null;
        Properties properties = new Properties();
        try {
            is = new FileInputStream(file);
            properties.load(is);
            this.userProxy = Boolean.valueOf(properties.getProperty("userProxy"));
            this.proxyHost = properties.getProperty("proxyHost");
            String post = properties.getProperty("proxyPort");
            this.proxyPort = Integer.parseInt(post);
            this.propxyNeedAuth = Boolean.valueOf(properties.getProperty("propxyNeedAuth"));
            this.proxyUsername = properties.getProperty("proxyUsername");
            this.proxyPassword = properties.getProperty("proxyPassword");
            Log.info("userProxy:{},userHost:{},prot:{},needAuth:{},username:{},password:{}", new Object[]{this.userProxy, this.proxyHost, this.proxyPort, this.propxyNeedAuth, this.proxyUsername, this.proxyPassword});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HttpProxyForPush getInstance() {
        if (instance == null) {
            instance = new HttpProxyForPush();
        }
        return instance;
    }

    public boolean isUserProxy() {
        return this.userProxy;
    }

    public void setUserProxy(boolean userProxy) {
        this.userProxy = userProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean isPropxyNeedAuth() {
        return this.propxyNeedAuth;
    }

    public void setPropxyNeedAuth(boolean propxyNeedAuth) {
        this.propxyNeedAuth = propxyNeedAuth;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public static void setInstance(HttpProxyForPush instance) {
        HttpProxyForPush.instance = instance;
    }
}

