/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.emessage.multirouter.messagemanager;

import com.weaver.util.ServerInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.database.DbConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatStatisticUtil {
    private static final Logger Log = LoggerFactory.getLogger(ChatStatisticUtil.class);

    public List<Map<String, Object>> chatStatisticUtil(String userIds, String searchType, String year, String month, String fromDate, String toDate, String datetime) {
        List<Object> result = new ArrayList();
        List<String> userIdList = this.str2List(userIds);
        if ("year".equals(searchType)) {
            result = this.getYear(userIdList, year);
        } else if ("month".equals(searchType)) {
            result = this.getMonth(userIdList, month);
        } else if ("date".equals(searchType)) {
            result = this.getDate(userIdList, fromDate, toDate);
        } else if ("group".equals(searchType)) {
            result = this.getGroup(userIdList, datetime);
        } else if ("message".equals(searchType)) {
            result = this.getAvgSignChat(userIdList, fromDate, toDate);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getAvgSignChat(List<String> userIds, String fromDate, String toDate) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int dateCount = ChatStatisticUtil.getDatePoor(fromDate, toDate);
        try {
            con = DbConnectionManager.getConnection();
            for (String userId : userIds) {
                Long toDateL;
                String sql = " SELECT COUNT(1) as signChatCount from OFMSGSTATISTICCHATDAY where targetType = '1' and userid = ? and day >= ? and day <= ? ";
                pstmt = con.prepareStatement(sql);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("userId", userId);
                pstmt.setString(1, userId);
                pstmt.setString(2, fromDate);
                pstmt.setString(3, toDate);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int signChatCount = rs.getInt("signChatCount");
                    int avgSignChat = signChatCount / dateCount;
                    map.put("avgSignChat", avgSignChat);
                }
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlGroupChatCount = " SELECT count(DISTINCT targetId) as groupChatCount from OFMSGSTATISTICCHATDAY where targetType = '2' and userid = ? and day >= ? and day <= ? ";
                pstmt = con.prepareStatement(sqlGroupChatCount);
                pstmt.setString(1, userId);
                pstmt.setString(2, fromDate);
                pstmt.setString(3, toDate);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int groupChatCount = rs.getInt("groupChatCount");
                    map.put("groupChatCount", groupChatCount);
                }
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlUserIsGroupAdmin = "SELECT count(DISTINCT targetId) as adminGroupCount from OFMSGSTATISTICCHATDAY where targetType = '2' and userid = ? and day >= ? and day <= ?  and EXISTS ( SELECT 1 FROM ofGroupUser where groupname = targetId and username = ? and administrator = '1' ) ";
                pstmt = con.prepareStatement(sqlUserIsGroupAdmin);
                pstmt.setString(1, userId);
                pstmt.setString(2, fromDate);
                pstmt.setString(3, toDate);
                pstmt.setString(4, (userId + "|" + ServerInfo.SYSTEM_UDID).toLowerCase());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int adminGroupChatCount = rs.getInt("adminGroupCount");
                    map.put("adminGroupChatCount", adminGroupChatCount);
                }
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlCount = "";
                sqlCount = DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType()) ? " select top(5) sum(receiveCount) as totalCount,targetId from OFCONVERSTATISDAY where userId = ? and targetType = '1' and day >= ? and day <= ? group by targetId order BY totalCount desc  " : (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) ? " select sum(receiveCount) as totalCount,targetId from OFCONVERSTATISDAY where userId = ? and targetType = '1' and day >= ? and day <= ? group by targetId order BY totalCount desc limit 5 " : "select rownum,totalCount,targetId from (select sum(receiveCount) as totalCount,targetId from OFCONVERSTATISDAY where userId = ? and targetType = '1' and day >= ? and day <= ? group by targetId order BY totalCount desc ) where rownum <= 1 ");
                pstmt = con.prepareStatement(sqlCount);
                pstmt.setString(1, userId);
                pstmt.setString(2, fromDate);
                pstmt.setString(3, toDate);
                rs = pstmt.executeQuery();
                ArrayList maxChatUsers = new ArrayList();
                while (rs.next()) {
                    int count = 0;
                    String userid = "-1";
                    HashMap<String, Object> maxChatMap = new HashMap<String, Object>();
                    String groupId = rs.getString("targetId");
                    count = rs.getInt("totalCount");
                    userid = "";
                    if (groupId.contains("-" + userId)) {
                        userid = groupId.replace("-" + userId, "");
                    } else if (groupId.contains(userId + "-")) {
                        userid = groupId.replace(userId + "-", "");
                    }
                    maxChatMap.put("userId", userid);
                    maxChatMap.put("count", count);
                    maxChatUsers.add(maxChatMap);
                }
                map.put("maxChatUsers", maxChatUsers);
                String msgCountSQL = " select sum(sendCount) as yearSendCount,sum(receiveCount) as yearReceiveCount from OFMSGSTATISTICDAY where userId = ? and day >= ? and day <= ? ";
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(msgCountSQL);
                pstmt.setString(1, userId);
                pstmt.setString(2, fromDate);
                pstmt.setString(3, toDate);
                rs = pstmt.executeQuery();
                int allSend = 0;
                int allReceive = 0;
                String usedMessage = "0";
                while (rs.next()) {
                    allSend = rs.getInt("yearSendCount");
                    allReceive = rs.getInt("yearReceiveCount");
                    if (allSend <= 0 && allReceive >= 0) continue;
                    usedMessage = "1";
                }
                map.put("usedMessage", usedMessage);
                int createGroupCount = 0;
                String createGroupCountSql = " select count(1) as createGroupCount from ofgroup where createUser = ? and createTime >= ? and createTime <= ?  ";
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(createGroupCountSql);
                pstmt.setString(1, (userId + "|" + ServerInfo.SYSTEM_UDID).toLowerCase());
                Long fromDateL = ChatStatisticUtil.timeToMillis(fromDate);
                if (fromDateL == null) {
                    fromDateL = 0L;
                }
                if ((toDateL = ChatStatisticUtil.timeToMillis(toDate)) == null) {
                    toDateL = System.currentTimeMillis();
                }
                pstmt.setString(2, String.valueOf(fromDateL));
                pstmt.setString(3, String.valueOf(toDateL));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    createGroupCount = rs.getInt("createGroupCount");
                }
                map.put("createGroupCount", createGroupCount);
                result.add(map);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getAvgSignChat ,userIds :{} ,fromDate:{} ,toDate:{} ,error :{} ,e :{} ", new Object[]{userIds, fromDate, toDate, e.getMessage(), e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
        return result;
    }

    private static Long timeToMillis(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date d = null;
        try {
            d = sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
        return d.getTime();
    }

    private static int getDatePoor(String fromDate, String toDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = sdf.parse(fromDate);
            endDate = sdf.parse(toDate);
        }
        catch (ParseException e) {
            Log.error("getDatePoor error :{} fromDate:{} ,toDate :{} ,e :{} ", new Object[]{e.getMessage(), fromDate, toDate, e});
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(endDate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        int parseInt = Integer.parseInt(String.valueOf(between_days));
        return parseInt + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getGroup(List<String> userIds, String datetime) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String createTime = null;
        if (datetime != null && !datetime.isEmpty()) {
            SimpleDateFormat SDF_SIMPLE = new SimpleDateFormat("yyyy-MM-dd");
            try {
                createTime = String.valueOf(SDF_SIMPLE.parse(datetime).getTime());
            }
            catch (ParseException e) {
                Log.error("getGroup,error:{},e:{},userIds:{},datetime:{}", new Object[]{e.getMessage(), e, userIds, datetime});
            }
        }
        try {
            con = DbConnectionManager.getConnection();
            String sql = null;
            sql = datetime == null || datetime.isEmpty() ? " select count(1) as groupCount from ofGroupUser where username = ? and administrator = 1 and (isdel is null or isdel = 0 ) " : " SELECT COUNT (1) AS groupCount FROM\tofGroupUser a left JOIN ofgroup b on a.groupName = b.groupname WHERE  a.username = ? AND a.administrator = 1 AND (a.isdel IS NULL OR a.isdel = 0) AND (b.createtime < ? or b.createtime is NULL) ";
            for (String userId : userIds) {
                pstmt = con.prepareStatement(sql);
                pstmt.setString(1, (userId + "|" + ServerInfo.SYSTEM_UDID).toLowerCase());
                if (datetime != null && !datetime.isEmpty()) {
                    pstmt.setString(2, createTime);
                }
                rs = pstmt.executeQuery();
                HashMap<String, Object> g = new HashMap<String, Object>();
                while (rs.next()) {
                    g.put("userId", userId);
                    g.put("groupCount", rs.getInt("groupCount"));
                }
                result.add(g);
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getGroup ,error :{} ,userIds:{},datetime :{} ,e :{} ", new Object[]{e.getMessage(), userIds, datetime, e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getDate(List<String> userIds, String fromDate, String toDate) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            for (String userId : userIds) {
                HashMap<String, Object> userMap = new HashMap<String, Object>();
                String sqlChatCount = "select  count(DISTINCT targetId) as chatCount  from OFMSGSTATISTICCHATDAY WHERE userId = ? and targetType = ? and  day >= ? and  day <= ? ";
                int signleChat = 0;
                pstmt = con.prepareStatement(sqlChatCount);
                pstmt.setString(1, userId);
                pstmt.setInt(2, 1);
                pstmt.setString(3, fromDate);
                pstmt.setString(4, toDate);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    signleChat = rs.getInt("chatCount");
                }
                userMap.put("signleChat", signleChat);
                userMap.put("userId", userId);
                int chatGroup = 0;
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(sqlChatCount);
                pstmt.setString(1, userId);
                pstmt.setInt(2, 2);
                pstmt.setString(3, fromDate);
                pstmt.setString(4, toDate);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    chatGroup = rs.getInt("chatCount");
                }
                userMap.put("groupChat", chatGroup);
                String msgCountSQL = " select sum(sendCount) as yearSendCount,sum(receiveCount) as yearReceiveCount from OFMSGSTATISTICDAY where userId = ? and day >= ? and day <= ? ";
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(msgCountSQL);
                pstmt.setString(1, userId);
                pstmt.setString(2, fromDate);
                pstmt.setString(3, toDate);
                rs = pstmt.executeQuery();
                int allSend = 0;
                int allReceive = 0;
                while (rs.next()) {
                    allSend = rs.getInt("yearSendCount");
                    allReceive = rs.getInt("yearReceiveCount");
                }
                userMap.put("allSend", allSend);
                userMap.put("allReceive", allReceive);
                String mostSendDay = null;
                int mostSend = 0;
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlMostSend = null;
                sqlMostSend = DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType()) ? "select top(1) day,sendCount from OFMSGSTATISTICDAY WHERE userId = ? and day >= ? and day <= ? order by sendCount desc" : (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) ? "select day,sendCount from OFMSGSTATISTICDAY WHERE userId = ? and day >= ? and day <= ? order by sendCount desc limit 1" : "select rownum,DAY,sendCount  from (select day,sendCount from OFMSGSTATISTICDAY WHERE userId = ? and day >= ? and day <= ? order by sendCount desc) where rownum = 1");
                pstmt = con.prepareStatement(sqlMostSend);
                pstmt.setString(1, userId);
                pstmt.setString(2, fromDate);
                pstmt.setString(3, toDate);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    mostSendDay = rs.getString("day");
                    mostSend = rs.getInt("sendCount");
                }
                userMap.put("mostSendDay", mostSendDay);
                userMap.put("mostSend", mostSend);
                String mostReceiveDay = null;
                int mostReceive = 0;
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlMostReceive = null;
                sqlMostReceive = DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType()) ? "select top(1) day,receiveCount from OFMSGSTATISTICDAY WHERE userId = ? and day >= ? and day <= ? order by receiveCount desc" : (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) ? "select day,receiveCount from OFMSGSTATISTICDAY WHERE userId = ? and day >= ? and day <= ? order by receiveCount desc limit 1" : "select rownum,day,receiveCount  from (select day,receiveCount from OFMSGSTATISTICDAY WHERE userId = ? and day >= ? and day <= ? order by receiveCount desc) where rownum = 1");
                pstmt = con.prepareStatement(sqlMostReceive);
                pstmt.setString(1, userId);
                pstmt.setString(2, fromDate);
                pstmt.setString(3, toDate);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    mostReceiveDay = rs.getString("day");
                    mostReceive = rs.getInt("receiveCount");
                }
                userMap.put("mostReceive", mostReceive);
                userMap.put("mostReceiveDay", mostReceiveDay);
                result.add(userMap);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getDate ,error :{},userIds :{} ,fromDate:{},toDate:{} ,e :{}", new Object[]{e.getMessage(), userIds, fromDate, toDate, e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getMonth(List<String> userIds, String month) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            for (String userId : userIds) {
                HashMap<String, Object> userMap = new HashMap<String, Object>();
                String sqlChatCount = "select chatCount,groupChatCount from OFMSGSTATISTICCHATMONTH WHERE USERID = ? and month = ? ";
                int signleChat = 0;
                int chatGroup = 0;
                pstmt = con.prepareStatement(sqlChatCount);
                pstmt.setString(1, userId);
                pstmt.setString(2, month);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    signleChat = rs.getInt("chatCount");
                    chatGroup = rs.getInt("groupChatCount");
                }
                userMap.put("signleChat", signleChat);
                userMap.put("groupChat", chatGroup);
                String msgCountSQL = " select sendCount,receiveCount from OFMSGSTATISTICMONTH WHERE USERID = ? and month = ? ";
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(msgCountSQL);
                pstmt.setString(1, userId);
                pstmt.setString(2, month);
                rs = pstmt.executeQuery();
                int allSend = 0;
                int allReceive = 0;
                while (rs.next()) {
                    allSend = rs.getInt("sendCount");
                    allReceive = rs.getInt("receiveCount");
                }
                userMap.put("userId", userId);
                userMap.put("allSend", allSend);
                userMap.put("allReceive", allReceive);
                String mostSendDay = null;
                int mostSend = 0;
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlMostSend = null;
                sqlMostSend = DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType()) ? "select top(1) day,sendCount from OFMSGSTATISTICDAY WHERE userId = ? and month = ?  order by sendCount desc " : (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) ? "select day,sendCount from OFMSGSTATISTICDAY WHERE userId = ? and month = ? order by sendCount desc limit 1 " : "select rownum,DAY,sendCount  from (select day,sendCount from OFMSGSTATISTICDAY WHERE userId = ? and month = ? order by sendCount desc) where rownum = 1 ");
                pstmt = con.prepareStatement(sqlMostSend);
                pstmt.setString(1, userId);
                pstmt.setString(2, month);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    mostSendDay = rs.getString("day");
                    mostSend = rs.getInt("sendCount");
                }
                userMap.put("mostSendDay", mostSendDay);
                userMap.put("mostSend", mostSend);
                String mostReceiveDay = null;
                int mostReceive = 0;
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlMostReceive = null;
                sqlMostReceive = DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType()) ? "select top(1) day,receiveCount from OFMSGSTATISTICDAY WHERE userId = ? and month = ? order by receiveCount desc" : (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) ? "select day,receiveCount from OFMSGSTATISTICDAY WHERE userId = ? and month = ? order by receiveCount desc limit 1" : "select rownum,day,receiveCount  from (select day,receiveCount from OFMSGSTATISTICDAY WHERE userId = ? and month = ? order by receiveCount desc) where rownum = 1");
                pstmt = con.prepareStatement(sqlMostReceive);
                pstmt.setString(1, userId);
                pstmt.setString(2, month);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    mostReceiveDay = rs.getString("day");
                    mostReceive = rs.getInt("receiveCount");
                }
                userMap.put("mostReceive", mostReceive);
                userMap.put("mostReceiveDay", mostReceiveDay);
                result.add(userMap);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getMonth ,error :{},userIds :{},month:{} ,e :{}", new Object[]{e.getMessage(), userIds, month, e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getYear(List<String> userIds, String year) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            for (String userId : userIds) {
                HashMap<String, Object> userMap = new HashMap<String, Object>();
                userMap.put("userId", userId);
                String sqlChatCount = "select chatCount,groupChatCount  from OFMSGSTATISTICCHATYEAR WHERE USERID = ? and year = ? ";
                int signleChat = 0;
                int chatGroup = 0;
                pstmt = con.prepareStatement(sqlChatCount);
                pstmt.setString(1, userId);
                pstmt.setString(2, year);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    signleChat = rs.getInt("chatCount");
                    chatGroup = rs.getInt("groupChatCount");
                }
                userMap.put("signleChat", signleChat);
                userMap.put("groupChar", chatGroup);
                String msgCountSQL = " select sendCount,receiveCount from OFMSGSTATISTICYEAR WHERE USERID = ? and year = ? ";
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(msgCountSQL);
                pstmt.setString(1, userId);
                pstmt.setString(2, year);
                rs = pstmt.executeQuery();
                int allSend = 0;
                int allReceive = 0;
                while (rs.next()) {
                    allSend = rs.getInt("sendCount");
                    allReceive = rs.getInt("receiveCount");
                }
                userMap.put("allSend", allSend);
                userMap.put("allReceive", allReceive);
                String mostSendDay = null;
                int mostSend = 0;
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlMostSend = null;
                sqlMostSend = DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType()) ? "select top(1) day,sendCount from OFMSGSTATISTICDAY WHERE userId = ? and year = ?  order by sendCount desc " : (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) ? "select day,sendCount from OFMSGSTATISTICDAY WHERE userId = ? and year = ? order by sendCount desc limit 1 " : "select rownum,DAY,sendCount  from (select day,sendCount from OFMSGSTATISTICDAY WHERE userId = ? and year = ? order by sendCount desc) where rownum = 1 ");
                pstmt = con.prepareStatement(sqlMostSend);
                pstmt.setString(1, userId);
                pstmt.setString(2, year);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    mostSendDay = rs.getString("day");
                    mostSend = rs.getInt("sendCount");
                }
                userMap.put("mostSendDay", mostSendDay);
                userMap.put("mostSend", mostSend);
                String mostReceiveDay = null;
                int mostReceive = 0;
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlMostReceive = null;
                sqlMostReceive = DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType()) ? "select top(1) day,receiveCount from OFMSGSTATISTICDAY WHERE userId = ? and year = ? order by receiveCount desc" : (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) ? "select day,receiveCount from OFMSGSTATISTICDAY WHERE userId = ? and year = ? order by receiveCount desc limit 1" : "select rownum,day,receiveCount  from (select day,receiveCount from OFMSGSTATISTICDAY WHERE userId = ? and year = ? order by receiveCount desc) where rownum = 1");
                pstmt = con.prepareStatement(sqlMostReceive);
                pstmt.setString(1, userId);
                pstmt.setString(2, year);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    mostReceiveDay = rs.getString("day");
                    mostReceive = rs.getInt("receiveCount");
                }
                userMap.put("mostReceive", mostReceive);
                userMap.put("mostReceiveDay", mostReceiveDay);
                result.add(userMap);
            }
        }
        catch (SQLException e) {
            Log.error("getYear ,error :{},userIds :{},year:{} ,e :{}", new Object[]{e.getMessage(), userIds, year, e});
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
        }
        return result;
    }

    private List<String> str2List(String str) {
        String[] strs;
        ArrayList<String> result = new ArrayList<String>();
        if (str == null || str.isEmpty()) {
            return result;
        }
        if (!str.contains(",")) {
            result.add(str);
            return result;
        }
        for (String s : strs = str.split(",")) {
            result.add(s);
        }
        return result;
    }
}

