/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.emessage.multirouter.messagemanager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.util.WeiSouPropertiesUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.dao.ChatSearchIQDao;
import org.jivesoftware.openfire.plugin.dao.HistorySearchIQDao;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.openfire.plugin.util.DingUtil;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weaver.fullsearch.interfaces.service.MegSearch;

public class HistoryMessageSearchUtil {
    private static final Logger logger = LoggerFactory.getLogger(HistoryMessageSearchUtil.class);

    public Map<String, Object> chatSearch(Integer pageNumber, Integer pageSize, String keyword, String senderId, String startTime, String endTime, String userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<Object, Object> map = new HashMap();
        WeiSouPropertiesUtil w = WeiSouPropertiesUtil.getInstance();
        boolean weiSouEnable = w.isWeiSouEnable();
        boolean msgSearchValidate = false;
        if (weiSouEnable) {
            msgSearchValidate = MegSearch.searchValidate((String)"MSGSEARCH");
        }
        if (weiSouEnable && msgSearchValidate) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("schemaType", "MSGSEARCH");
            if (StringUtils.isNotBlank((CharSequence)keyword)) {
                paramMap.put("keyword", keyword);
            }
            if (endTime != null && !endTime.contains("23:59:59") && !endTime.isEmpty() && endTime.length() <= 12) {
                endTime = endTime + " 23:59:59";
            }
            if (StringUtils.isNotBlank((CharSequence)startTime)) {
                paramMap.put("startTime", startTime);
            }
            if (StringUtils.isNotBlank((CharSequence)endTime)) {
                paramMap.put("endTime", endTime);
            }
            paramMap.put("pageNumber", pageNumber);
            paramMap.put("pageSize", pageSize);
            paramMap.put("targetType", "1,2");
            paramMap.put("userid", userId);
            String msgType = "";
            msgType = StringUtils.isBlank((CharSequence)keyword) ? "RC:TxtMsg,RC:ImgMsg,RC:VcMsg,RC:LBSMsg,FW:attachmentMsg,FW:PersonCardMsg,FW:CMDMsg,FW:richTextMsg,FW:LinkMsg,FW:NewsMsg,FW:CustomShareMsg,FW:VoIPMsg,FW:Extension_Msg,RC:PublicNoticeMsg,FW:UniteMsg,RC:ExpMsg" : "RC:TxtMsg,FW:attachmentMsg,FW:CustomShareMsg";
            paramMap.put("Classname", msgType);
            paramMap.put("searchType", "group");
            if (senderId != null && !senderId.isEmpty()) {
                paramMap.put("fromUserId", senderId);
            }
            HashMap<String, String> sortMap = new HashMap<String, String>();
            sortMap.put("ID", "false");
            HashMap<String, Integer> aggMap = new HashMap<String, Integer>();
            aggMap.put("groupId", 1);
            boolean flag = MegSearch.searchValidate((String)"MSGSEARCH");
            Map weiSouMap = MegSearch.search(paramMap, sortMap, aggMap);
            map = this.convertWeiSouToClient(weiSouMap, pageNumber, pageSize, userId);
        } else {
            if (weiSouEnable && !msgSearchValidate) {
                logger.info("==============ChatSeach\u5fae\u641c\u5df2\u5f00\u542f\uff0c\u5fae\u641c\u7d22\u5f15\u4e0d\u53ef\u7528\u3002===================");
            }
            if (JiveGlobals.getBooleanProperty((String)"searchChatMsg", (boolean)true)) {
                ChatSearchIQDao chatSearchIQDao = new ChatSearchIQDao();
                map = chatSearchIQDao.searchChatId(pageNumber, pageSize, keyword, userId, senderId, startTime, endTime);
            } else {
                map = new HashMap();
            }
        }
        result.put("searchedChat", map.get("searchedChat"));
        result.put("pageNumber", map.get("pageNumber"));
        result.put("pageSize", map.get("pageSize"));
        result.put("totalCount", map.get("totalCount"));
        result.put("chatMessage", map.get("chatMessage"));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> convertWeiSouToClient(Map<String, Object> weiSouMap, Integer pageNumber, Integer pageSize, String userId) {
        HashMap mapChatMessage;
        ArrayList<String> listGroupId;
        HashMap<String, Object> result;
        block14: {
            result = new HashMap<String, Object>();
            listGroupId = new ArrayList<String>();
            mapChatMessage = new HashMap();
            List listResult = (List)weiSouMap.get("result");
            if (null == listResult) break block14;
            GroupManager groupManager = GroupManager.getInstance();
            for (int i = 0; i < listResult.size(); ++i) {
                Map mapWei;
                block15: {
                    HashMap<String, String> mapChatDetail;
                    String groupIconUrl;
                    String groupName;
                    String targetType;
                    String targetId;
                    block13: {
                        block16: {
                            String groupId;
                            mapWei = (Map)listResult.get(i);
                            targetId = mapWei.get("targetid") == null ? "" : mapWei.get("targetid").toString();
                            targetType = mapWei.get("targetType") == null ? "" : mapWei.get("targetType").toString();
                            String msgCount = mapWei.get("msgCount") == null ? "" : mapWei.get("msgCount").toString();
                            groupName = "";
                            groupIconUrl = "";
                            Group group = null;
                            String groupType = "0";
                            mapChatDetail = new HashMap<String, String>();
                            if (targetType.equals("2")) {
                                try {
                                    group = groupManager.getGroup(targetId);
                                    if (group == null) continue;
                                    groupName = group.getDescription();
                                    PersistableMap groupProp = group.getProperties();
                                    if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                        groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                                    }
                                    if (groupProp != null && groupProp.containsKey((Object)"groupType")) {
                                        groupType = (String)groupProp.get((Object)"groupType");
                                    }
                                    String secretGroupType = "0";
                                    if (groupProp != null && groupProp.containsKey((Object)"secretGroupType")) {
                                        secretGroupType = (String)groupProp.get((Object)"secretGroupType");
                                    }
                                    if ("1".equals(secretGroupType)) {
                                        DatabaseUtil db = new DatabaseUtil();
                                        mapChatDetail.put("secretGroupTargetId", db.getSecretChatTargetId(userId, targetId));
                                    }
                                    listGroupId.add(targetId);
                                    mapChatDetail.put("msgCount", msgCount);
                                    mapChatDetail.put("targetId", targetId);
                                    mapChatDetail.put("targetType", targetType);
                                    mapChatDetail.put("groupName", groupName);
                                    mapChatDetail.put("groupIconUrl", groupIconUrl);
                                    mapChatDetail.put("groupType", groupType);
                                    mapChatDetail.put("secretGroupType", secretGroupType);
                                    mapChatMessage.put(targetId, mapChatDetail);
                                }
                                catch (Exception e) {
                                    logger.error("convertWeiSouToClient .group not found.mapWei:{}", (Object)JSON.toJSONString((Object)mapWei).toString());
                                }
                                continue;
                            }
                            if (!"1".equals(targetType)) break block15;
                            mapChatDetail.put("msgCount", msgCount);
                            String string = groupId = mapWei.get("groupId") == null ? "" : mapWei.get("groupId").toString();
                            if (!StringUtils.isNotBlank((CharSequence)groupId)) break block16;
                            String[] arrayGroupId = groupId.split("-");
                            if (arrayGroupId.length != 2) {
                                logger.warn("convertWeiSouToClient .arrayGroupId length is not 2.mapWei:{}", (Object)JSON.toJSONString((Object)mapWei).toString());
                                continue;
                            }
                            if (userId.equals(arrayGroupId[0])) {
                                targetId = arrayGroupId[1];
                                break block13;
                            } else if (userId.equals(arrayGroupId[1])) {
                                targetId = arrayGroupId[0];
                                break block13;
                            } else {
                                logger.warn("convertWeiSouToClient .arrayGroupId is not has userId.mapWei:{}", (Object)JSON.toJSONString((Object)mapWei).toString());
                                continue;
                            }
                        }
                        logger.warn("convertWeiSouToClient .groupId is null.mapWei:{}", (Object)JSON.toJSONString((Object)mapWei).toString());
                        continue;
                    }
                    listGroupId.add(targetId);
                    mapChatDetail.put("targetId", targetId);
                    mapChatDetail.put("targetType", targetType);
                    mapChatDetail.put("groupName", groupName);
                    mapChatDetail.put("groupIconUrl", groupIconUrl);
                    mapChatMessage.put(targetId, mapChatDetail);
                    continue;
                }
                logger.warn("convertWeiSouToClient .targetType is not 1 or 2.mapWei:{}", (Object)JSON.toJSONString((Object)mapWei).toString());
            }
        }
        result.put("searchedChat", listGroupId);
        result.put("pageNumber", pageNumber);
        result.put("pageSize", pageSize);
        result.put("totalCount", weiSouMap.get("count"));
        result.put("chatMessage", mapChatMessage);
        return result;
    }

    public Map<String, Object> historySearch(String fromUserId, String targetId, Integer targetType, Integer pageNumber, Integer pageSize, String startTime, String endTime, String keyword, String msgType, String dataId, String orderType, String senderId) {
        WeiSouPropertiesUtil w;
        Map<Object, Object> map = new HashMap();
        HashMap<String, Object> result = new HashMap<String, Object>();
        String groupId = "";
        if (targetType == 1 || targetType == 8 || targetType == 101 || targetType == 102 || targetType == 103 || targetType == 111) {
            groupId = fromUserId.compareToIgnoreCase(targetId) >= 0 ? targetId + "-" + fromUserId : fromUserId + "-" + targetId;
            if (targetType == 8 || targetType == 101 || targetType == 102 || targetType == 103 || targetType == 111) {
                targetType = targetType + 1;
            }
        } else if (targetType == 2) {
            groupId = targetId;
        }
        if (endTime != null && !endTime.contains("23:59:59") && !endTime.isEmpty() && endTime.length() <= 12) {
            endTime = endTime + " 23:59:59";
        }
        if (msgType != null && !msgType.isEmpty() && (msgType.contains("FW:LinkMsg") || msgType.equals("FW:richTextMsg")) && !msgType.contains("FW:CustomShareMsg")) {
            if (msgType.contains("FW:LinkMsg") && !msgType.contains("FW:CustomShareMsg") && !msgType.equals("FW:richTextMsg")) {
                msgType = msgType.endsWith(",") ? msgType + "FW:CustomShareMsg,FW:richTextMsg" : msgType + ",FW:CustomShareMsg,FW:richTextMsg";
            } else if (msgType.contains("FW:richTextMsg") && !msgType.contains("FW:CustomShareMsg") && !msgType.equals("FW:LinkMsg")) {
                msgType = msgType.endsWith(",") ? msgType + "FW:CustomShareMsg,FW:LinkMsg" : msgType + ",FW:CustomShareMsg,FW:LinkMsg";
            }
        }
        if ((w = WeiSouPropertiesUtil.getInstance()).isWeiSouEnable() && MegSearch.searchValidate((String)"MSGSEARCH")) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("schemaType", "MSGSEARCH");
            if (StringUtils.isNotBlank((CharSequence)groupId)) {
                paramMap.put("groupId", groupId);
            }
            if (null != pageNumber) {
                paramMap.put("pageNumber", pageNumber);
            }
            if (null != pageSize) {
                paramMap.put("pageSize", pageSize);
            }
            if (senderId != null && !senderId.isEmpty()) {
                paramMap.put("fromUserId", senderId);
            }
            if (StringUtils.isNotBlank((CharSequence)startTime)) {
                paramMap.put("startTime", startTime);
            }
            if (StringUtils.isNotBlank((CharSequence)endTime)) {
                paramMap.put("endTime", endTime);
            }
            if (StringUtils.isNotBlank((CharSequence)keyword)) {
                paramMap.put("keyword", keyword);
            }
            paramMap.put("userid", fromUserId);
            if (StringUtils.isBlank((CharSequence)msgType)) {
                msgType = StringUtils.isBlank((CharSequence)keyword) ? "RC:TxtMsg,RC:ImgMsg,RC:VcMsg,RC:LBSMsg,FW:attachmentMsg,FW:PersonCardMsg,FW:CMDMsg,FW:richTextMsg,FW:LinkMsg,FW:NewsMsg,FW:CustomShareMsg,FW:VoIPMsg,FW:Extension_Msg,RC:PublicNoticeMsg,FW:UniteMsg,RC:ExpMsg" : "RC:TxtMsg,FW:attachmentMsg,FW:CustomShareMsg";
            }
            paramMap.put("Classname", msgType);
            if (StringUtils.isNotBlank((CharSequence)dataId)) {
                paramMap.put("dataId", dataId);
            }
            HashMap<String, String> sortMap = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)orderType) && orderType.equals("1")) {
                sortMap.put("Datetime", "true");
            } else {
                sortMap.put("Datetime", "false");
            }
            HashMap aggMap = new HashMap();
            Map weiSouMap = MegSearch.search(paramMap, sortMap, aggMap);
            List<Map<String, Object>> searchedHistory = this.convertWeiSouToClient(weiSouMap, fromUserId);
            map.put("searchedHistory", searchedHistory);
            map.put("pageNumber", weiSouMap.get("pageNumber"));
            map.put("pageSize", weiSouMap.get("pageSize"));
            map.put("totalCount", weiSouMap.get("count"));
        } else {
            HistorySearchIQDao historySearchIQDao = new HistorySearchIQDao();
            map = historySearchIQDao.searchHistoryMsg(fromUserId, fromUserId, targetId, targetType, pageNumber, pageSize, startTime, endTime, keyword, msgType, dataId, orderType, senderId, null, "pc");
        }
        result.put("searchedHistory", map.get("searchedHistory"));
        result.put("pageNumber", map.get("pageNumber"));
        result.put("pageSize", map.get("pageSize"));
        result.put("totalCount", map.get("totalCount"));
        return map;
    }

    private List<Map<String, Object>> convertWeiSouToClient(Map<String, Object> weiSouMap, String loginUserId) {
        ArrayList<Map<String, Object>> searchedHistory = new ArrayList<Map<String, Object>>();
        List listResult = (List)weiSouMap.get("result");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (null != listResult) {
            for (int i = 0; i < listResult.size(); ++i) {
                int ding_id;
                DingUtil dingUtil;
                Map mapWei = (Map)listResult.get(i);
                JSONObject mapAddIn = new JSONObject();
                mapAddIn.put("imgUrl", mapWei.get("imageUrl"));
                mapAddIn.put("msgType", (Object)this.getMsgTypeValueByName(mapWei.get("classname") == null ? "" : mapWei.get("classname").toString()));
                mapAddIn.put("targetid", mapWei.get("targetid"));
                mapAddIn.put("chatdivid", mapWei.get("targetid"));
                mapAddIn.put("extra", mapWei.get("extra"));
                String objectName = (String)mapWei.get("objectName");
                mapAddIn.put("objectName", mapWei.get("objectName"));
                mapAddIn.put("targetType", (Object)String.valueOf(Integer.parseInt((String)mapWei.get("targetType")) - 1));
                mapAddIn.put("toUserid", mapWei.get("fromUserId"));
                String msgContent = (String)mapWei.get("content");
                mapAddIn.put("content", mapWei.get("content"));
                mapAddIn.put("dataId", mapWei.get("dataId"));
                mapAddIn.put("timestamp", mapWei.get("msg_id"));
                if ("FW:CMDMsg".equals(objectName) && !(dingUtil = new DingUtil()).chechUserDing(loginUserId, ding_id = dingUtil.getDingIdByMessageContent(msgContent))) {
                    String newContent = dingUtil.getDingContent(msgContent);
                    mapAddIn.put("content", (Object)newContent);
                    mapAddIn.put("objectName", (Object)"RC:TxtMsg");
                }
                Long sendTime = null;
                if (null != mapWei.get("dateTime")) {
                    try {
                        sendTime = simpleDateFormat.parse(mapWei.get("dateTime").toString()).getTime();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                HashMap<String, Object> mapAddOut = new HashMap<String, Object>();
                mapAddOut.put("opBody", mapAddIn.toString());
                mapAddOut.put("sendTime", sendTime);
                mapAddOut.put("targetId", mapWei.get("targetid"));
                mapAddOut.put("fromUserId", mapWei.get("fromUserId"));
                searchedHistory.add(mapAddOut);
            }
        }
        return searchedHistory;
    }

    private int getMsgTypeValueByName(String name) {
        int result = 6;
        if ("RC:TxtMsg".equals(name)) {
            result = 1;
        } else if ("RC:ImgMsg".equals(name)) {
            result = 2;
        } else if ("RC:VcMsg".equals(name)) {
            result = 3;
        } else if ("RC:LBSMsg".equals(name)) {
            result = 8;
        }
        return result;
    }
}

