/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.emessage.multirouter.messagemanager;

import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.jivesoftware.database.DbConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStatisticsUtil
extends TimerTask {
    private static final Logger Log = LoggerFactory.getLogger(MessageStatisticsUtil.class);
    private static final String REDIS_LIST_KEY = "msg:statistic:queue:";
    private static final String MSG_STATISTIC = "msg:statistic:";
    private static final String MSG_STATISTICSIGN = "msg:statistic:sing:";
    private static final String MSG_STATISTICGROUP = "msg:statistic:group:";
    private static final String MSG_STATISTICSIGN_QUEUE = "msg:statistic:sing:queue:";
    private static final String Redis_Conversation_targetId_key_sign = "msg:statistic:sign:targetid:";
    private static final String Redis_Conversation_targetId_key_group = "msg:statistic:group:targetid:";
    private static final String Redis_Conversation_targetId_key_Queue = "msg:statistic:targetid:queue:";

    @Override
    public void run() {
        Log.info("MessageStatisticsUtil TimeTask start");
        try {
            String userId3;
            RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
            String lastDay = MessageStatisticsUtil.getLastDate();
            String lastDayMonth = MessageStatisticsUtil.getLastDateMonth();
            String lastDayYear = MessageStatisticsUtil.getLastDateYear();
            Set msgStatistisQueue = null;
            HashSet<String> syncUserList = new HashSet<String>();
            while ((msgStatistisQueue = redisPoolMgr.zrange(REDIS_LIST_KEY + lastDay, 0L, 9L)).size() > 0) {
                for (String hashKey : msgStatistisQueue) {
                    try {
                        Map userMap = redisPoolMgr.hgetall(hashKey);
                        int sendCount = 0;
                        if (userMap != null && userMap.containsKey("sendCount")) {
                            sendCount = Integer.parseInt((String)userMap.get("sendCount"));
                        }
                        int receiveCount = 0;
                        if (userMap != null && userMap.containsKey("receiveCount")) {
                            receiveCount = Integer.parseInt((String)userMap.get("receiveCount"));
                        }
                        userId3 = hashKey.replace(MSG_STATISTIC + lastDay + ":", "");
                        this.recordData2Db(sendCount, receiveCount, userId3, lastDay, lastDayMonth, lastDayYear);
                        syncUserList.add(userId3);
                    }
                    catch (Exception e) {
                        Log.error("MessageStatisticsUtil ,sync data error :{},hashKey:{},e :{} ", new Object[]{e.getMessage(), hashKey, e});
                    }
                }
                redisPoolMgr.batchZrem(REDIS_LIST_KEY + lastDay, msgStatistisQueue);
                redisPoolMgr.batchDel(msgStatistisQueue);
            }
            Log.info("MessageStatisticsUtil TimeTask start static chat .");
            Set syncSignList = new HashSet();
            HashSet<String> syncUserSignList = new HashSet<String>();
            while ((syncSignList = redisPoolMgr.zrange(MSG_STATISTICSIGN_QUEUE + lastDay, 0L, 9L)).size() > 0) {
                for (String zaddKey : syncSignList) {
                    try {
                        Set targetIds = redisPoolMgr.zrange(zaddKey, 0L, -1L);
                        userId3 = null;
                        int targetType = 0;
                        if (zaddKey != null && zaddKey.contains(MSG_STATISTICSIGN)) {
                            targetType = 1;
                            userId3 = zaddKey.replace(MSG_STATISTICSIGN + lastDay + ":", "");
                        } else if (zaddKey != null && zaddKey.contains(MSG_STATISTICGROUP)) {
                            targetType = 2;
                            userId3 = zaddKey.replace(MSG_STATISTICGROUP + lastDay + ":", "");
                        }
                        this.record2DbSignDay(userId3, targetType, targetIds, lastDay, lastDayMonth, lastDayYear);
                        syncUserSignList.add(userId3);
                    }
                    catch (Exception e) {
                        Log.error("MessageStatisticsUtil ,sync data error :{},zaddKey:{},e :{} ", new Object[]{e.getMessage(), zaddKey, e});
                    }
                }
                redisPoolMgr.batchZrem(MSG_STATISTICSIGN_QUEUE + lastDay, syncSignList);
                redisPoolMgr.batchDel(syncSignList);
            }
            Log.info("Redis_Conversation_targetId_key_Queue TimeTask start static chat .");
            Set syncTargetList = new HashSet();
            HashSet<String> syncTargetUserList = new HashSet<String>();
            while ((syncTargetList = redisPoolMgr.zrange(Redis_Conversation_targetId_key_Queue + lastDay, 0L, 9L)).size() > 0) {
                for (String targetIdKey : syncTargetList) {
                    Map userMap = redisPoolMgr.hgetall(targetIdKey);
                    int sendCount = 0;
                    if (userMap != null && userMap.containsKey("sendCount")) {
                        sendCount = Integer.parseInt((String)userMap.get("sendCount"));
                    }
                    int receiveCount = 0;
                    if (userMap != null && userMap.containsKey("receiveCount")) {
                        receiveCount = Integer.parseInt((String)userMap.get("receiveCount"));
                    }
                    String targetType = "1";
                    if (targetIdKey != null && targetIdKey.contains(Redis_Conversation_targetId_key_group)) {
                        targetType = "2";
                    }
                    String[] tarStr = targetIdKey.split(":");
                    String userId2 = tarStr[6];
                    String targetId = tarStr[5];
                    syncTargetUserList.add(userId2);
                    this.record2DbSignDayChat(userId2, targetId, sendCount, receiveCount, targetType, lastDay, lastDayMonth, lastDayYear);
                }
                redisPoolMgr.batchZrem(Redis_Conversation_targetId_key_Queue + lastDay, syncTargetList);
                redisPoolMgr.batchDel(syncTargetList);
            }
            Log.info("MessageStatisticsUtil TimeTask start record2Db 111  ");
            for (String userId3 : syncUserList) {
                this.record2Date2DbMonth(userId3, lastDayMonth, lastDayYear);
                this.record2Date2DbYear(userId3, lastDayYear);
            }
            Log.info("MessageStatisticsUtil TimeTask start record2Db 2222  ");
            for (String userId3 : syncUserSignList) {
                this.record2DbSignMonth(userId3, lastDayMonth, lastDayYear);
                this.record2DbSignYear(userId3, lastDayYear);
            }
        }
        catch (Exception e) {
            Log.error("MessageStatisticsUtil TimeTask error . e:{} ,msg:{} ", (Object)e.getMessage(), (Object)e);
        }
        Log.info("MessageStatisticsUtil TimeTask end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record2DbSignDayChat(String userId, String targetId, int sendCount, int receiveCount, String targetType, String day, String month, String year) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            String sql = " insert into  OFCONVERSTATISDAY (userId,targetId,targetType,day,month,year,sendCount,receiveCount) Values (?,?,?,?,?,?,?,?) ";
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, userId);
            pstmt.setString(2, targetId);
            pstmt.setString(3, targetType);
            pstmt.setString(4, day);
            pstmt.setString(5, month);
            pstmt.setString(6, year);
            pstmt.setInt(7, sendCount);
            pstmt.setInt(8, receiveCount);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("record2DbSignDayChat ,error :{} ,e :{} ,userId :{} ,targetId :{} ,sendCount:{},receiveCount :{} ,day :{} ", new Object[]{e.getMessage(), e, userId, targetId, sendCount, receiveCount, day});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record2DbSignYear(String userId, String year) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block7: {
            String sqlChatCount = " select count(DISTINCT targetId) as chatCount from OFMSGSTATISTICCHATDAY where userId = ? and year = ? and targetType = ?  ";
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(sqlChatCount);
                pstmt.setString(1, userId);
                pstmt.setString(2, year);
                pstmt.setInt(3, 1);
                rs = pstmt.executeQuery();
                int chatCount = 0;
                while (rs.next()) {
                    chatCount = rs.getInt("chatCount");
                }
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                int groupChatCount = 0;
                pstmt = con.prepareStatement(sqlChatCount);
                pstmt.setString(1, userId);
                pstmt.setString(2, year);
                pstmt.setInt(3, 2);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    groupChatCount = rs.getInt("chatCount");
                }
                String sqlSelectYear = " select * from OFMSGSTATISTICCHATYEAR where userId = ? and year = ? ";
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(sqlSelectYear);
                pstmt.setString(1, userId);
                pstmt.setString(2, year);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                    String sqlUpdateMonth = " UPDATE OFMSGSTATISTICCHATYEAR set chatCount = ?,groupChatCount= ? where userId = ? and year = ? ";
                    pstmt = con.prepareStatement(sqlUpdateMonth);
                    pstmt.setInt(1, chatCount);
                    pstmt.setInt(2, groupChatCount);
                    pstmt.setString(3, userId);
                    pstmt.setString(4, year);
                    pstmt.executeUpdate();
                    break block7;
                }
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlInsertMonth = " INSERT INTO OFMSGSTATISTICCHATYEAR (userId,year,chatCount,groupChatCount) VALUES (?,?,?,?) ";
                pstmt = con.prepareStatement(sqlInsertMonth);
                pstmt.setString(1, userId);
                pstmt.setString(2, year);
                pstmt.setInt(3, chatCount);
                pstmt.setInt(4, groupChatCount);
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    Log.error("record2DbSignYear,userId : {} ,month :{} ,error :{} ,e :{} ", new Object[]{userId, year, e.getMessage(), e});
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record2DbSignMonth(String userId, String month, String year) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block7: {
            String sqlChatCount = " select count(DISTINCT targetId) as chatCount from OFMSGSTATISTICCHATDAY where userId = ? and month = ? and targetType = ?   ";
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(sqlChatCount);
                pstmt.setString(1, userId);
                pstmt.setString(2, month);
                pstmt.setInt(3, 1);
                rs = pstmt.executeQuery();
                int chatCount = 0;
                while (rs.next()) {
                    chatCount = rs.getInt("chatCount");
                }
                int groupChatCount = 0;
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(sqlChatCount);
                pstmt.setString(1, userId);
                pstmt.setString(2, month);
                pstmt.setInt(3, 2);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    groupChatCount = rs.getInt("chatCount");
                }
                String sqlSelectmonth = " select * from OFMSGSTATISTICCHATMONTH where userId = ? and month = ? ";
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(sqlSelectmonth);
                pstmt.setString(1, userId);
                pstmt.setString(2, month);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                    String sqlUpdateMonth = " UPDATE OFMSGSTATISTICCHATMONTH set chatCount = ?,groupChatCount=? where userId = ? and month = ? ";
                    pstmt = con.prepareStatement(sqlUpdateMonth);
                    pstmt.setInt(1, chatCount);
                    pstmt.setInt(2, groupChatCount);
                    pstmt.setString(3, userId);
                    pstmt.setString(4, month);
                    pstmt.executeUpdate();
                    break block7;
                }
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlInsertMonth = " INSERT INTO OFMSGSTATISTICCHATMONTH (userId,month,year,chatCount,groupChatCount) VALUES (?,?,?,?,?) ";
                pstmt = con.prepareStatement(sqlInsertMonth);
                pstmt.setString(1, userId);
                pstmt.setString(2, month);
                pstmt.setString(3, year);
                pstmt.setInt(4, chatCount);
                pstmt.setInt(5, groupChatCount);
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    Log.error("record2DbSignMonth,userId : {} ,month :{} ,year :{} ,error :{} ,e :{} ", new Object[]{userId, month, year, e.getMessage(), e});
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void record2DbSignDay(String userId, int targetType, Set<String> targetIds, String day, String month, String year) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            String insertOFmsgstaChatDay = " INSERT INTO  OFMSGSTATISTICCHATDAY (userId,targetId,targetType,day,month,year) VALUES (?,?,?,?,?,?) ";
            pstmt = con.prepareStatement(insertOFmsgstaChatDay);
            for (String targetId : targetIds) {
                pstmt.setString(1, userId);
                pstmt.setString(2, targetId);
                pstmt.setInt(3, targetType);
                pstmt.setString(4, day);
                pstmt.setString(5, month);
                pstmt.setString(6, year);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.clearBatch();
        }
        catch (SQLException e) {
            try {
                Log.error("record2DbSignDay,userId :{} ,targetIds :{} ,day :{} ,month :{} .year :{} ,error :{} ,e :{} ", new Object[]{userId, targetIds, day, month, year, e.getMessage(), e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record2Date2DbYear(String userId, String year) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block6: {
            String sqlStatisYear = " select sum(sendCount) as yearSendCount,sum(receiveCount) as yearReceiveCount from OFMSGSTATISTICMONTH where userId = ? and year = ? ";
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(sqlStatisYear);
                pstmt.setString(1, userId);
                pstmt.setString(2, year);
                rs = pstmt.executeQuery();
                int yearSendCount = 0;
                int yearReceiveCount = 0;
                while (rs.next()) {
                    yearSendCount = rs.getInt("yearSendCount");
                    yearReceiveCount = rs.getInt("yearReceiveCount");
                }
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlSelYearData = " SELECT * FROM  OFMSGSTATISTICYEAR WHERE userId = ? and year = ? ";
                pstmt = con.prepareStatement(sqlSelYearData);
                pstmt.setString(1, userId);
                pstmt.setString(2, year);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    String sqlUpdateYearData = " UPDATE OFMSGSTATISTICYEAR set sendCount = ? , receiveCount = ? WHERE userId = ? and year = ? ";
                    pstmt = con.prepareStatement(sqlUpdateYearData);
                    pstmt.setInt(1, yearSendCount);
                    pstmt.setInt(2, yearReceiveCount);
                    pstmt.setString(3, userId);
                    pstmt.setString(4, year);
                    pstmt.executeUpdate();
                    break block6;
                }
                DbConnectionManager.closeStatement((Statement)pstmt);
                String sqlInsertYearData = "  INSERT INTO  OFMSGSTATISTICYEAR (userId,year,sendCount,receiveCount) Values (?,?,?,?)  ";
                pstmt = con.prepareStatement(sqlInsertYearData);
                pstmt.setString(1, userId);
                pstmt.setString(2, year);
                pstmt.setInt(3, yearSendCount);
                pstmt.setInt(4, yearReceiveCount);
                pstmt.executeUpdate();
            }
            catch (Exception e) {
                try {
                    Log.error("record2Date2DbYear ,userId :{} ,year :{} ,error :{} ,e :{} ", new Object[]{userId, year, e.getMessage(), e});
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record2Date2DbMonth(String userId, String month, String year) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block6: {
            String sqlStatisMonth = " select sum(sendCount) as monthSendCount,sum(receiveCount) as monthReceiveCount from OFMSGSTATISTICDAY where userId = ? and month = ? ";
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(sqlStatisMonth);
                pstmt.setString(1, userId);
                pstmt.setString(2, month);
                rs = pstmt.executeQuery();
                int monthSendCount = 0;
                int monthReceiveCount = 0;
                while (rs.next()) {
                    monthSendCount = rs.getInt("monthSendCount");
                    monthReceiveCount = rs.getInt("monthReceiveCount");
                }
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sqlSelMonthData = " select * from OFMSGSTATISTICMONTH where userId = ? and month = ? ";
                pstmt = con.prepareStatement(sqlSelMonthData);
                pstmt.setString(1, userId);
                pstmt.setString(2, month);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    String sqlUpdateMonthData = " UPDATE OFMSGSTATISTICMONTH set sendCount = ? , receiveCount = ? WHERE userId = ? and month = ? ";
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement(sqlUpdateMonthData);
                    pstmt.setInt(1, monthSendCount);
                    pstmt.setInt(2, monthReceiveCount);
                    pstmt.setString(3, userId);
                    pstmt.setString(4, month);
                    pstmt.executeUpdate();
                    break block6;
                }
                String sqlInsertMonthData = " INSERT INTO  OFMSGSTATISTICMONTH (userId,month,year,sendCount,receiveCount) Values (?,?,?,?,?) ";
                DbConnectionManager.closeStatement((Statement)pstmt);
                pstmt = con.prepareStatement(sqlInsertMonthData);
                pstmt.setString(1, userId);
                pstmt.setString(2, month);
                pstmt.setString(3, year);
                pstmt.setInt(4, monthSendCount);
                pstmt.setInt(5, monthReceiveCount);
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    Log.error("record2Date2DbMonth ,userId :{} ,month :{} ,year :{} ,error :{} ,e :{} ", new Object[]{userId, month, year, e.getMessage(), e});
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordData2Db(int sendCount, int receiveCount, String userId, String day, String month, String year) {
        String sql = " INSERT INTO  OFMSGSTATISTICDAY (userId,day,month,year,sendCount,receiveCount) VALUES (?,?,?,?,?,?) ";
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, userId);
            pstmt.setString(2, day);
            pstmt.setString(3, month);
            pstmt.setString(4, year);
            pstmt.setInt(5, sendCount);
            pstmt.setInt(6, receiveCount);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                Log.error("recordData2Db ,userId :{} ,day :{} ,month :{} ,year :{} ,error :{} ,e :{} ", new Object[]{userId, day, month, year, e.getMessage(), e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    public static void recordMsg2Redis(String fromUserId, List<String> userIds, int targetType, String targetId) {
        try {
            String keyTemp = MessageStatisticsUtil.getTodayDay();
            ArrayList<String> receiveIds = new ArrayList<String>(userIds);
            if (receiveIds != null && receiveIds.contains(fromUserId)) {
                receiveIds.remove(fromUserId);
            }
            HashSet<String> set = new HashSet<String>();
            ArrayList<String> redisKey = new ArrayList<String>();
            HashMap keys_map = new HashMap();
            String fromUserKey = MSG_STATISTIC + keyTemp + ":" + fromUserId;
            String fromSetKey = MSG_STATISTICSIGN + keyTemp + ":" + fromUserId;
            if (2 == targetType) {
                fromSetKey = MSG_STATISTICGROUP + keyTemp + ":" + fromUserId;
            }
            HashSet<String> chatStatisticsSet = new HashSet<String>();
            String signChatSendOrReceCount = Redis_Conversation_targetId_key_sign + keyTemp + ":" + targetId + ":" + fromUserId;
            if (2 == targetType) {
                signChatSendOrReceCount = Redis_Conversation_targetId_key_group + keyTemp + ":" + targetId + ":" + fromUserId;
            }
            HashMap<String, Long> fromUserSendCount = new HashMap<String, Long>();
            fromUserSendCount.put("sendCount", 1L);
            keys_map.put(signChatSendOrReceCount, fromUserSendCount);
            chatStatisticsSet.add(signChatSendOrReceCount);
            set.add(fromSetKey);
            redisKey.add(fromUserKey);
            HashMap<String, Long> fromUserMap = new HashMap<String, Long>();
            fromUserMap.put("sendCount", 1L);
            keys_map.put(fromUserKey, fromUserMap);
            for (String receiveId : receiveIds) {
                String receiveKey = MSG_STATISTIC + keyTemp + ":" + receiveId;
                String setKey = MSG_STATISTICSIGN + keyTemp + ":" + receiveId;
                if (2 == targetType) {
                    setKey = MSG_STATISTICGROUP + keyTemp + ":" + receiveId;
                }
                set.add(setKey);
                redisKey.add(receiveKey);
                HashMap<String, Long> receiveMap = new HashMap<String, Long>();
                receiveMap.put("receiveCount", 1L);
                keys_map.put(receiveKey, receiveMap);
                String signChatreceCount = Redis_Conversation_targetId_key_sign + keyTemp + ":" + targetId + ":" + receiveId;
                if (2 == targetType) {
                    signChatreceCount = Redis_Conversation_targetId_key_group + keyTemp + ":" + targetId + ":" + receiveId;
                }
                HashMap<String, Long> receiceCount = new HashMap<String, Long>();
                receiceCount.put("receiveCount", 1L);
                keys_map.put(signChatreceCount, receiceCount);
                chatStatisticsSet.add(signChatreceCount);
            }
            String redisListKey = REDIS_LIST_KEY + keyTemp;
            RedisPoolMgr.getInstance().batchzaddKey(redisListKey, System.currentTimeMillis(), redisKey, 259200);
            RedisPoolMgr.getInstance().batchHincrBy(keys_map);
            if (1 == targetType || 2 == targetType) {
                RedisPoolMgr.getInstance().batchzaddKey(set, System.currentTimeMillis(), targetId, 259200);
                RedisPoolMgr.getInstance().batchzaddKey(MSG_STATISTICSIGN_QUEUE + keyTemp, System.currentTimeMillis(), set, 259200);
                RedisPoolMgr.getInstance().batchzaddKey(Redis_Conversation_targetId_key_Queue + keyTemp, System.currentTimeMillis(), chatStatisticsSet, 259200);
            }
        }
        catch (Exception e) {
            Log.error("recordMsg2Redis ,fromUserId :{} ,userIds:{} ,error :{} ,e :{} ", new Object[]{fromUserId, userIds, e.getMessage(), e});
        }
    }

    public static void main(String[] args) {
        System.out.println(MessageStatisticsUtil.getLastDate());
        System.out.println(MessageStatisticsUtil.getLastDateYear());
        System.out.println(MessageStatisticsUtil.getLastDateMonth());
    }

    private static String getLastDate() {
        Long todayTime = System.currentTimeMillis();
        SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        return SDF_ALL_TIME_FORMAT.format(todayTime - 86400000L);
    }

    private static String getLastDateYear() {
        Long todayTime = System.currentTimeMillis();
        SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy");
        return SDF_ALL_TIME_FORMAT.format(todayTime - 86400000L);
    }

    private static String getLastDateMonth() {
        Long todayTime = System.currentTimeMillis();
        SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM");
        return SDF_ALL_TIME_FORMAT.format(todayTime - 86400000L);
    }

    private static String getTodayDay() {
        SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        return SDF_ALL_TIME_FORMAT.format(new Date());
    }
}

