/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.emessage.multirouter.messagemanager;

import com.weaver.emessage.multirouter.messagemanager.SyncBeanUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jivesoftware.database.DbConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDateForTargetIdUtil {
    private static final Logger Log = LoggerFactory.getLogger(SyncDateForTargetIdUtil.class);
    private static final String SYNC_REDIS_KEY_ID = "msg:statais:redis:key:id";
    private static final String SYNC_REDIS_KEY_DATE = "msg:statais:redis:key:day";
    private static int id = 0;

    public void syncDateUtil() {
        String today = "2022-06-01";
        String nextDay = SyncDateForTargetIdUtil.getNextDay(today);
        List<Object> list = new ArrayList();
        Log.info("SyncDateUtil start  day :{} ,nextday :{} ,id :{} ", new Object[]{today, nextDay, id});
        while (!"2022-07-01".equals(nextDay)) {
            Log.info("nextDay ==  {} ", (Object)nextDay);
            HashMap<String, Map<String, Object>> userTargetIdList = new HashMap<String, Map<String, Object>>();
            while ((list = this.getList(today, nextDay)).size() > 0) {
                for (SyncBeanUtil syncBeanUtil : list) {
                    Map<String, String> temp;
                    String msgId = syncBeanUtil.getMsgId();
                    int targetType = syncBeanUtil.getTargetType();
                    String groupId = syncBeanUtil.getGroupId();
                    String fromUserId = syncBeanUtil.getFromUserId();
                    String userKey = fromUserId + ":" + groupId;
                    if (userTargetIdList != null && userTargetIdList.containsKey(userKey)) {
                        temp = (Map)userTargetIdList.get(userKey);
                        temp.put("targetType", (String)((Object)Integer.valueOf(targetType)));
                        temp.put("userId", fromUserId);
                        temp.put("targetId", groupId);
                        int sendCount = 1;
                        if (temp.containsKey("sendCount")) {
                            sendCount = (Integer)temp.get("sendCount") + 1;
                        }
                        temp.put("sendCount", (String)((Object)Integer.valueOf(sendCount)));
                        userTargetIdList.put(userKey, temp);
                    } else {
                        temp = new HashMap<String, Integer>();
                        temp.put("targetType", (String)((Object)Integer.valueOf(targetType)));
                        temp.put("userId", fromUserId);
                        temp.put("targetId", groupId);
                        temp.put("sendCount", (String)((Object)Integer.valueOf(1)));
                        temp.put("receiveCount", (String)((Object)Integer.valueOf(0)));
                        userTargetIdList.put(userKey, temp);
                    }
                    List<String> receive = this.getUserMsgIdRight(msgId);
                    if (receive != null && receive.contains(fromUserId)) {
                        receive.remove(fromUserId);
                    }
                    for (String receiveId : receive) {
                        String key = receiveId + ":" + groupId;
                        if (userTargetIdList != null && userTargetIdList.containsKey(key)) {
                            Map temp2 = (Map)userTargetIdList.get(key);
                            temp2.put("targetType", targetType);
                            temp2.put("userId", receiveId);
                            temp2.put("targetId", groupId);
                            int receiveCount = 1;
                            if (temp2.containsKey("receiveCount")) {
                                receiveCount = (Integer)temp2.get("receiveCount") + 1;
                            }
                            temp2.put("receiveCount", receiveCount);
                            userTargetIdList.put(key, temp2);
                            continue;
                        }
                        HashMap<String, Object> temp2 = new HashMap<String, Object>();
                        temp2.put("targetType", targetType);
                        temp2.put("userId", receiveId);
                        temp2.put("targetId", groupId);
                        temp2.put("sendCount", 0);
                        temp2.put("receiveCount", 1);
                        userTargetIdList.put(key, temp2);
                    }
                }
            }
            this.recordDb(userTargetIdList, today);
            today = nextDay;
            nextDay = SyncDateForTargetIdUtil.getNextDay(today);
            Log.info("SyncDateUtil .:{} ,nextday :{} ,id :{}  ", new Object[]{today, nextDay, id});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordDb(Map<String, Map<String, Object>> map, String day) {
        String year = SyncDateForTargetIdUtil.getYear(day);
        String month = SyncDateForTargetIdUtil.getMonth(day);
        String sql = " insert into  OFCONVERSTATISDAY (userId,targetId,targetType,day,month,year,sendCount,receiveCount) Values (?,?,?,?,?,?,?,?) ";
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            int i = 0;
            for (String mapkey : map.keySet()) {
                Map<String, Object> temp = map.get(mapkey);
                String userId = (String)temp.get("userId");
                int targetType = (Integer)temp.get("targetType");
                String targetId = (String)temp.get("targetId");
                int sendCount = 0;
                if (temp.containsKey("sendCount")) {
                    sendCount = (Integer)temp.get("sendCount");
                }
                int receiveCount = 0;
                if (temp.containsKey("receiveCount")) {
                    receiveCount = (Integer)temp.get("receiveCount");
                }
                pstmt.setString(1, userId);
                pstmt.setString(2, targetId);
                pstmt.setInt(3, targetType);
                pstmt.setString(4, day);
                pstmt.setString(5, month);
                pstmt.setString(6, year);
                pstmt.setInt(7, sendCount);
                pstmt.setInt(8, receiveCount);
                pstmt.addBatch();
                if (++i != 100) continue;
                pstmt.executeBatch();
                pstmt.clearBatch();
                i = 0;
            }
            if (i != 0) {
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
        }
        catch (SQLException e) {
            Log.error(" insert into  OFCONVERSTATISDAY  error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SyncBeanUtil> getList(String today, String nextDay) {
        String sql = " select top(1000) id,fromUserId,targetId,targetType,GroupId,msgId from historyMsg where datetime >= ? and dateTime <= ? AND targetType in(1,2) AND id > ? order by id ";
        ArrayList<SyncBeanUtil> result = new ArrayList<SyncBeanUtil>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, today);
            pstmt.setString(2, nextDay);
            pstmt.setInt(3, id);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                SyncBeanUtil s = new SyncBeanUtil();
                s.setFromUserId(rs.getString("fromUserId"));
                s.setGroupId(rs.getString("GroupId"));
                s.setMsgId(rs.getString("msgId"));
                s.setTargetType(rs.getInt("targetType"));
                id = rs.getInt("id");
                result.add(s);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("SyncDateUtil getList ,error :{} ,toDay :{} ,nextDay :{} ,e :{} ", new Object[]{e.getMessage(), today, nextDay, e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUserMsgIdRight(String msgId) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> userRight = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select userId from Social_historyMsgRight where msgId = ? ");
            pstmt.setString(1, msgId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                set.add(rs.getString("userId"));
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getUserMsgIdRight,msgId:{},error:{}", (Object)msgId, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        userRight.addAll(set);
        return userRight;
    }

    public static void main(String[] args) {
        System.out.println(SyncDateForTargetIdUtil.getNextDay("2020-02-29"));
    }

    private static String getMonth(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDate = new Date();
        try {
            nowDate = sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat year = new SimpleDateFormat("yyyy-MM");
        return year.format(nowDate);
    }

    private static String getYear(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDate = new Date();
        try {
            nowDate = sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat year = new SimpleDateFormat("yyyy");
        return year.format(nowDate);
    }

    private static String getNextDay(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDate = new Date();
        try {
            nowDate = sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Long nextDate = nowDate.getTime() + 86400000L;
        return sdf.format(nextDate);
    }
}

