/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.emessage.multirouter.messagemanager;

import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.emessage.multirouter.messagemanager.MessageStatisticsUtil;
import com.weaver.emessage.multirouter.messagemanager.SyncBeanUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDateUtil {
    private static final Logger Log = LoggerFactory.getLogger(SyncDateUtil.class);
    private static final String SYNC_REDIS_KEY_ID = "msg:statais:redis:key:id";
    private static final String SYNC_REDIS_KEY_DATE = "msg:statais:redis:key:day";
    private static int id = 0;

    public void syncDateUtil() {
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        String today = "2020-12-31";
        String nextDay = SyncDateUtil.getNextDay(today);
        List<Object> list = new ArrayList();
        Log.info("SyncDateUtil start  day :{} ,nextday :{} ,id :{} ", new Object[]{today, nextDay, id});
        while (!"2021-01-13".equals(nextDay)) {
            HashSet<String> userList = new HashSet<String>();
            HashMap<String, Integer> userSend = new HashMap<String, Integer>();
            HashMap<String, Integer> userReceive = new HashMap<String, Integer>();
            HashMap<String, Set<String>> userConverSign = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> userConverGroup = new HashMap<String, Set<String>>();
            while ((list = this.getList(today, nextDay)).size() > 0) {
                for (SyncBeanUtil syncBeanUtil : list) {
                    String msgId = syncBeanUtil.getMsgId();
                    int targetType = syncBeanUtil.getTargetType();
                    String groupId = syncBeanUtil.getGroupId();
                    String fromUserId = syncBeanUtil.getFromUserId();
                    if (userSend != null && userSend.containsKey(fromUserId)) {
                        int oldCount = (Integer)userSend.get(fromUserId);
                        userSend.put(fromUserId, oldCount + 1);
                    } else {
                        userSend.put(fromUserId, 1);
                    }
                    if (1 == targetType) {
                        if (userConverSign != null && userConverSign.containsKey(fromUserId)) {
                            Set set = (Set)userConverSign.get(fromUserId);
                            set.add(groupId);
                            userConverSign.put(fromUserId, set);
                        } else {
                            HashSet<String> set = new HashSet<String>();
                            set.add(groupId);
                            userConverSign.put(fromUserId, set);
                        }
                    } else if (2 == targetType) {
                        if (userConverGroup != null && userConverGroup.containsKey(fromUserId)) {
                            Set set = (Set)userConverGroup.get(fromUserId);
                            set.add(groupId);
                            userConverGroup.put(fromUserId, set);
                        } else {
                            HashSet<String> set = new HashSet<String>();
                            set.add(groupId);
                            userConverGroup.put(fromUserId, set);
                        }
                    }
                    List<String> receive = this.getUserMsgIdRight(msgId);
                    if (receive != null && receive.contains(fromUserId)) {
                        receive.remove(fromUserId);
                    }
                    for (String receiveId : receive) {
                        if (userReceive != null && userReceive.containsKey(receiveId)) {
                            int oldCount = (Integer)userReceive.get(receiveId);
                            userReceive.put(receiveId, oldCount + 1);
                            continue;
                        }
                        userReceive.put(receiveId, 1);
                    }
                    for (String receiveId : receive) {
                        Set<String> set;
                        if (1 == targetType) {
                            if (userConverSign != null && userConverSign.containsKey(receiveId)) {
                                set = (Set)userConverSign.get(receiveId);
                                set.add(groupId);
                                userConverSign.put(receiveId, set);
                                continue;
                            }
                            set = new HashSet<String>();
                            set.add(groupId);
                            userConverSign.put(receiveId, set);
                            continue;
                        }
                        if (2 != targetType) continue;
                        if (userConverGroup != null && userConverGroup.containsKey(receiveId)) {
                            set = (Set)userConverGroup.get(receiveId);
                            set.add(groupId);
                            userConverGroup.put(receiveId, set);
                            continue;
                        }
                        set = new HashSet();
                        set.add(groupId);
                        userConverGroup.put(receiveId, set);
                    }
                    userList.addAll(receive);
                    userList.add(fromUserId);
                }
            }
            this.recordDb(today, userList, userSend, userReceive, userConverSign, userConverGroup);
            today = nextDay;
            nextDay = SyncDateUtil.getNextDay(today);
            Log.info("SyncDateUtil .:{} ,nextday :{} ,id :{}  ", new Object[]{today, nextDay, id});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordDb(String day, Set<String> userList, Map<String, Integer> userSend, Map<String, Integer> userReceive, Map<String, Set<String>> userConverSign, Map<String, Set<String>> userConverGroup) {
        String year = SyncDateUtil.getYear(day);
        String month = SyncDateUtil.getMonth(day);
        String sql = " INSERT INTO  OFMSGSTATISTICDAY (userId,day,month,year,sendCount,receiveCount) VALUES (?,?,?,?,?,?)  ";
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            int i = 0;
            for (String string : userList) {
                ++i;
                pstmt.setString(1, string);
                pstmt.setString(2, day);
                pstmt.setString(3, month);
                pstmt.setString(4, year);
                int userSendCount = 0;
                if (userSend != null && userSend.containsKey(string)) {
                    userSendCount = userSend.get(string);
                }
                pstmt.setInt(5, userSendCount);
                int userReceiveCount = 0;
                if (userReceive != null && userReceive.containsKey(string)) {
                    userReceiveCount = userReceive.get(string);
                }
                pstmt.setInt(6, userReceiveCount);
                pstmt.addBatch();
                if (i % 100 != 0) continue;
                pstmt.executeBatch();
                pstmt.clearBatch();
                i = 0;
            }
            if (i != 0) {
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            String sqlChat = "  INSERT INTO  OFMSGSTATISTICCHATDAY (userId,targetId,targetType,day,month,year) VALUES (?,?,?,?,?,?)  ";
            DbConnectionManager.closeStatement((Statement)pstmt);
            for (String userId : userList) {
                Set<String> groupChat;
                Set<String> signChat = userConverSign.get(userId);
                pstmt = con.prepareStatement(sqlChat);
                int j = 0;
                if (signChat != null && signChat.size() > 0) {
                    for (String targetId : signChat) {
                        ++j;
                        pstmt.setString(1, userId);
                        pstmt.setString(2, targetId);
                        pstmt.setInt(3, 1);
                        pstmt.setString(4, day);
                        pstmt.setString(5, month);
                        pstmt.setString(6, year);
                        pstmt.addBatch();
                        if (j != 100) continue;
                        pstmt.executeBatch();
                        pstmt.clearBatch();
                        j = 0;
                    }
                }
                if ((groupChat = userConverGroup.get(userId)) != null && groupChat.size() > 0) {
                    for (String targetId : groupChat) {
                        ++j;
                        pstmt.setString(1, userId);
                        pstmt.setString(2, targetId);
                        pstmt.setInt(3, 2);
                        pstmt.setString(4, day);
                        pstmt.setString(5, month);
                        pstmt.setString(6, year);
                        pstmt.addBatch();
                        if (j != 100) continue;
                        pstmt.executeBatch();
                        pstmt.clearBatch();
                        j = 0;
                    }
                }
                Log.info(" groupChat :{} ,j :{} ");
                if (j == 0) continue;
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            MessageStatisticsUtil messageStatisticsUtil = new MessageStatisticsUtil();
            for (String userId : userList) {
                messageStatisticsUtil.record2Date2DbMonth(userId, month, year);
                messageStatisticsUtil.record2Date2DbYear(userId, year);
            }
            for (String userId : userList) {
                messageStatisticsUtil.record2DbSignMonth(userId, month, year);
                messageStatisticsUtil.record2DbSignYear(userId, year);
            }
        }
        catch (SQLException e) {
            Log.error("SyncDateUtil recordDb error :{}, day :{},userList :{} ,userSend :{} ,userReceive :{} ,userConverSign :{} ,userConverGroup :{} ,e :{} ", new Object[]{e.getMessage(), day, userList, userSend, userReceive, userConverSign, userConverGroup, e});
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SyncBeanUtil> getList(String today, String nextDay) {
        String sql = " select top(1000) id,fromUserId,targetId,targetType,GroupId,msgId from historyMsg where datetime > ? and dateTime < ? AND targetType in(1,2) AND id > ? order by id ";
        ArrayList<SyncBeanUtil> result = new ArrayList<SyncBeanUtil>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, today);
            pstmt.setString(2, nextDay);
            pstmt.setInt(3, id);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                SyncBeanUtil s = new SyncBeanUtil();
                s.setFromUserId(rs.getString("fromUserId"));
                s.setGroupId(rs.getString("GroupId"));
                s.setMsgId(rs.getString("msgId"));
                s.setTargetType(rs.getInt("targetType"));
                id = rs.getInt("id");
                result.add(s);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("SyncDateUtil getList ,error :{} ,toDay :{} ,nextDay :{} ,e :{} ", new Object[]{e.getMessage(), today, nextDay, e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUserMsgIdRight(String msgId) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> userRight = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select userId from Social_historyMsgRight where msgId = ? ");
            pstmt.setString(1, msgId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                set.add(rs.getString("userId"));
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getUserMsgIdRight,msgId:{},error:{}", (Object)msgId, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        userRight.addAll(set);
        return userRight;
    }

    public static void main(String[] args) {
        System.out.println(SyncDateUtil.getNextDay("2020-02-29"));
    }

    private static String getMonth(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDate = new Date();
        try {
            nowDate = sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat year = new SimpleDateFormat("yyyy-MM");
        return year.format(nowDate);
    }

    private static String getYear(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDate = new Date();
        try {
            nowDate = sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SimpleDateFormat year = new SimpleDateFormat("yyyy");
        return year.format(nowDate);
    }

    private static String getNextDay(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDate = new Date();
        try {
            nowDate = sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Long nextDate = nowDate.getTime() + 86400000L;
        return sdf.format(nextDate);
    }
}

