/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.emessage.multirouter.sharemessage;

import com.weaver.util.ServerInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShareMessageUtil {
    private static final Logger Log = LoggerFactory.getLogger(ShareMessageUtil.class);
    private static final String INSERT_OFSHAREMESSAGE = " insert into ofshareMessageNew (userId,shareUserId,msgId,groupId,shareType,shareId,shareTime,targetId,targetType,shareTimes) values (?,?,?,?,?,?,?,?,?,?) ";
    private static final String DELETE_OFSHAREMESSAGE = " delete from ofshareMessageNew where msgId = ? ";
    private static final String DELETE_OFSHAREMESSAGE_USER = "  delete from ofshareMessageNew where msgId = ? and userId = ? ";
    private static final String DELETE_OFSHAREMESSAGE_GROUPID = "  delete from ofshareMessageNew where userId = ? and groupId = ? and targetType = ? ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getOfShareMessage(String userId, String shareType, String shareId, String targetType, int pageSize, int pageNum) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String[] sqls = this.getSqlBySelectShareMessage2(userId, shareType, shareId, targetType);
        String sqlCount = sqls[0];
        String sql = sqls[1];
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sqlCount);
            pstmt.setString(1, userId + "|" + ServerInfo.SYSTEM_UDID);
            int i = 1;
            if (shareType != null && !shareType.isEmpty()) {
                pstmt.setString(++i, shareType);
            }
            if (shareId != null && !shareId.isEmpty()) {
                pstmt.setString(++i, shareId);
            }
            if (targetType != null && !targetType.isEmpty()) {
                pstmt.setString(++i, targetType);
            }
            Log.info("sqlCount ==== :{}", (Object)sqlCount);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int totalCount = rs.getInt("totalCount");
                result.put("totalCount", totalCount);
            }
            result.put("pageSize", pageSize);
            result.put("pageNum", pageNum);
            DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
            String sqlByPage = "";
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = "SELECT * FROM (" + sql + ") AS pageTable WHERE rn BETWEEN " + ((pageNum - 1) * pageSize + 1) + " AND " + pageNum * pageSize;
            } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNum - 1) * pageSize + 1) + " AND " + pageNum * pageSize;
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + (pageNum - 1) * pageSize + "," + pageSize;
            } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNum - 1) * pageSize;
            }
            pstmt = con.prepareStatement(sqlByPage);
            Log.info("sqlByPage ==== :{}", (Object)sqlByPage);
            pstmt.setString(1, userId + "|" + ServerInfo.SYSTEM_UDID);
            int j = 1;
            if (shareType != null && !shareType.isEmpty()) {
                pstmt.setString(++j, shareType);
            }
            if (shareId != null && !shareId.isEmpty()) {
                pstmt.setString(++j, shareId);
            }
            if (targetType != null && !targetType.isEmpty()) {
                pstmt.setString(++j, targetType);
            }
            rs = pstmt.executeQuery();
            ArrayList conversations = new ArrayList();
            while (rs.next()) {
                HashMap<String, String> conversationMap = new HashMap<String, String>();
                String shareUserId = rs.getString("shareUserId");
                String msgId = rs.getString("msgId");
                String groupId = rs.getString("groupId");
                String shareTime = rs.getString("shareTime");
                String targetId = rs.getString("targetId");
                String conType = rs.getString("targetType");
                conversationMap.put("groupUserCount", rs.getString("groupUserCount"));
                conversationMap.put("groupName", rs.getString("description"));
                conversationMap.put("groupIconUrl", rs.getString("groupIconUrl"));
                conversationMap.put("groupId", groupId);
                conversationMap.put("shareUserId", shareUserId);
                conversationMap.put("msgId", msgId);
                conversationMap.put("shareType", shareType);
                conversationMap.put("shareTime", shareTime);
                conversations.add(conversationMap);
            }
            result.put("conversations", conversations);
        }
        catch (SQLException e) {
            try {
                Log.error("ShareMessageUtil,getOfShareMessage, userId :{} ,shareType :{} ,shareId :{} ,targetType :{} error :{} ,e :{}", new Object[]{userId, shareType, shareId, targetType, e.getMessage(), e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    private Map<String, String> getGroupProp(String groupId) {
        HashMap<String, String> g = new HashMap<String, String>();
        try {
            Group group = GroupManager.getInstance().getGroup(groupId);
            Collection jids = group.getAll();
            g.put("groupUserCount", String.valueOf(jids.size()));
            g.put("groupName", group.getDescription());
            g.put("groupId", group.getName());
            PersistableMap groupProp = group.getProperties();
            String groupIconUrl = "";
            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
            }
            g.put("groupIconUrl", groupIconUrl);
        }
        catch (Exception e) {
            Log.error("getGroupProp .error :{} ,groupId :{} ,e :{} ", new Object[]{e.getMessage(), groupId, e});
        }
        return g;
    }

    private String[] getSqlBySelectShareMessage2(String userId, String shareType, String shareId, String targetType) {
        String sqlBack = " a.shareUserId,a.msgId,a.groupId,a.shareType,a.shareId, a.shareTime,a.targetId,a.targetType,b.description,b.groupIconUrl, (select count(1) as userCount from ofGroupUser where ofGroupUser.groupName = a.targetid and (ofgroupUser.isdel is null or ofgroupuser.isdel <> '1')) as groupUserCount ";
        String sqlFrom = " ofshareMessageNew a left join ofgroup b on a.targetId = b.groupName left join ofgroupuser c on a.targetId = c.groupName ";
        String sqlWhere = " c.username = ? ";
        if (shareType != null && !shareType.isEmpty()) {
            sqlWhere = sqlWhere + " and a.shareType = ? ";
        }
        if (shareId != null && !shareId.isEmpty()) {
            sqlWhere = sqlWhere + " and a.shareId = ? ";
        }
        if (targetType != null && !targetType.isEmpty()) {
            sqlWhere = sqlWhere + " and a.targetType = ? ";
        }
        String sqlOrderBy = " order by shareTime desc ";
        String sqlCount = " select count(1) as totalCount from " + sqlFrom + " where" + sqlWhere;
        String sql = "";
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = "select ROW_NUMBER() OVER(ORDER BY shareTime DESC) AS rn," + sqlBack + " from" + sqlFrom + " where" + sqlWhere;
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.dm.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.st.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sql = "select " + sqlBack + " from" + sqlFrom + " where" + sqlWhere + sqlOrderBy;
        }
        return new String[]{sqlCount, sql};
    }

    private String[] getSqlBySelectShareMessage(String userId, String shareType, String shareId, String targetType) {
        String sqlback = " shareUserId,msgId,groupId,shareType,shareId,shareTime,targetId,targetType ";
        String sqlFrom = " ofshareMessageNew ";
        String sqlWhere = " userId = ? ";
        if (shareType != null && !shareType.isEmpty()) {
            sqlWhere = sqlWhere + " and shareType = ? ";
        }
        if (shareId != null && !shareId.isEmpty()) {
            sqlWhere = sqlWhere + " and shareId = ? ";
        }
        if (targetType != null && !targetType.isEmpty()) {
            sqlWhere = sqlWhere + " and targetType = ? ";
        }
        String sqlOrderBy = " order by shareTime desc ";
        String sqlCount = " select count(1) as totalCount from ofshareMessageNew where " + sqlWhere;
        String sql = "";
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = "select ROW_NUMBER() OVER(ORDER BY shareTime DESC) AS rn," + sqlback + " from" + sqlFrom + " where" + sqlWhere;
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.dm.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.st.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sql = "select " + sqlback + " from" + sqlFrom + " where" + sqlWhere + sqlOrderBy;
        }
        return new String[]{sqlCount, sql};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOfShareMessage(String userId, String groupId, String targetType) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_OFSHAREMESSAGE_GROUPID);
            pstmt.setString(1, userId);
            pstmt.setString(2, groupId);
            pstmt.setString(3, targetType);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("ShareMessageUtil,deleteOfShareMessage,error :{} , e:{} ,groupId :{} ,userId :{} ,targetType:{} ", new Object[]{e.getMessage(), e, groupId, userId, targetType});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOfShareMessage(String userId, String msgId) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_OFSHAREMESSAGE_USER);
            pstmt.setString(1, msgId);
            pstmt.setString(2, userId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("ShareMessageUtil,deleteOfShareMessage,error :{} , e:{} ,msgId :{} ,userId :{}  ", new Object[]{e.getMessage(), e, msgId, userId});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOfShareMessage(String msgId) {
        DatabaseUtil db = new DatabaseUtil();
        Map<String, String> map = db.getMsgMapById(msgId);
        if (map == null || map.isEmpty()) {
            return;
        }
        String groupId = map.get("groupId");
        String targetType = map.get("targetType");
        String shareType = map.get("shareType");
        String shareId = map.get("shareId");
        if (groupId == null || groupId.isEmpty() || targetType == null || targetType.isEmpty() || shareId == null || shareId.isEmpty() || shareType == null || shareType.isEmpty()) {
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select shareTimes from ofshareMessageNew where groupId = ? and targetType = ? and shareType = ? and shareId = ? ");
            pstmt.setString(1, groupId);
            pstmt.setString(2, targetType);
            pstmt.setString(3, shareType);
            pstmt.setString(4, shareId);
            rs = pstmt.executeQuery();
            int shareTimes = 0;
            while (rs.next()) {
                shareTimes = rs.getInt("shareTimes");
            }
            DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
            String sql = "";
            if (shareTimes > 1) {
                sql = " update ofshareMessageNew set shareTimes = " + --shareTimes + " where groupId = ? and targetType = ? and shareType = ? and shareId = ? ";
            } else if (shareTimes == 1) {
                sql = " delete from ofshareMessageNew where groupId = ? and targetType = ? and shareType = ? and shareId = ? ";
            }
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, groupId);
            pstmt.setString(2, targetType);
            pstmt.setString(3, shareType);
            pstmt.setString(4, shareId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("ShareMessageUtil,deleteOfShareMessage,error :{} , e:{} ,msgId :{} ", new Object[]{e.getMessage(), e, msgId});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveShareMessage(Set<String> userIds, String shareUserId, String msgId, String groupId, String shareType, String shareId, String targetId, String targetType) {
        PreparedStatement pstmt;
        Connection con;
        block6: {
            con = null;
            pstmt = null;
            ResultSet rs = null;
            int shareTimes = 0;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(" select shareTimes from ofshareMessageNew where groupId = ? and targetType = ? and shareType = ? and shareId = ? ");
                pstmt.setString(1, groupId);
                pstmt.setString(2, targetType);
                pstmt.setString(3, shareType);
                pstmt.setString(4, shareId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    shareTimes = rs.getInt("shareTimes");
                }
                if (shareTimes == 0) {
                    ++shareTimes;
                    DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                    pstmt = con.prepareStatement(INSERT_OFSHAREMESSAGE);
                    String shareTime = String.valueOf(System.currentTimeMillis());
                    pstmt.setString(1, shareUserId);
                    pstmt.setString(2, shareUserId);
                    pstmt.setString(3, msgId);
                    pstmt.setString(4, groupId);
                    pstmt.setString(5, shareType);
                    pstmt.setString(6, shareId);
                    pstmt.setString(7, shareTime);
                    pstmt.setString(8, targetId);
                    pstmt.setString(9, targetType);
                    pstmt.setString(10, String.valueOf(shareTimes));
                    pstmt.executeUpdate();
                    break block6;
                }
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(" update ofshareMessageNew set shareTimes = ?  where groupId = ? and targetType = ? and shareType = ? and shareId = ? ");
                pstmt.setString(1, String.valueOf(++shareTimes));
                pstmt.setString(2, groupId);
                pstmt.setString(3, targetType);
                pstmt.setString(4, shareType);
                pstmt.setString(5, shareId);
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    Log.error("ShareMessageUtil ,saveShareMessage ,error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }
}

