/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.group.util;

import com.alibaba.fastjson.JSONArray;
import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class GetGroupUtil {
    private static final Logger Log = LoggerFactory.getLogger(GetGroupUtil.class);
    private static final String GROUP_USER_TAG_KEY = "group:user:tag:";
    private static final String GET_USER_GROUP_TAG = " select groupName,username,tagValue from ofgrouptag where groupName = ? and username = ? order by updateTime desc";
    private static final int GROUP_USER_TAG_KEY_EXPIRE = 2592000;

    public Map<String, Object> getGroupById(String node, String groupId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Group group = null;
        try {
            group = GroupManager.getInstance().getGroup(groupId);
        }
        catch (GroupNotFoundException e) {
            Log.error("getGroupById ,group not found ,node :{} ,groupId :{} ", (Object)node, (Object)groupId);
            return result;
        }
        try {
            result.put("groupId", groupId);
            result.put("groupName", group.getDescription());
            Collection members = group.getMembers();
            ArrayList<String> mems = new ArrayList<String>();
            for (Object jid : members) {
                mems.add(jid.getNode());
            }
            HashSet<String> adminis = new HashSet<String>();
            for (JID jid : group.getAdmins()) {
                mems.add(jid.getNode());
                adminis.add(jid.getNode());
            }
            this.getGroupProp(groupId, result, mems, adminis);
            String groupType = (String)result.get("groupType");
            result.put("members", mems);
            result.put("admins", adminis);
            Set<String> groupTagValues = this.getGroupUserTag(groupId, node);
            result.put("groupTagValues", groupTagValues);
            String xmppDomain = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
            Log.info("getGroupById,node ---333:{} ,groupId :{} ", (Object)node, (Object)groupId);
            if (result.containsKey("deleteGroup") && "true".equals((String)result.get("deleteGroup"))) {
                for (String mem : mems) {
                    group.getMembers().remove(new JID(mem, xmppDomain, null));
                }
                for (String admin : adminis) {
                    group.getAdmins().remove(new JID(admin, xmppDomain, null));
                }
                mems = new ArrayList();
                adminis = new HashSet();
            }
            if ("0".equals(groupType) && !result.containsKey("deleteGroup") && adminis != null && adminis.size() > 1) {
                Log.info("group has more group admin.groupId:{},adminis:{}", (Object)groupId, adminis);
                for (String admin : adminis) {
                    group.getAdmins().remove(new JID(admin, xmppDomain, null, true));
                    group.getMembers().add(new JID(admin, xmppDomain, null, true));
                }
            }
            if ("0".equals(groupType) && !result.containsKey("deleteGroup") && adminis != null && adminis.size() == 0) {
                Log.info("group not has group admin,groupId :{} ", (Object)groupId);
                Iterator iterator = mems.iterator();
                if (iterator.hasNext()) {
                    String member = (String)iterator.next();
                    group.getMembers().remove(new JID(member, xmppDomain, null, true));
                    group.getAdmins().add(new JID(member, xmppDomain, null, true));
                    mems.remove(member);
                    adminis.add(member);
                }
            }
        }
        catch (Exception e) {
            Log.error("getGroupById,node :{} ,groupId:{},error:{},e:{}", new Object[]{node, groupId, e.getMessage(), e});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getGroupUserTag(String groupName, String username) {
        Set userGroupTag = null;
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            userGroupTag = redisPoolMgr.zrange(GROUP_USER_TAG_KEY + groupName + username, 0L, -1L);
        }
        if (userGroupTag != null && userGroupTag.size() > 0) {
            if (userGroupTag.contains(GROUP_USER_TAG_KEY + groupName + username)) {
                userGroupTag.remove(GROUP_USER_TAG_KEY + groupName + username);
            }
            return userGroupTag;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GET_USER_GROUP_TAG);
            pstmt.setString(1, groupName);
            pstmt.setString(2, username);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                userGroupTag.add(rs.getString("tagValue"));
            }
        }
        catch (Exception e) {
            try {
                Log.error("getGroupUserTag,error:{},groupName:{},username:{}", new Object[]{e.getMessage(), groupName, username});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        long timeStr = System.currentTimeMillis();
        if (redisPoolMgr != null) {
            if (userGroupTag != null && userGroupTag.size() > 0) {
                for (String tagValue : userGroupTag) {
                    redisPoolMgr.zadd(GROUP_USER_TAG_KEY + groupName + username, timeStr, tagValue, 2592000);
                }
            } else {
                redisPoolMgr.zadd(GROUP_USER_TAG_KEY + groupName + username, timeStr, GROUP_USER_TAG_KEY + groupName + username, 2592000);
            }
        }
        return userGroupTag;
    }

    private void getGroupProp(String groupId, Map<String, Object> result, List<String> mems, Set<String> admins) {
        Group group = null;
        try {
            group = GroupManager.getInstance().getGroup(groupId);
            PersistableMap groupPropMap = group.getProperties();
            if (groupPropMap != null && groupPropMap.containsKey((Object)"groupIconUrl")) {
                String imageUrl = (String)groupPropMap.get((Object)"groupIconUrl");
                result.put("groupIconUrl", imageUrl);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"isDisableMsgRead")) {
                String isDisableMsgRead = (String)groupPropMap.get((Object)"isDisableMsgRead");
                if (!"true".equals(isDisableMsgRead)) {
                    isDisableMsgRead = "false";
                }
                result.put("isDisableMsgRead", isDisableMsgRead);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"isDisableWords")) {
                String isDisableWords = (String)groupPropMap.get((Object)"isDisableWords");
                if (!"true".equals(isDisableWords)) {
                    isDisableWords = "false";
                }
                result.put("isDisableWords", isDisableWords);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"isDisableAddUser")) {
                String isDisableAddUser = (String)groupPropMap.get((Object)"isDisableAddUser");
                result.put("isDisableAddUser", isDisableAddUser);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"createUser")) {
                String createUser = (String)groupPropMap.get((Object)"createUser");
                result.put("createUser", createUser);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"groupManagers")) {
                String groupManagers = (String)groupPropMap.get((Object)"groupManagers");
                if (groupManagers != null && !groupManagers.isEmpty()) {
                    JSONArray groupManager = JSONArray.parseArray((String)groupManagers);
                    for (int i = 0; i < groupManager.size(); ++i) {
                        String s = groupManager.getString(i).toLowerCase();
                        if (mems.contains(s) && !admins.contains(s)) continue;
                        groupManager.remove((Object)s);
                    }
                    if (groupManager != null) {
                        groupPropMap.put((Object)"groupManagers", (Object)groupManager.toString());
                        result.put("groupManagers", groupManager.toString());
                    }
                } else {
                    result.put("groupManagers", groupManagers);
                }
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"deleteGroup")) {
                String deleteGroup = (String)groupPropMap.get((Object)"deleteGroup");
                result.put("deleteGroup", deleteGroup);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"createtime")) {
                String createtime = (String)groupPropMap.get((Object)"createtime");
                result.put("createtime", createtime);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"groupIconType")) {
                String groupIconType = (String)groupPropMap.get((Object)"groupIconType");
                result.put("groupIconType", groupIconType);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"groupIconUserIds")) {
                String groupIconUserIds = (String)groupPropMap.get((Object)"groupIconUserIds");
                result.put("groupIconUserIds", groupIconUserIds);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"seeHistoryMsg")) {
                String seeHistoryMsg = (String)groupPropMap.get((Object)"seeHistoryMsg");
                result.put("seeHistoryMsg", seeHistoryMsg);
            }
            String isDRCodeAddGroupUser = "true";
            if (groupPropMap != null && groupPropMap.containsKey((Object)"isDRCodeAddGroupUser")) {
                isDRCodeAddGroupUser = (String)groupPropMap.get((Object)"isDRCodeAddGroupUser");
            }
            result.put("isDRCodeAddGroupUser", isDRCodeAddGroupUser);
            String isCommonMembersAddGroupUser = "true";
            if (groupPropMap != null && groupPropMap.containsKey((Object)"isCommonMembersAddGroupUser")) {
                isCommonMembersAddGroupUser = (String)groupPropMap.get((Object)"isCommonMembersAddGroupUser");
            }
            result.put("isCommonMembersAddGroupUser", isCommonMembersAddGroupUser);
            String groupType = "0";
            if (groupPropMap != null && groupPropMap.containsKey((Object)"groupType")) {
                groupType = (String)groupPropMap.get((Object)"groupType");
            }
            result.put("groupType", groupType);
            String maxGroupMember = "-1";
            if (groupPropMap != null && groupPropMap.containsKey((Object)"maxGroupMember")) {
                maxGroupMember = (String)groupPropMap.get((Object)"maxGroupMember");
            }
            result.put("maxGroupMember", maxGroupMember);
            String secretGroupType = "0";
            if (groupPropMap != null && groupPropMap.containsKey((Object)"secretGroupType")) {
                secretGroupType = (String)groupPropMap.get((Object)"secretGroupType");
            }
            result.put("secretGroupType", secretGroupType);
        }
        catch (GroupNotFoundException e) {
            Log.error("getGroupIcon error.group is not found.groupId:{},e:{}", (Object)groupId, (Object)e.getMessage());
        }
    }
}

