/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.multirouter.messagesync;

import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import org.dom4j.Element;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.bean.PushDevice;
import org.jivesoftware.openfire.plugin.push.PushDbUtil;
import org.jivesoftware.openfire.plugin.util.PushUtil;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessMessageStore {
    private static final Logger Log = LoggerFactory.getLogger(ProcessMessageStore.class);
    private static final UserManager userManager = UserManager.getInstance();
    private static final GroupManager groupManager = GroupManager.getInstance();

    public static void processMessageStore(Message message) {
        if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
            ProcessMessageStore.processMessageStore4Pad(message);
        } else {
            ProcessMessageStore.processMessageStore4Mobile(message);
        }
    }

    private static void processMessageStore4Pad(Message message) {
        Element delaytest;
        Log.debug("offline message, from:{}, to:{}, msgid:{}", new Object[]{message.getFrom().getNode(), message.getTo().getNode(), message.getID()});
        boolean needPush = true;
        boolean mobileOnline = false;
        boolean padOnline = false;
        boolean pcOnline = false;
        ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
        if (clusterPropBeanUtil.isUseCluster()) {
            ClusterRedisUtil clusterRedisUtil = ClusterRedisUtil.getInstance();
            JID mobileJID = new JID(message.getTo().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
            String mobileClusterNode = clusterRedisUtil.getUserResourceNode(mobileJID);
            JID padJID = new JID(message.getTo().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pad", true);
            String padClusterNode = clusterRedisUtil.getUserResourceNode(padJID);
            JID pcJID = new JID(message.getTo().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
            String pcClusterNode = clusterRedisUtil.getUserResourceNode(pcJID);
            if (mobileClusterNode != null && !mobileClusterNode.isEmpty()) {
                mobileOnline = true;
            }
            if (padClusterNode != null && !padClusterNode.isEmpty()) {
                padOnline = true;
            }
            if (pcClusterNode != null && !pcClusterNode.isEmpty()) {
                pcOnline = true;
            }
            PushDbUtil du = new PushDbUtil();
            if (pcOnline) {
                PushUtil pu;
                Element delaytest2;
                String pushStatus;
                PushDevice pd;
                Message pcMsg = message.createCopy();
                pcMsg.setTo(pcJID);
                clusterRedisUtil.saveToRedis(pcClusterNode, pcMsg);
                if (!mobileOnline) {
                    pd = du.getRegisterPush(message.getTo(), "mobile");
                    if (pd != null) {
                        pushStatus = pd.getPushStatus();
                        if (pushStatus == null || pushStatus.equals("")) {
                            pushStatus = JiveGlobals.getProperty((String)"pushStatus", (String)"0");
                        }
                        if (("1".equals(pushStatus) || message.getFrom().getNode().endsWith("|notice|-2")) && (delaytest2 = message.getChildElement("delay", "urn:xmpp:delay")) == null) {
                            pu = new PushUtil(userManager, groupManager);
                            Message mobileMsg = message.createCopy();
                            mobileMsg.setTo(mobileJID);
                            pu.pushMessage(mobileMsg);
                        }
                    }
                } else {
                    Message mobileMsg = message.createCopy();
                    mobileMsg.setTo(mobileJID);
                    clusterRedisUtil.saveToRedis(mobileClusterNode, mobileMsg);
                }
                if (!padOnline) {
                    pd = du.getRegisterPush(message.getTo(), "pad");
                    if (pd != null) {
                        pushStatus = pd.getPushStatus();
                        if (pushStatus == null || pushStatus.equals("")) {
                            pushStatus = JiveGlobals.getProperty((String)"pushStatus", (String)"0");
                        }
                        if (("1".equals(pushStatus) || message.getFrom().getNode().endsWith("|notice|-2")) && (delaytest2 = message.getChildElement("delay", "urn:xmpp:delay")) == null) {
                            pu = new PushUtil(userManager, groupManager);
                            Message padMsg = message.createCopy();
                            padMsg.setTo(padJID);
                            pu.pushMessage(padMsg);
                        }
                    }
                } else {
                    Message padMsg = message.createCopy();
                    padMsg.setTo(padJID);
                    clusterRedisUtil.saveToRedis(padClusterNode, padMsg);
                }
            }
            if (!pcOnline) {
                PushUtil pu;
                Element delaytest3;
                if (mobileOnline) {
                    Message mobileMsg = message.createCopy();
                    mobileMsg.setTo(mobileJID);
                    clusterRedisUtil.saveToRedis(mobileClusterNode, mobileMsg);
                } else {
                    delaytest3 = message.getChildElement("delay", "urn:xmpp:delay");
                    if (delaytest3 == null) {
                        pu = new PushUtil(userManager, groupManager);
                        Message mobileMsg = message.createCopy();
                        mobileMsg.setTo(mobileJID);
                        pu.pushMessage(mobileMsg);
                    }
                }
                if (padOnline) {
                    Message padMsg = message.createCopy();
                    padMsg.setTo(padJID);
                    clusterRedisUtil.saveToRedis(padClusterNode, padMsg);
                } else {
                    delaytest3 = message.getChildElement("delay", "urn:xmpp:delay");
                    if (delaytest3 == null) {
                        pu = new PushUtil(userManager, groupManager);
                        Message padMsg = message.createCopy();
                        padMsg.setTo(padJID);
                        pu.pushMessage(padMsg);
                    }
                }
            }
            needPush = false;
        }
        if (needPush && message.getTo() != null && message.getTo().getResource() == null && (delaytest = message.getChildElement("delay", "urn:xmpp:delay")) == null) {
            Log.info("user not online and push message.from:{},to:{},msgId:{}", new Object[]{message.getFrom(), message.getTo(), message.getID()});
            PushUtil pu = new PushUtil(userManager, groupManager);
            JID mobileJID = new JID(message.getTo().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
            Message mobileMsg = message.createCopy();
            mobileMsg.setTo(mobileJID);
            pu.pushMessage(mobileMsg);
            JID padJID = new JID(message.getTo().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pad", true);
            Message padMessage = message.createCopy();
            padMessage.setTo(padJID);
            pu.pushMessage(padMessage);
        }
    }

    private static void processMessageStore4Mobile(Message message) {
        Element delaytest;
        PushDbUtil du;
        PushDevice pd;
        Log.debug("offline message, from:{}, to:{}, msgid:{}", new Object[]{message.getFrom().getNode(), message.getTo().getNode(), message.getID()});
        long startTime = System.currentTimeMillis();
        boolean needPush = true;
        boolean mobileOnline = false;
        boolean pcOnline = false;
        ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
        if (clusterPropBeanUtil.isUseCluster()) {
            ClusterRedisUtil clusterRedisUtil = ClusterRedisUtil.getInstance();
            JID mobileJID = new JID(message.getTo().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
            String mobileClusterNode = clusterRedisUtil.getUserResourceNode(mobileJID);
            JID pcJID = new JID(message.getTo().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
            String pcClusterNode = clusterRedisUtil.getUserResourceNode(pcJID);
            Log.debug("messageStored,mobileClusterNode node :{},:{},pcClusterNode:{}", new Object[]{message.getTo().getNode(), mobileClusterNode, pcClusterNode});
            if (mobileClusterNode != null && !mobileClusterNode.isEmpty()) {
                clusterRedisUtil.saveToRedis(mobileClusterNode, message);
                needPush = false;
                mobileOnline = true;
                if (!mobileClusterNode.equals(pcClusterNode) && pcClusterNode != null && !pcClusterNode.isEmpty()) {
                    clusterRedisUtil.saveToRedis(pcClusterNode, message);
                    needPush = false;
                    pcOnline = true;
                }
            } else if (pcClusterNode != null && !pcClusterNode.isEmpty()) {
                clusterRedisUtil.saveToRedis(pcClusterNode, message);
                needPush = false;
                pcOnline = true;
            }
        }
        if (pcOnline && !mobileOnline && (pd = (du = new PushDbUtil()).getRegisterPush(message.getTo())) != null) {
            Element delaytest2;
            String pushStatus = pd.getPushStatus();
            if (pushStatus == null || pushStatus.equals("")) {
                pushStatus = JiveGlobals.getProperty((String)"pushStatus", (String)"0");
            }
            if (("1".equals(pushStatus) || message.getFrom().getNode().endsWith("|notice|-2")) && (delaytest2 = message.getChildElement("delay", "urn:xmpp:delay")) == null) {
                PushUtil pu = new PushUtil(userManager, groupManager);
                pu.pushMessage(message);
            }
        }
        Log.debug("messageStored,custer save cost:{} ms", (Object)(System.currentTimeMillis() - startTime));
        if (needPush && message.getTo() != null && message.getTo().getResource() == null && (delaytest = message.getChildElement("delay", "urn:xmpp:delay")) == null) {
            PushUtil pu = new PushUtil(userManager, groupManager);
            pu.pushMessage(message);
        }
    }
}

