/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.multirouter.messagesync;

import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import java.util.Collection;
import org.dom4j.Element;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.bean.PushDevice;
import org.jivesoftware.openfire.plugin.push.PushDbUtil;
import org.jivesoftware.openfire.plugin.util.PushUtil;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;

public class ProcessSyncMessageReciver {
    private static SessionManager sessionManager = SessionManager.getInstance();
    private static UserManager userManager = UserManager.getInstance();
    private static GroupManager groupManager = GroupManager.getInstance();

    public static void syncMessageReciver(Session session, Message message) {
        if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
            ProcessSyncMessageReciver.processMessage2SenderPad(session, message);
        } else {
            ProcessSyncMessageReciver.processMessage2ReciverMobile(session, message);
        }
    }

    private static void processMessage2SenderPad(Session session, Message message) {
        Message msg;
        PushUtil pu;
        Element delaytest;
        String pushStatus;
        PushDevice pd;
        PushDbUtil du;
        Message msg2;
        String clusterNode;
        Message routeMessage = message.createCopy();
        JID toJID = message.getTo();
        JID syncJID1 = null;
        boolean syncResource1Online = false;
        boolean syncResource2Online = false;
        JID syncJID2 = null;
        if (session.getAddress().getResource().equals("mobile")) {
            syncJID1 = new JID(toJID.getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
            syncJID2 = new JID(toJID.getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pad", true);
        } else if (session.getAddress().getResource().equals("pad")) {
            syncJID1 = new JID(toJID.getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
            syncJID2 = new JID(toJID.getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
        } else if (session.getAddress().getResource().equals("pc")) {
            syncJID1 = new JID(toJID.getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pad", true);
            syncJID2 = new JID(toJID.getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
        } else {
            return;
        }
        Collection sessions = sessionManager.getSessions(toJID.getNode());
        for (ClientSession clientSession : sessions) {
            Message msg3;
            if (syncJID1.getResource().equals(clientSession.getAddress().getResource())) {
                syncResource1Online = true;
                msg3 = routeMessage.createCopy();
                msg3.setTo(syncJID1);
                clientSession.process((Packet)msg3);
            }
            if (!syncJID2.getResource().equals(clientSession.getAddress().getResource())) continue;
            syncResource2Online = true;
            msg3 = routeMessage.createCopy();
            msg3.setTo(syncJID2);
            clientSession.process((Packet)msg3);
        }
        ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
        ClusterRedisUtil clusterRedisUtil = ClusterRedisUtil.getInstance();
        if (!syncResource1Online && clusterPropBeanUtil.isUseCluster() && (clusterNode = clusterRedisUtil.getUserResourceNode(syncJID1)) != null && !clusterNode.isEmpty()) {
            syncResource1Online = true;
            msg2 = routeMessage.createCopy();
            msg2.setTo(syncJID1);
            clusterRedisUtil.saveToRedis(clusterNode, msg2);
        }
        if (!syncResource2Online && clusterPropBeanUtil.isUseCluster() && (clusterNode = clusterRedisUtil.getUserResourceNode(syncJID2)) != null && !clusterNode.isEmpty()) {
            syncResource2Online = true;
            msg2 = routeMessage.createCopy();
            msg2.setTo(syncJID2);
            clusterRedisUtil.saveToRedis(clusterNode, msg2);
        }
        if (!syncResource1Online && ("mobile".equals(syncJID1.getResource()) || "pad".equals(syncJID1.getResource()))) {
            boolean needPush = false;
            if ("pc".equals(session.getAddress().getResource()) || syncResource2Online && "pc".equals(syncJID2.getResource())) {
                du = new PushDbUtil();
                pd = du.getRegisterPush(syncJID1, syncJID1.getResource());
                if (pd != null) {
                    pushStatus = pd.getPushStatus();
                    if (pushStatus == null || pushStatus.equals("")) {
                        pushStatus = JiveGlobals.getProperty((String)"pushStatus", (String)"0");
                    }
                    if ("1".equals(pushStatus) || message.getFrom().getNode().endsWith("|notice|-2")) {
                        needPush = true;
                    }
                }
            } else {
                needPush = true;
            }
            if (needPush && (delaytest = message.getChildElement("delay", "urn:xmpp:delay")) == null) {
                pu = new PushUtil(userManager, groupManager);
                msg = message.createCopy();
                msg.setTo(syncJID1);
                pu.pushMessage(msg);
            }
        }
        if (!syncResource2Online && ("mobile".equals(syncJID2.getResource()) || "pad".equals(syncJID2.getResource()))) {
            boolean needPush = false;
            if ("pc".equals(session.getAddress().getResource()) || syncResource1Online && "pc".equals(syncJID1.getResource())) {
                du = new PushDbUtil();
                pd = du.getRegisterPush(syncJID2, syncJID2.getResource());
                if (pd != null) {
                    pushStatus = pd.getPushStatus();
                    if (pushStatus == null || pushStatus.equals("")) {
                        pushStatus = JiveGlobals.getProperty((String)"pushStatus", (String)"0");
                    }
                    if ("1".equals(pushStatus) || message.getFrom().getNode().endsWith("|notice|-2")) {
                        needPush = true;
                    }
                }
            } else {
                needPush = true;
            }
            if (needPush && (delaytest = message.getChildElement("delay", "urn:xmpp:delay")) == null) {
                pu = new PushUtil(userManager, groupManager);
                msg = message.createCopy();
                msg.setTo(syncJID2);
                pu.pushMessage(msg);
            }
        }
    }

    private static void processMessage2ReciverMobile(Session session, Message message) {
        PushDbUtil du;
        PushDevice pd;
        ClusterRedisUtil clusterRedisUtil;
        String clusterNode;
        JID routerJID;
        Message routeMessage = message.createCopy();
        JID toJID = message.getTo();
        if (session.getAddress().getResource().equals("mobile")) {
            routerJID = new JID(toJID.getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
        } else if (session.getAddress().getResource().equals("pc")) {
            routerJID = new JID(toJID.getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
        } else {
            return;
        }
        routeMessage.setTo(routerJID);
        boolean routeTargetIsInline = false;
        Collection sessions = sessionManager.getSessions(toJID.getNode());
        for (ClientSession clientSession : sessions) {
            if (!routerJID.getResource().equals(clientSession.getAddress().getResource())) continue;
            routeTargetIsInline = true;
            clientSession.process((Packet)routeMessage);
        }
        ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
        if (!routeTargetIsInline && clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(routeMessage.getTo())) != null && !clusterNode.isEmpty()) {
            clusterRedisUtil.saveToRedis(clusterNode, routeMessage);
            routeTargetIsInline = true;
        }
        if (!routeTargetIsInline && routeMessage.getTo().getResource().equals("mobile") && (pd = (du = new PushDbUtil()).getRegisterPush(routeMessage.getTo())) != null) {
            Element delaytest;
            String pushStatus = pd.getPushStatus();
            if (pushStatus == null || pushStatus.equals("")) {
                pushStatus = JiveGlobals.getProperty((String)"pushStatus", (String)"0");
            }
            if (("1".equals(pushStatus) || routeMessage.getFrom().getNode().endsWith("|notice|-2")) && (delaytest = message.getChildElement("delay", "urn:xmpp:delay")) == null) {
                PushUtil pu = new PushUtil(userManager, groupManager);
                pu.pushMessage(message);
            }
        }
    }
}

