/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.multirouter.messagesync;

import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import java.util.Collection;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.util.MessageRouterUtil;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;

public class ProcessSyncMessageSender {
    private static final Logger Log = LoggerFactory.getLogger(ProcessSyncMessageSender.class);
    private static SessionManager sessionManager = SessionManager.getInstance();

    public static void processMessage2Sender(Message message) {
        if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
            ProcessSyncMessageSender.processMessage2SenderPad(message);
        } else {
            ProcessSyncMessageSender.processMessage2SenderMobile(message);
        }
    }

    private static void processMessage2SenderPad(Message message) {
        ClusterPropBeanUtil clusterProp = ClusterPropBeanUtil.getInstance();
        ClusterRedisUtil clusterRedis = ClusterRedisUtil.getInstance();
        Message muliteMessage = message.createCopy();
        Message syncMessage = message.createCopy();
        JID syncJID1 = null;
        boolean syncResource1Online = false;
        boolean syncResource2Online = false;
        JID syncJID2 = null;
        if (message.getFrom().getResource().equals("sys")) {
            MessageRouterUtil.RouterMessageToMobileAndPc(message);
        } else {
            Message msg;
            String clusterNode;
            Message msg2;
            ClientSession clientSession;
            if ("mobile".equals(syncMessage.getFrom().getResource())) {
                syncJID1 = new JID(syncMessage.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
                syncJID2 = new JID(syncMessage.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pad", true);
            } else if ("pc".equals(syncMessage.getFrom().getResource())) {
                syncJID1 = new JID(syncMessage.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
                syncJID2 = new JID(syncMessage.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pad", true);
            } else if ("pad".equals(syncMessage.getFrom().getResource())) {
                syncJID1 = new JID(syncMessage.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
                syncJID2 = new JID(syncMessage.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
            }
            if (!syncMessage.getTo().getDomain().startsWith("group.")) {
                muliteMessage.setFrom(new JID(syncMessage.getFrom().getNode(), "confirm." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), syncMessage.getTo().getNode(), true));
            } else {
                muliteMessage.setFrom(new JID(syncMessage.getFrom().getNode(), "confirm.group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), syncMessage.getTo().getNode(), true));
            }
            if (!syncResource1Online) {
                clientSession = sessionManager.getSession(syncJID1);
                if (clientSession != null && !clientSession.isAnonymousUser() && !clientSession.isClosed()) {
                    msg2 = muliteMessage.createCopy();
                    msg2.setTo(syncJID1);
                    clientSession.process((Packet)msg2);
                    syncResource1Online = true;
                }
                if (!syncResource1Online && clusterProp.isUseCluster() && (clusterNode = clusterRedis.getUserResourceNode(syncJID1)) != null && !clusterNode.isEmpty()) {
                    msg = muliteMessage.createCopy();
                    msg.setTo(syncJID1);
                    clusterRedis.saveToRedis(clusterNode, msg);
                    syncResource1Online = true;
                }
            }
            if (!syncResource2Online) {
                clientSession = sessionManager.getSession(syncJID2);
                if (clientSession != null && !clientSession.isAnonymousUser() && !clientSession.isClosed()) {
                    msg2 = muliteMessage.createCopy();
                    msg2.setTo(syncJID2);
                    clientSession.process((Packet)msg2);
                    syncResource1Online = true;
                }
                if (!syncResource1Online && clusterProp.isUseCluster() && (clusterNode = clusterRedis.getUserResourceNode(syncJID2)) != null && !clusterNode.isEmpty()) {
                    msg = muliteMessage.createCopy();
                    msg.setTo(syncJID2);
                    clusterRedis.saveToRedis(clusterNode, msg);
                    syncResource1Online = true;
                }
            }
        }
    }

    private static void processMessage2SenderMobile(Message message) {
        Message muliteMessage = message.createCopy();
        JID fJID = null;
        if (message.getFrom().getResource().equals("sys")) {
            MessageRouterUtil.RouterMessageToMobileAndPc(message);
        } else {
            ClusterRedisUtil clusterRedisUtil;
            String clusterNode;
            if (message.getFrom().getResource().equals("mobile")) {
                fJID = new JID(message.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
            } else if (message.getFrom().getResource().equals("pc")) {
                fJID = new JID(message.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
            }
            if (!message.getTo().getDomain().startsWith("group.")) {
                muliteMessage.setFrom(new JID(message.getFrom().getNode(), "confirm." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), message.getTo().getNode(), true));
            } else {
                muliteMessage.setFrom(new JID(message.getFrom().getNode(), "confirm.group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), message.getTo().getNode(), true));
            }
            muliteMessage.setTo(fJID);
            boolean hasRoute = false;
            Collection sessions = sessionManager.getSessions(fJID.getNode());
            for (ClientSession clientSession : sessions) {
                if (!fJID.getResource().equals(clientSession.getAddress().getResource())) continue;
                clientSession.process((Packet)muliteMessage);
                hasRoute = true;
            }
            ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
            if (!hasRoute && clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(muliteMessage.getTo())) != null && !clusterNode.isEmpty()) {
                clusterRedisUtil.saveToRedis(clusterNode, muliteMessage);
            }
        }
    }
}

