/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.multirouter.messagesync;

import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import java.util.Collection;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class ProcessUserSession {
    private static final Logger Log = LoggerFactory.getLogger(ProcessUserSession.class);
    private static SessionManager sessionManager = SessionManager.getInstance();

    public static void processAvailableSession(ClientSession session, Presence presence) {
        if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
            ProcessUserSession.processAvailableSession4Pad(session, presence);
        } else {
            ProcessUserSession.processAvailableSession4Mobile(session, presence);
        }
    }

    public static void processUnavailableSession(ClientSession session, Presence presence) {
        if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
            ProcessUserSession.processUnavailableSession4Pad(session, presence);
        } else {
            ProcessUserSession.processUnavailableSession4Mobile(session, presence);
        }
    }

    private static void processUnavailableSession4Pad(ClientSession session, Presence presence) {
        ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
        if ("pc".equals(presence.getFrom().getResource())) {
            ClusterRedisUtil clusterRedisUtil;
            String clusterNode;
            Presence routePresence;
            JID mobileJID = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
            JID padJID = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pad", true);
            Collection sessions = sessionManager.getSessions(presence.getFrom().getNode());
            boolean mobileProcess = false;
            boolean padProcess = false;
            for (ClientSession clientSession : sessions) {
                if (mobileJID.getResource().equals(clientSession.getAddress().getResource())) {
                    mobileProcess = true;
                    routePresence = presence.createCopy();
                    routePresence.setTo(mobileJID);
                    clientSession.process((Packet)routePresence);
                }
                if (!padJID.getResource().equals(clientSession.getAddress().getResource())) continue;
                padProcess = true;
                routePresence = presence.createCopy();
                routePresence.setTo(padJID);
                clientSession.process((Packet)routePresence);
                Log.info("sendPresencetoPad :{}", (Object)routePresence.toString());
            }
            if (!mobileProcess && clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(mobileJID)) != null && !clusterNode.isEmpty()) {
                routePresence = presence.createCopy();
                routePresence.setTo(mobileJID);
                clusterRedisUtil.saveToRedis(clusterNode, routePresence);
            }
            if (!padProcess && clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(padJID)) != null && !clusterNode.isEmpty()) {
                routePresence = presence.createCopy();
                routePresence.setTo(padJID);
                Log.info("sendPresencetoPad :{}", (Object)routePresence.toString());
                clusterRedisUtil.saveToRedis(clusterNode, routePresence);
            }
        }
        if (session != null && session.getAddress() != null) {
            Log.info("logout, user name:{}, dev:{}", (Object)session.getAddress().getNode(), (Object)session.getAddress().getResource());
        }
    }

    private static void processUnavailableSession4Mobile(ClientSession session, Presence presence) {
        ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
        Presence routePresence = null;
        if ("pc".equals(presence.getFrom().getResource())) {
            ClusterRedisUtil clusterRedisUtil;
            String clusterNode;
            JID fJID = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
            boolean routeTargetIsInline = false;
            Collection sessions = sessionManager.getSessions(fJID.getNode());
            for (ClientSession clientSession : sessions) {
                if (!fJID.getResource().equals(clientSession.getAddress().getResource())) continue;
                routePresence = presence.createCopy();
                routePresence.setTo(fJID);
                clientSession.process((Packet)routePresence);
                routeTargetIsInline = true;
            }
            if (!routeTargetIsInline && clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(fJID)) != null && !clusterNode.isEmpty()) {
                routePresence = presence.createCopy();
                routePresence.setTo(fJID);
                clusterRedisUtil.saveToRedis(clusterNode, routePresence);
            }
        }
        if (session != null && session.getAddress() != null) {
            Log.info("logout, user name:{}, dev:{}", (Object)session.getAddress().getNode(), (Object)session.getAddress().getResource());
        }
    }

    private static void processAvailableSession4Pad(ClientSession session, Presence presence) {
        ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
        if (presence.getFrom().getResource().equals("pc")) {
            ClusterRedisUtil clusterRedisUtil;
            String clusterNode;
            Presence routePresence;
            JID mobileJID = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
            JID padJID = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pad", true);
            Collection sessions = sessionManager.getSessions(presence.getFrom().getNode());
            boolean mobileProcess = false;
            boolean padProcess = false;
            for (ClientSession clientSession : sessions) {
                if (mobileJID.getResource().equals(clientSession.getAddress().getResource())) {
                    mobileProcess = true;
                    routePresence = presence.createCopy();
                    routePresence.setTo(mobileJID);
                    clientSession.process((Packet)routePresence);
                }
                if (!padJID.getResource().equals(clientSession.getAddress().getResource())) continue;
                padProcess = true;
                routePresence = presence.createCopy();
                routePresence.setTo(padJID);
                Log.info("sendPresencetoPad :{}", (Object)routePresence.toString());
                clientSession.process((Packet)routePresence);
            }
            if (!mobileProcess && clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(mobileJID)) != null && !clusterNode.isEmpty()) {
                routePresence = presence.createCopy();
                routePresence.setTo(mobileJID);
                clusterRedisUtil.saveToRedis(clusterNode, routePresence);
            }
            if (!padProcess && clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(padJID)) != null && !clusterNode.isEmpty()) {
                routePresence = presence.createCopy();
                routePresence.setTo(padJID);
                Log.info("sendPresencetoPad :{}", (Object)routePresence.toString());
                clusterRedisUtil.saveToRedis(clusterNode, routePresence);
            }
        }
        if (session != null && session.getAddress() != null) {
            Log.info("login, user name:{}, dev:{}", (Object)session.getAddress().getNode(), (Object)session.getAddress().getResource());
        }
    }

    private static void processAvailableSession4Mobile(ClientSession session, Presence presence) {
        ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
        if (presence.getFrom().getResource().equals("pc")) {
            ClusterRedisUtil clusterRedisUtil;
            String clusterNode;
            JID fJID = new JID(presence.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
            boolean routeTargetIsInline = false;
            Collection sessions = sessionManager.getSessions(fJID.getNode());
            Presence routePresence = null;
            for (ClientSession clientSession : sessions) {
                if (!fJID.getResource().equals(clientSession.getAddress().getResource())) continue;
                routeTargetIsInline = true;
                routePresence = presence.createCopy();
                routePresence.setTo(fJID);
                clientSession.process((Packet)routePresence);
            }
            if (!routeTargetIsInline && clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(fJID)) != null && !clusterNode.isEmpty()) {
                routePresence = presence.createCopy();
                routePresence.setTo(fJID);
                clusterRedisUtil.saveToRedis(clusterNode, routePresence);
            }
        }
        if (session != null && session.getAddress() != null) {
            Log.info("login, user name:{}, dev:{}", (Object)session.getAddress().getNode(), (Object)session.getAddress().getResource());
        }
    }
}

