/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.multirouter.msgpushutil;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.multirouter.msgpushutil.MsgPushBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jivesoftware.database.DbConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgPushUtil {
    private static final Logger Log = LoggerFactory.getLogger(MsgPushUtil.class);
    private static final String REDIS_KEY_FLAG = "msg:push:status:";
    private static final int REDIS_KEY_EXPIRE = 2592000;

    public static void main(String[] args) {
        System.out.println(MsgPushUtil.checkTimeNeedPush("09:56", "09:00"));
    }

    public boolean checkUserPush(String userId) {
        MsgPushBean msgPushBean = this.getMsgPushSetting(userId);
        if (msgPushBean != null && "1".equals(msgPushBean.getPushStatus())) {
            String startTime = msgPushBean.getStartTime();
            String endTime = msgPushBean.getEndTime();
            if (startTime == null || startTime.isEmpty() || endTime == null || endTime.isEmpty()) {
                return true;
            }
            if (startTime.equals(endTime)) {
                return true;
            }
            return MsgPushUtil.checkTimeNeedPush(startTime, endTime);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsgPushBean getMsgPushSetting(String userId) {
        String value;
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null && (value = redisPoolMgr.get(this.getRedisKey(userId))) != null) {
            return (MsgPushBean)JSONObject.parseObject((String)value, MsgPushBean.class);
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MsgPushBean msgPushBean = new MsgPushBean();
        msgPushBean.setUserId(userId);
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select pushStatus,startTime,endTime from ofmsgpushsetting where userid = ? ");
            pstmt.setString(1, userId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                msgPushBean.setPushStatus(rs.getString("pushStatus"));
                msgPushBean.setStartTime(rs.getString("startTime"));
                msgPushBean.setEndTime(rs.getString("endTime"));
            }
        }
        catch (SQLException e) {
            try {
                Log.error("MsgPushUtil ,msgPushSetting ,userId :{} ,error:{} ,e :{} ", new Object[]{userId, e.getMessage(), e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        if (redisPoolMgr != null) {
            redisPoolMgr.set(this.getRedisKey(userId), JSON.toJSONString((Object)msgPushBean), 2592000);
        }
        return msgPushBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgPushSetting(String userId, String pushStatus, String startTime, String endTime) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block6: {
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(" select * from ofmsgpushsetting where userid = ? ");
                pstmt.setString(1, userId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DbConnectionManager.closeStatement((Statement)pstmt);
                    pstmt = con.prepareStatement(" update ofmsgpushsetting set pushStatus = ?,startTime = ? ,endTime = ? where userId = ? ");
                    pstmt.setString(1, pushStatus);
                    pstmt.setString(2, startTime);
                    pstmt.setString(3, endTime);
                    pstmt.setString(4, userId);
                    pstmt.executeUpdate();
                    break block6;
                }
                DbConnectionManager.closeStatement((Statement)pstmt);
                pstmt = con.prepareStatement(" insert into ofmsgpushsetting (userId,pushStatus,startTime,endTime) Values (?,?,?,?) ");
                pstmt.setString(1, userId);
                pstmt.setString(2, pushStatus);
                pstmt.setString(3, startTime);
                pstmt.setString(4, endTime);
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    Log.error("MsgPushUtil ,msgPushSetting ,userId :{} ,pushStatus :{} ,startTime :{} ,endTime :{} ,error:{} ,e :{} ", new Object[]{userId, pushStatus, startTime, endTime, e.getMessage(), e});
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            MsgPushBean msgPushBean = new MsgPushBean();
            msgPushBean.setUserId(userId);
            msgPushBean.setPushStatus(pushStatus);
            msgPushBean.setStartTime(startTime);
            msgPushBean.setEndTime(endTime);
            redisPoolMgr.set(this.getRedisKey(userId), JSON.toJSONString((Object)msgPushBean), 2592000);
        }
    }

    private String getRedisKey(String userId) {
        return REDIS_KEY_FLAG + userId;
    }

    public static boolean checkTimeNeedPush(String startTime, String endTime) {
        SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("HH:mm");
        String nowTime = SDF_ALL_TIME_FORMAT.format(new Date());
        System.out.println(nowTime);
        return endTime.compareTo(startTime) < 0 ? nowTime.compareTo(startTime) >= 0 || endTime.compareTo(nowTime) >= 0 : nowTime.compareTo(startTime) >= 0 && endTime.compareTo(nowTime) >= 0;
    }
}

