/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.util.deluserdata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.weaver.util.ServerInfo;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class DelGroupThread
extends Thread {
    private static final Logger Log = LoggerFactory.getLogger(DelGroupThread.class);
    private List<String> userIdList;
    UserManager userManager;
    GroupManager groupManager;

    public DelGroupThread(List<String> userIdList) {
        this.userIdList = userIdList;
        this.userManager = UserManager.getInstance();
        this.groupManager = GroupManager.getInstance();
    }

    @Override
    public void run() {
        for (String userId : this.userIdList) {
            String username = userId + "|" + ServerInfo.SYSTEM_UDID;
            User user = null;
            try {
                user = this.userManager.getUser(username);
                user.setIsTurnover(true);
            }
            catch (UserNotFoundException e) {
                Log.warn("DelGroupThread,user : {} not found .", (Object)username);
                continue;
            }
            Collection groups = this.groupManager.getGroups(user);
            if (null == groups || groups.size() <= 0) continue;
            for (Group group : groups) {
                JSONArray groupManagerArray;
                String groupManagers;
                PersistableMap groupPropMap;
                JID userJid = new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                group.getMembers().remove(userJid);
                if (group.getAdmins().contains(userJid)) {
                    group.getAdmins().remove(userJid);
                }
                if ((groupPropMap = group.getProperties()) == null || !groupPropMap.containsKey((Object)"groupManagers") || (groupManagers = (String)groupPropMap.get((Object)"groupManagers")) == null || groupManagers.isEmpty() || (groupManagerArray = JSON.parseArray((String)groupManagers)) == null) continue;
                if (groupManagerArray.contains((Object)user.getUID())) {
                    groupManagerArray.remove((Object)user.getUID());
                }
                groupPropMap.put((Object)"groupManagers", (Object)groupManagerArray.toString());
            }
        }
    }
}

