/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.util.deluserdata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.jivesoftware.database.DbConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelHistoryMsgThread
extends Thread {
    private List<String> userIdList;
    private static final Logger Log = LoggerFactory.getLogger(DelHistoryMsgThread.class);

    public DelHistoryMsgThread(List<String> userIdList) {
        this.userIdList = userIdList;
    }

    @Override
    public void run() {
        Log.info("DelHistoryMsgThread ,userIdList :{} ", this.userIdList);
        for (String userId : this.userIdList) {
            this.deleteHistoryMsg(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHistoryMsg(String userId) {
        Log.info("DelHistoryMsgThread,not start delete historyMsg userId:{}", (Object)userId);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(this.getDeleteHistoryMsgSQL());
            pstmt.setString(1, userId);
            int deleteHistoryMsgNumber = 0;
            while ((deleteHistoryMsgNumber = pstmt.executeUpdate()) > 0) {
            }
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement(this.getDeleteHistoryMsgRecentlySQL());
            pstmt.setString(1, userId);
            int deleteHistoryMsgRecentlyNumber = 0;
            while ((deleteHistoryMsgRecentlyNumber = pstmt.executeUpdate()) > 0) {
            }
        }
        catch (SQLException e) {
            try {
                Log.error("deleteHistoryMsg,error :{} ,userID:{},e:{}", new Object[]{e.getMessage(), userId, e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    private String getDeleteHistoryMsgRecentlySQL() {
        if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
            return " delete from historyMsgRecently where fromUserId = ? limit 1000 ";
        }
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            return " delete top(1000) from historyMsgRecently where fromUserId = ?  ";
        }
        if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            return " with tmptb as(select ctid from historyMsgRecently where fromuserid = ? limit 1000) delete from historymsg where ctid in(select ctid from tmptb) ";
        }
        return " delete from historyMsg where historyMsgRecently = ? and rownum < 1000 ";
    }

    private String getDeleteHistoryMsgSQL() {
        if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
            return " delete from historyMsg where fromUserId = ? limit 1000 ";
        }
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            return " delete top(1000) from historyMsg where fromUserId = ?  ";
        }
        if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            return " with tmptb as(select ctid from historymsg where fromuserid = ? limit 1000) delete from historymsg where ctid in(select ctid from tmptb) ";
        }
        return " delete from historyMsg where fromUserId = ? and rownum < 1000 ";
    }
}

