/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plguin.push.zdbank;

import com.alibaba.fastjson.JSONObject;
import com.ccb.esafe.crypto.gm.SM2Util;
import com.ccb.esafe.crypto.gm.SM4Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import org.jivesoftware.openfire.plguin.push.zdbank.ZDBankRequestUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZDBankPushUtil {
    private static final Logger Log = LoggerFactory.getLogger(ZDBankPushUtil.class);
    private static String accessToken = null;
    private static long accessTokenExpire = 0L;
    private static String publicKey = "B25AB27D724AB15EBE107239E5B2D3FD2533C710750610FCC421BDFAD52E7BF82EE5C4C59B4B94DE5899CE5A7748CBD7F1408A05E3DBE83FA364FC1F06787694";
    private static String access_token_uri = "/auth/token";
    private static String access_token_client_id = "4634530063225e00f4af25d43bd18c03";
    private static String access_token_client_secret = "5UhaHoQf1afiymrzkB3RH-XG9W5NclThpCJR-kA7qTdeZwtUDEn7G7xXHbkUyaGC";
    private static String platform_num = "xdxx0010";
    private static String signKey = "##dba179662c00346f";
    private static String pushUri = "/notify/account_notify";
    public static String address_url = "http://128.196.138.39:8080";
    private static String getCredentialUri = "/platformManage/getCredential";
    private static String pushTitle = "\u6653\u5f97\u7cfb\u7edf";
    private static boolean zdBankPushEnable = false;
    private static final String ZDBankPropFilePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "ZDBankPush.properties";

    public static boolean checkPushEnable() {
        ZDBankPushUtil.loadZdBankPushConfig();
        if (zdBankPushEnable) {
            Log.info("ZDBankPushUtil,checkPushEnable:{},access_token_url:{},pushUrl:{},getCredentialUrl:{},address_url:{}", new Object[]{zdBankPushEnable, access_token_uri, pushUri, getCredentialUri, address_url});
            Log.info("ZDBankPushUtil,publicKey:{},access_token_client_id:{},access_token_client_secret:{},platform_num:{},signKey:{},pushTitle:{}", new Object[]{publicKey, access_token_client_id, access_token_client_secret, platform_num, signKey, pushTitle});
            System.out.println(System.getProperty("user.dir"));
            System.out.println(System.getProperty("ICR_CONFIG_PATH"));
            try {
                Log.info("ZDBankPushUtil,getAccess_token,\u83b7\u53d6\u5230\u7684accessToken\u662f:{}", (Object)ZDBankPushUtil.getAccess_token());
                Log.info("ZDBankPushUtil,getCredential,\u83b7\u53d6\u5230\u7684\u51ed\u8bc1\u662f:{}", (Object)ZDBankPushUtil.getCredential());
                Log.info("========\u53d1\u9001\u63a8\u9001\u6d4b\u8bd5======");
                ZDBankPushUtil.pushMessage("test", "\u6d4b\u8bd513123", true);
                Log.info("========\u53d1\u9001\u63a8\u9001\u6d4b\u8bd5\u7ed3\u675f======");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return zdBankPushEnable;
    }

    public static void main(String[] args) {
        System.out.println(ZDBankPushUtil.getTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadZdBankPushConfig() {
        block25: {
            InputStream is = null;
            try {
                File file = new File(ZDBankPropFilePath);
                if (!file.exists()) {
                    return;
                }
                is = new FileInputStream(file);
                InputStreamReader fr = new InputStreamReader(is, "UTF-8");
                BufferedReader in = new BufferedReader(fr);
                Properties prop = new Properties();
                prop.load(in);
                String ZDbankPushEnable = prop.getProperty("ZDbankPushEnable");
                if ("true".equals(ZDbankPushEnable)) {
                    String pushTitleProp;
                    String signKeyProp;
                    String platform_numProp;
                    String client_secretProp;
                    String client_idProp;
                    zdBankPushEnable = true;
                    access_token_uri = prop.getProperty("access_token_uri");
                    getCredentialUri = prop.getProperty("getCredentialUri");
                    pushUri = prop.getProperty("pushUri");
                    address_url = prop.getProperty("address_url");
                    String publicKeyProp = prop.getProperty("publicKey");
                    if (publicKeyProp != null && !publicKeyProp.isEmpty()) {
                        publicKey = publicKeyProp;
                    }
                    if ((client_idProp = prop.getProperty("client_id")) != null && !client_idProp.isEmpty()) {
                        access_token_client_id = client_idProp;
                    }
                    if ((client_secretProp = prop.getProperty("client_secret")) != null && !client_idProp.isEmpty()) {
                        access_token_client_secret = client_secretProp;
                    }
                    if ((platform_numProp = prop.getProperty("platform_num")) != null && !platform_numProp.isEmpty()) {
                        platform_num = platform_numProp;
                    }
                    if ((signKeyProp = prop.getProperty("signKey")) != null && !signKeyProp.isEmpty()) {
                        signKey = signKeyProp;
                    }
                    if ((pushTitleProp = prop.getProperty("pushTitle")) != null && !pushTitleProp.isEmpty()) {
                        pushTitle = pushTitleProp;
                    }
                    break block25;
                }
                return;
            }
            catch (Exception e) {
                Log.error("ZDBankPushUtil,loadZdBankPushConfig,error:{},e:{}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void pushMessage(String toUserid, String pushContent, boolean isIMMsg) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        requestHeader.put("tc", "P100A002");
        requestHeader.put("trn", ZDBankPushUtil.genRandomNum(25));
        requestHeader.put("seq", "0");
        requestHeader.put("st", ZDBankPushUtil.getTimestamp());
        requestHeader.put("snd", "xdxx0010");
        params.put("requestHeader", requestHeader);
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("toUserid", toUserid);
        if (isIMMsg) {
            requestBody.put("fromPubId", "600000000042");
        } else {
            requestBody.put("fromPubId", "600000000044");
        }
        requestBody.put("msgType", "tplmsg");
        requestBody.put("templateId", "YX0B5305E7AC2546DE9CEADC7822F67925");
        requestBody.put("pushTitle", pushTitle);
        requestBody.put("searchText", pushContent);
        HashMap<String, Object> msg_content = new HashMap<String, Object>();
        msg_content.put("media_type", "10");
        msg_content.put("forwardable", "0");
        msg_content.put("create_time", String.valueOf(System.currentTimeMillis()));
        HashMap<String, String> template = new HashMap<String, String>();
        template.put("param1_text.DATA", pushTitle);
        template.put("time_first.DATA", ZDBankPushUtil.getTime());
        template.put("param2_text.DATA", pushContent);
        msg_content.put("template", template);
        requestBody.put("msg_content", msg_content);
        params.put("requestBody", requestBody);
        ZDBankPushUtil.getAccess_token();
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        requestParam.put("access_token", accessToken);
        String result = ZDBankRequestUtil.sendRequest(requestParam, params, pushUri);
        Log.info("ZDBankPushUtil,pushMessage,result :{} ,params :{} ", (Object)result, params);
    }

    public static String getAccess_token() {
        if (accessToken != null && accessTokenExpire > System.currentTimeMillis()) {
            return accessToken;
        }
        try {
            JSONObject json;
            String signData = access_token_client_secret + signKey;
            String data = SM2Util.encrypt((String)publicKey, (String)signData);
            System.out.println(data);
            SM4Util sm4Util = new SM4Util();
            sm4Util.secretKey = "242a7e48f1035a8e";
            String sign = sm4Util.encryptDataToB4_ECB(data);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("grant_type", "client_credentials");
            paramMap.put("client_id", SM2Util.encrypt((String)publicKey, (String)access_token_client_id));
            paramMap.put("client_secret", SM2Util.encrypt((String)publicKey, (String)access_token_client_secret));
            paramMap.put("sign", sign);
            paramMap.put("type", "1");
            paramMap.put("platform_num", platform_num);
            HashMap<String, Object> bodyMap = new HashMap<String, Object>();
            String result = ZDBankRequestUtil.sendRequest(paramMap, bodyMap, access_token_uri);
            Log.info("getAccess_token,result:{}", (Object)result);
            if (result != null && (json = JSONObject.parseObject((String)result)).containsKey((Object)"access_token")) {
                accessToken = json.getString("access_token");
                accessTokenExpire = System.currentTimeMillis() + (long)(json.getIntValue("expires_in") * 1000) - 120000L;
            }
        }
        catch (IOException e) {
            Log.error("getAccess_token ,error :{},e :{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
        }
        return accessToken;
    }

    public static String getCredential() {
        String credential = null;
        try {
            JSONObject json;
            String signData = accessToken + signKey;
            String data = SM2Util.encrypt((String)publicKey, (String)signData);
            SM4Util sm4Util = new SM4Util();
            sm4Util.secretKey = "242a7e48f1035a8e";
            String sign = sm4Util.encryptDataToB4_ECB(data);
            ZDBankPushUtil.getAccess_token();
            HashMap<String, Object> requestParam = new HashMap<String, Object>();
            requestParam.put("access_token", accessToken);
            requestParam.put("sign", sign);
            requestParam.put("type", "1");
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("channelId", "110");
            String result = ZDBankRequestUtil.sendRequest(requestParam, requestBody, getCredentialUri);
            Log.info("getCredential,result:{}", (Object)result);
            if (result != null && (json = JSONObject.parseObject((String)result)).containsKey((Object)"credential")) {
                credential = json.getString("credential");
            }
        }
        catch (Exception e) {
            Log.error("ZDBankPushUtil,getCredential,emsg:{},e:{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
        }
        return credential;
    }

    private static String getTime() {
        SimpleDateFormat SDF_ALL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return SDF_ALL.format(new Date());
    }

    private static String getTimestamp() {
        SimpleDateFormat SDF_ALL = new SimpleDateFormat("yyyyMMddHHmmssFFF");
        return SDF_ALL.format(new Date());
    }

    private static String genRandomNum(int pwd_len) {
        int maxNum = 10;
        int count = 0;
        char[] str = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        StringBuffer pwd = new StringBuffer("");
        Random r = new Random();
        while (count < pwd_len) {
            int i = Math.abs(r.nextInt(10));
            if (i < 0 || i >= str.length) continue;
            pwd.append(str[i]);
            ++count;
        }
        return pwd.toString();
    }
}

