/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.util.WeiSouPropertiesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.dao.ChatSearchIQDao;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import weaver.fullsearch.interfaces.service.MegSearch;

public class ChatSearchIQHandler
extends IQHandler {
    private static final Logger logger = LoggerFactory.getLogger(ChatSearchIQHandler.class);
    private IQHandlerInfo iqHandlerInfo = new IQHandlerInfo("query", this.namespace);
    private String namespace = "http://weaver.com.cn/chat/search";

    public ChatSearchIQHandler() {
        super("ChatSearchIQHandler");
    }

    public IQHandlerInfo getInfo() {
        return this.iqHandlerInfo;
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        Map<Object, Object> map;
        String elementText = packet.getElement().elementText("query");
        JSONObject json = JSON.parseObject((String)elementText);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (packet.getType().equals((Object)IQ.Type.get)) {
            Integer pageSize;
            Integer pageNumber = json.getInteger("pageNumber");
            if (null == pageNumber) {
                pageNumber = 1;
            }
            if (null == (pageSize = json.getInteger("pageSize"))) {
                pageSize = 10;
            }
            String keyword = null;
            if (json != null && json.containsKey((Object)"keyword") && (keyword = json.getString("keyword")) != null && keyword.length() > 50) {
                keyword = keyword.substring(0, 50);
            }
            String senderId = null;
            if (json != null && json.containsKey((Object)"senderId")) {
                senderId = json.getString("senderId");
            }
            String startTime = json.getString("startTime");
            String endTime = json.getString("endTime");
            if (endTime != null && !endTime.contains("23:59:59") && !endTime.isEmpty() && endTime.length() <= 12) {
                endTime = endTime + " 23:59:59";
            }
            String userId = this.getUserIDByUsername(packet.getFrom().getNode());
            map = new HashMap();
            WeiSouPropertiesUtil w = WeiSouPropertiesUtil.getInstance();
            boolean weiSouEnable = w.isWeiSouEnable();
            boolean msgSearchValidate = false;
            if (weiSouEnable) {
                msgSearchValidate = MegSearch.searchValidate((String)"MSGSEARCH");
            }
            if (weiSouEnable && msgSearchValidate) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("schemaType", "MSGSEARCH");
                if (StringUtils.isNotBlank((CharSequence)keyword)) {
                    paramMap.put("keyword", keyword);
                }
                if (StringUtils.isNotBlank((CharSequence)startTime)) {
                    paramMap.put("startTime", startTime);
                }
                if (StringUtils.isNotBlank((CharSequence)endTime)) {
                    paramMap.put("endTime", endTime);
                }
                paramMap.put("pageNumber", pageNumber);
                paramMap.put("pageSize", pageSize);
                paramMap.put("targetType", "1,2");
                paramMap.put("userid", userId);
                String msgType = "";
                msgType = StringUtils.isBlank((CharSequence)keyword) ? "RC:TxtMsg,RC:ImgMsg,RC:VcMsg,RC:LBSMsg,FW:attachmentMsg,FW:PersonCardMsg,FW:richTextMsg,FW:LinkMsg,FW:NewsMsg,FW:CustomShareMsg,FW:VoIPMsg,FW:Extension_Msg,RC:PublicNoticeMsg" : "RC:TxtMsg,FW:attachmentMsg,FW:CustomShareMsg";
                paramMap.put("Classname", msgType);
                paramMap.put("searchType", "group");
                if (senderId != null && !senderId.isEmpty()) {
                    paramMap.put("fromUserId", senderId);
                }
                HashMap<String, String> sortMap = new HashMap<String, String>();
                sortMap.put("Datetime", "false");
                HashMap<String, Integer> aggMap = new HashMap<String, Integer>();
                aggMap.put("groupId", 1);
                boolean flag = MegSearch.searchValidate((String)"MSGSEARCH");
                Map weiSouMap = MegSearch.search(paramMap, sortMap, aggMap);
                map = this.convertWeiSouToClient(weiSouMap, pageNumber, pageSize, userId);
            } else {
                if (weiSouEnable && !msgSearchValidate) {
                    logger.info("==============ChatSeach\u5fae\u641c\u5df2\u5f00\u542f\uff0c\u5fae\u641c\u7d22\u5f15\u4e0d\u53ef\u7528\u3002===================");
                }
                if (JiveGlobals.getBooleanProperty((String)"searchChatMsg", (boolean)true)) {
                    ChatSearchIQDao chatSearchIQDao = new ChatSearchIQDao();
                    map = chatSearchIQDao.searchChatId(pageNumber, pageSize, keyword, userId, senderId, startTime, endTime);
                } else {
                    map = new HashMap();
                }
            }
        } else {
            logger.error("\u975e\u6cd5\u7684iq\u8bf7\u6c42\u7c7b\u578b\uff0c\u5305\u5185\u5bb9\u4e3a\uff1a", (Object)packet.toString());
            return null;
        }
        result.put("searchedChat", map.get("searchedChat"));
        result.put("pageNumber", map.get("pageNumber"));
        result.put("pageSize", map.get("pageSize"));
        result.put("totalCount", map.get("totalCount"));
        result.put("chatMessage", map.get("chatMessage"));
        IQ resultIq = IQ.createResultIQ((IQ)packet);
        Element element = resultIq.getElement().addElement("query");
        element.addText(JSON.toJSONString(result));
        return resultIq;
    }

    private String getUserIDByUsername(String username) {
        if (username.contains("|")) {
            int index = username.indexOf("|");
            return username.substring(0, index);
        }
        return username;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> convertWeiSouToClient(Map<String, Object> weiSouMap, Integer pageNumber, Integer pageSize, String userId) {
        HashMap mapChatMessage;
        ArrayList<String> listGroupId;
        HashMap<String, Object> result;
        block14: {
            result = new HashMap<String, Object>();
            listGroupId = new ArrayList<String>();
            mapChatMessage = new HashMap();
            List listResult = (List)weiSouMap.get("result");
            if (null == listResult) break block14;
            GroupManager groupManager = GroupManager.getInstance();
            for (int i = 0; i < listResult.size(); ++i) {
                Map mapWei;
                block15: {
                    HashMap<String, String> mapChatDetail;
                    String groupIconUrl;
                    String groupName;
                    String targetType;
                    String targetId;
                    block13: {
                        block16: {
                            String groupId;
                            mapWei = (Map)listResult.get(i);
                            targetId = mapWei.get("targetid") == null ? "" : mapWei.get("targetid").toString();
                            targetType = mapWei.get("targetType") == null ? "" : mapWei.get("targetType").toString();
                            String msgCount = mapWei.get("msgCount") == null ? "" : mapWei.get("msgCount").toString();
                            groupName = "";
                            groupIconUrl = "";
                            Group group = null;
                            String groupType = "0";
                            mapChatDetail = new HashMap<String, String>();
                            if (targetType.equals("2")) {
                                try {
                                    group = groupManager.getGroup(targetId);
                                    if (group == null) continue;
                                    groupName = group.getDescription();
                                    PersistableMap groupProp = group.getProperties();
                                    if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                        groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                                    }
                                    if (groupProp != null && groupProp.containsKey((Object)"groupType")) {
                                        groupType = (String)groupProp.get((Object)"groupType");
                                    }
                                    String secretGroupType = "0";
                                    if (groupProp != null && groupProp.containsKey((Object)"secretGroupType")) {
                                        secretGroupType = (String)groupProp.get((Object)"secretGroupType");
                                    }
                                    if ("1".equals(secretGroupType)) {
                                        DatabaseUtil db = new DatabaseUtil();
                                        mapChatDetail.put("secretGroupTargetId", db.getSecretChatTargetId(userId, targetId));
                                    }
                                    listGroupId.add(targetId);
                                    mapChatDetail.put("msgCount", msgCount);
                                    mapChatDetail.put("targetId", targetId);
                                    mapChatDetail.put("targetType", targetType);
                                    mapChatDetail.put("groupName", groupName);
                                    mapChatDetail.put("groupIconUrl", groupIconUrl);
                                    mapChatDetail.put("groupType", groupType);
                                    mapChatDetail.put("secretGroupType", secretGroupType);
                                    mapChatMessage.put(targetId, mapChatDetail);
                                }
                                catch (Exception e) {
                                    logger.error("convertWeiSouToClient .group not found.mapWei:{}", (Object)JSON.toJSONString((Object)mapWei).toString());
                                }
                                continue;
                            }
                            if (!"1".equals(targetType)) break block15;
                            mapChatDetail.put("msgCount", msgCount);
                            String string = groupId = mapWei.get("groupId") == null ? "" : mapWei.get("groupId").toString();
                            if (!StringUtils.isNotBlank((CharSequence)groupId)) break block16;
                            String[] arrayGroupId = groupId.split("-");
                            if (arrayGroupId.length != 2) {
                                logger.warn("convertWeiSouToClient .arrayGroupId length is not 2.mapWei:{}", (Object)JSON.toJSONString((Object)mapWei).toString());
                                continue;
                            }
                            if (userId.equals(arrayGroupId[0])) {
                                targetId = arrayGroupId[1];
                                break block13;
                            } else if (userId.equals(arrayGroupId[1])) {
                                targetId = arrayGroupId[0];
                                break block13;
                            } else {
                                logger.warn("convertWeiSouToClient .arrayGroupId is not has userId.mapWei:{}", (Object)JSON.toJSONString((Object)mapWei).toString());
                                continue;
                            }
                        }
                        logger.warn("convertWeiSouToClient .groupId is null.mapWei:{}", (Object)JSON.toJSONString((Object)mapWei).toString());
                        continue;
                    }
                    listGroupId.add(targetId);
                    mapChatDetail.put("targetId", targetId);
                    mapChatDetail.put("targetType", targetType);
                    mapChatDetail.put("groupName", groupName);
                    mapChatDetail.put("groupIconUrl", groupIconUrl);
                    mapChatMessage.put(targetId, mapChatDetail);
                    continue;
                }
                logger.warn("convertWeiSouToClient .targetType is not 1 or 2.mapWei:{}", (Object)JSON.toJSONString((Object)mapWei).toString());
            }
        }
        result.put("searchedChat", listGroupId);
        result.put("pageNumber", pageNumber);
        result.put("pageSize", pageSize);
        result.put("totalCount", weiSouMap.get("count"));
        result.put("chatMessage", mapChatMessage);
        return result;
    }
}

