/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import java.util.Collection;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.bean.CloseMessage;
import org.jivesoftware.openfire.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentManager;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class CloseSessionIQHandle
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(CloseSessionIQHandle.class);
    private IQHandlerInfo info = new IQHandlerInfo("query", this.SESSIONCLOSE_XMLNS);
    private String SESSIONCLOSE_XMLNS = "http://weaver.com.cn/sessionClose";
    private ComponentManager componentManager;
    private Component component;

    public CloseSessionIQHandle(ComponentManager componentManager, Component component) {
        super("CloseSessionIQHandle");
        this.component = component;
        this.componentManager = componentManager;
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        if (packet.getFrom() == null) {
            Log.debug("invalid iq request, from is null, id:{}", (Object)packet.getID());
            return null;
        }
        IQ reply = IQ.createResultIQ((IQ)packet);
        if (packet.getType().equals((Object)IQ.Type.set)) {
            ClusterRedisUtil clusterRedisUtil;
            String clusterNode;
            JID tJID = new JID(packet.getFrom().getNode(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "pc", true);
            JID fJID = new JID(packet.getFrom().getNode(), "confirm." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "mobile", true);
            Message msg = new Message();
            msg.setFrom(fJID);
            msg.setTo(tJID);
            msg.setID(packet.getID());
            msg.setType(Message.Type.chat);
            CloseMessage cm = new CloseMessage("");
            msg.setBody(cm.toString());
            boolean hasRoute = false;
            Log.info("msg :{}", (Object)msg.toString());
            Collection sessions = this.sessionManager.getSessions(tJID.getNode());
            for (ClientSession clientSession : sessions) {
                if (!tJID.getResource().equals(clientSession.getAddress().getResource())) continue;
                clientSession.deliverRawText(msg.toString());
                clientSession.close();
                hasRoute = true;
            }
            ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
            if (!hasRoute && clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(tJID)) != null && !clusterNode.isEmpty()) {
                clusterRedisUtil.saveToRedis(clusterNode, msg);
            }
        } else {
            Log.error("packet iq type is not set ,packet : {}", (Object)packet.toString());
            return null;
        }
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

