/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.util.ConversationProcessUtil;
import org.jivesoftware.openfire.plugin.util.DatabaseUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class ConversationIQHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(ConversationIQHandler.class);
    private static final String CONVERSATION_NAMESPACE = "http://weaver.com.cn/getConversation";
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://weaver.com.cn/getConversation");

    public ConversationIQHandler() {
        super("ConversationIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        JID fromJID = packet.getFrom();
        long startTime = System.currentTimeMillis();
        if (fromJID == null) {
            Log.warn("ConversationIQHandler.from is null.packet:{}", (Object)packet.toString());
            return null;
        }
        if (!IQ.Type.get.equals((Object)packet.getType())) {
            Log.warn("ConversationIQHandler.type is not get.packet:{}", (Object)packet.toString());
        }
        String userid = this.getUserIDByUsername(fromJID.getNode());
        String elementText = packet.getElement().elementText("query");
        JSONObject json = JSON.parseObject((String)elementText);
        int pageSize = 300;
        if (json != null && json.containsKey((Object)"pageSize")) {
            pageSize = json.getIntValue("pageSize");
        }
        Long lasttime = null;
        if (json != null && json.containsKey((Object)"lasttime")) {
            lasttime = json.getLong("lasttime");
        }
        DatabaseUtil db = new DatabaseUtil();
        Map<String, Object> result = null;
        String targetType = null;
        if (JiveGlobals.getBooleanProperty((String)"xmpp.close.pc", (boolean)false) && "pc".equals(fromJID.getResource())) {
            targetType = "111,3,101,102,103";
        }
        if (JiveGlobals.getBooleanProperty((String)"xmpp.close.mobile", (boolean)false) && ("mobile".equals(fromJID.getResource()) || "pad".equals(fromJID.getResource()))) {
            targetType = "111,3,101,102,103";
        }
        result = db.getIMConversation(userid, pageSize, lasttime, targetType);
        result = ConversationProcessUtil.processConversation(result, fromJID.getResource());
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        String str = JSON.toJSONString(result).toString();
        ele.addText(str);
        long endTime = System.currentTimeMillis();
        Log.info("ConversationIQHandler success.fromJID:{},pageSize:{},lasttime:{},result:{},cost:{} ms", new Object[]{fromJID, pageSize, lasttime, str, endTime - startTime});
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }

    private String getUserIDByUsername(String username) {
        if (username.contains("|")) {
            int index = username.indexOf("|");
            return username.substring(0, index);
        }
        return username;
    }
}

